/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.List;

public class InfoViewTemplateHelper {
    private static final String DEFAULT_INFOVIEW_TEMP_PREFIX = "detail";
    private static InfoViewEmployMgr m_oIVEmployMgr = null;

    private static InfoViewEmployMgr getInfoViewEmployMgr() {
        if (m_oIVEmployMgr == null) {
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        }
        return m_oIVEmployMgr;
    }

    public static String generateContent(MethodContext _oContext, User _currUser) throws WCMException {
        PublishPageContext pageContext = InfoViewTemplateHelper.buildPageContext(_oContext);
        if (pageContext == null) {
            return null;
        }
        Template template = InfoViewTemplateHelper.getTemplate(_oContext, pageContext, _currUser);
        if (template == null) {
            return null;
        }
        String[] aContents = PageGenerator.generateContent(pageContext, template);
        if (aContents == null) {
            return null;
        }
        int nPageNum = _oContext.getValue("Page", 1);
        if (nPageNum >= aContents.length || nPageNum < 1) {
            nPageNum = 1;
        }
        if (nPageNum >= 1) {
            return aContents[nPageNum - 1];
        }
        return null;
    }

    private static PublishPageContext buildPageContext(MethodContext _oContext) throws WCMException {
        int nDocumentId = _oContext.getValue("DocumentId", 0);
        IPublishContent content = (IPublishContent)PublishElementFactory.lookupElement(605, nDocumentId);
        PublishTaskContext taskContext = new PublishTaskContext(null, content.getFolder());
        PublishPageContext pageContext = new PublishPageContext(content, taskContext);
        return pageContext;
    }

    public static Template getDetailTemplate(PublishPageContext _pageContext) throws WCMException {
        IPublishContent content = (IPublishContent)_pageContext.getPageElement();
        content.setFolder(content.getRealHome());
        Template template = content.getDetailTemplate();
        if (template == null) {
            throw new WCMException("[" + content.getSubstance() + I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        return template;
    }

    private static Template getTemplate(MethodContext _oContext, PublishPageContext _pageContext, User _currUser) throws WCMException {
        int nInfoViewId = _oContext.getValue("InfoViewId", 0);
        if (nInfoViewId <= 0) {
            int nChannelId = _oContext.getValue("ChannelId", 0);
            if (nChannelId <= 0) {
                throw new WCMException(10, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label2", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u672a\u4f20\u5165InfoViewId/ChannelId\uff0c\u6216\u4f20\u5165\u7684\u503c\u65e0\u6548\uff01"));
            }
            List lstInfoViews = InfoViewTemplateHelper.getInfoViewEmployMgr().getEmployedInfoViews(101, nChannelId);
            BaseObj oInfoView = null;
            if (lstInfoViews != null && lstInfoViews.size() > 0) {
                oInfoView = (InfoView)lstInfoViews.get(0);
            }
            if (oInfoView == null) {
                throw new WCMException(10, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label3", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4f20\u5165\u7684ChannelId\u503c\u65e0\u6548\u6216\u8005\u680f\u76ee\u4e0d\u662f\u81ea\u5b9a\u4e49\u8868\u5355\u680f\u76ee\uff01"));
            }
            nInfoViewId = oInfoView.getId();
        }
        Template template = null;
        boolean bUseDetailTemp = _oContext.getValue("UseDetailTemp", false);
        if (bUseDetailTemp) {
            template = InfoViewTemplateHelper.getDetailTemplate(_pageContext);
        } else {
            Templates oTemplates = Templates.openWCMObjs(_currUser, null);
            String sTempIVType = CMyString.showNull(_oContext.getValue("TempNamePrefix"), DEFAULT_INFOVIEW_TEMP_PREFIX);
            String sTempName = InfoViewTemplateHelper.getTempName(sTempIVType, nInfoViewId);
            template = oTemplates.findByName(sTempName);
        }
        return template;
    }

    private static String getTempName(String _tempIVType, int _infoViewId) {
        return _tempIVType + "_" + _infoViewId;
    }

    public static String getContent(int nChannelId, String sTemplateContent, String sKey) throws WCMException {
        PublishPageContext pageContext = InfoViewTemplateHelper.buildPageContext(nChannelId);
        String[] aContents = null;
        try {
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDoc = parseMgr.parse(pageContext.getTemplate());
            if (tagDoc == null) {
                return null;
            }
            PublishTagContext tagContext = new PublishTagContext(pageContext);
            aContents = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
            if (aContents == null || aContents.length < 1) {
                return null;
            }
            return aContents[0];
        }
        catch (Exception ex) {
            throw new WCMException(237, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label4", "\u83b7\u5f97\u5e94\u7528\u6a21\u677f\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9\u5931\u8d25:'") + sTemplateContent + ")'", ex);
        }
    }

    private static PublishPageContext buildPageContext(int nChannelId) throws WCMException {
        IPublishElement element = PublishElementFactory.lookupElement(101, nChannelId);
        PublishTaskContext taskContext = new PublishTaskContext(null, element.getFolder());
        PublishPageContext pageContext = new PublishPageContext(element, taskContext);
        return pageContext;
    }
}

