/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.filter;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.presentation.util.LoginHelper;
import com.trs.webframework.controler.servlet.ServiceControler;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class InfoviewDataImportFilter
extends ServiceControler {
    private static final String APP_INFOGATE_IP = "APP_INFOGATE_IP";
    private static final Logger LOG = Logger.getLogger(InfoviewDataImportFilter.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        System.out.println("InfoviewDataImportFilter");
        request.setAttribute("RequestFilterIdentify", (Object)"INFOVIEW.DO");
        LoginHelper currLoginHelper = new LoginHelper(request, null);
        boolean zVirtuallyLogined = false;
        if (!currLoginHelper.checkLogin()) {
            if (!this.accessAble(request)) {
                response.setStatus(401);
                return;
            }
            zVirtuallyLogined = true;
            try {
                currLoginHelper.loginByIDS("system");
            }
            catch (WCMException ex) {
                LOG.warn((Object)"virtually login failed", (Throwable)ex);
            }
        }
        try {
            super.service(request, response);
        }
        finally {
            if (zVirtuallyLogined) {
                currLoginHelper.logout();
            }
        }
    }

    private boolean accessAble(HttpServletRequest request) {
        String ip = RemoteAddrUtil.getRemoteAddr(request);
        try {
            String sAllowIP = ConfigServer.getServer().getSysConfigValue(APP_INFOGATE_IP, "");
            System.out.println("sAllowIP->" + sAllowIP);
            System.out.println("ip->" + ip);
            LOG.debug((Object)("sAllowIP->" + sAllowIP));
            LOG.debug((Object)("ip->" + ip));
            String[] pAllowIP = sAllowIP.split(",");
            return CMyString.isAllowIP(pAllowIP, ip);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to check the infogate ip.", (Throwable)e);
            return false;
        }
    }
}

