/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.helper.ComplexFieldData;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class InfoViewHelper {
    private static Logger logger = Logger.getLogger(InfoViewHelper.class);
    private static InfoViewEmployMgr m_oIVEmployMgr = null;

    private InfoViewHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDOM4JDocument(String sFilePath) throws WCMException {
        WCMException _ex_ = null;
        Document document = null;
        InputStreamReader reader = null;
        try {
            InputStream fis = new FileService(sFilePath).getInputStream();
            reader = new InputStreamReader(fis, "utf-8");
            SAXReader saxReader = new SAXReader();
            document = saxReader.read((Reader)reader);
        }
        catch (Exception e) {
            _ex_ = new WCMException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (_ex_ != null) {
            throw _ex_;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseToDocument(String sXmlContent) throws WCMException {
        if (sXmlContent == null) {
            return null;
        }
        WCMException _ex_ = null;
        Document document = null;
        InputStreamReader reader = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(sXmlContent.getBytes("utf-8"));
            reader = new InputStreamReader((InputStream)bis, "utf-8");
            SAXReader saxReader = new SAXReader();
            document = saxReader.read((Reader)reader);
        }
        catch (Exception e) {
            _ex_ = new WCMException(e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (_ex_ != null) {
            throw _ex_;
        }
        return document;
    }

    public static void writeDOM4JDocument(Document document, String sFilePath) throws WCMException {
        OutputStream fos = null;
        try {
            fos = new FileService(sFilePath).getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(fos, "utf-8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer);
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (Exception e) {
            throw new WCMException(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static StringBuffer parseList2Json(List lstData) {
        StringBuffer sbJsonResult = new StringBuffer();
        sbJsonResult.append("[\n");
        boolean bFirst = true;
        for (Object dataItem : lstData) {
            if (!bFirst) {
                sbJsonResult.append(",\n");
            }
            bFirst = false;
            sbJsonResult.append(InfoViewHelper.parse2Json(dataItem));
        }
        sbJsonResult.append("\n]");
        return sbJsonResult;
    }

    public static StringBuffer parse2Json(Object object) {
        if (object instanceof List) {
            return InfoViewHelper.parseList2Json((List)object);
        }
        if (object instanceof Map) {
            return InfoViewHelper.parseMap2Json((Map)object);
        }
        if (object instanceof String) {
            return InfoViewHelper.parseString2Json((String)object);
        }
        return InfoViewHelper.parseString2Json(object.toString());
    }

    private static StringBuffer parseString2Json(String strData) {
        StringBuffer sbJsonResult = new StringBuffer();
        sbJsonResult.append("\"");
        sbJsonResult.append(CMyString.filterForJs(strData));
        sbJsonResult.append("\"");
        return sbJsonResult;
    }

    private static StringBuffer parseMap2Json(Map mapData) {
        StringBuffer sbJsonResult = new StringBuffer();
        sbJsonResult.append("{\n");
        boolean bFirst = true;
        Iterator iter = mapData.keySet().iterator();
        while (iter.hasNext()) {
            String sKey = iter.next().toString();
            if (!bFirst) {
                sbJsonResult.append(",\n");
            }
            bFirst = false;
            sbJsonResult.append("\"");
            sbJsonResult.append(CMyString.filterForJs(sKey));
            sbJsonResult.append("\":");
            sbJsonResult.append(InfoViewHelper.parse2Json(mapData.get(sKey)));
        }
        sbJsonResult.append("\n}");
        return sbJsonResult;
    }

    public static String getDBFieldsByFields(InfoView oInfoView, String sInfoPathFields, boolean bAppendTable) {
        if (!CMyString.isEmpty(sInfoPathFields)) {
            String[] arrInfoPathFields = sInfoPathFields.split(",");
            Object[] arrResult = InfoViewHelper.getDBFieldsByFields(oInfoView, arrInfoPathFields, bAppendTable);
            return CMyString.join(arrResult, ",");
        }
        return sInfoPathFields;
    }

    public static String[] getDBFieldsByFields(InfoView oInfoView, String[] arrInfoPathFields, boolean bAppendTable) {
        String sTrueTableName = oInfoView.getTrueTableName();
        if (arrInfoPathFields != null && arrInfoPathFields.length > 0) {
            ArrayList<String> oDBFields = new ArrayList<String>();
            try {
                oInfoView.allFields();
                for (int i = 0; i < arrInfoPathFields.length; ++i) {
                    String sFieldName = arrInfoPathFields[i];
                    if (InfoViewHelper.isInfoViewDefaultField(sFieldName)) {
                        oDBFields.add(bAppendTable ? sTrueTableName + "." + sFieldName : sFieldName);
                        continue;
                    }
                    if (InfoViewHelper.isSystemField(sFieldName)) {
                        oDBFields.add(sFieldName);
                        continue;
                    }
                    InfoViewField oField = oInfoView.getField(sFieldName = InfoViewHelper.infoPathToFieldName(sFieldName));
                    if (oField != null) {
                        String sTrueFieldName = null;
                        int nFromInfoViewId = InfoViewHelper.getNewRuleFromInfoViewId();
                        if (oField.getInfoViewID() < nFromInfoViewId) {
                            sTrueFieldName = InfoViewConstants.makeTrueFieldName(oField.getId());
                        } else {
                            sTrueFieldName = oField.getName();
                            sTrueFieldName = LetterConvertor.convertToFirstLetter(sTrueFieldName);
                        }
                        if (DBManager.getDBManager().getFieldInfo(sTrueTableName, sTrueFieldName) == null) continue;
                        oDBFields.add(bAppendTable ? sTrueTableName + "." + sTrueFieldName : sTrueFieldName);
                        continue;
                    }
                    oDBFields.add(arrInfoPathFields[i]);
                }
                String[] arrResult = new String[oDBFields.size()];
                oDBFields.toArray(arrResult);
                return arrResult;
            }
            catch (WCMException e) {
                return null;
            }
        }
        return arrInfoPathFields;
    }

    public static String getDBFieldByField(int _nInfoViewId, String sInfoPathField, boolean bAppendTable) {
        String sTrueTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        if (!CMyString.isEmpty(sInfoPathField)) {
            if (InfoViewHelper.isInfoViewDefaultField(sInfoPathField)) {
                return bAppendTable ? sTrueTableName + "." + sInfoPathField : sInfoPathField;
            }
            if (InfoViewHelper.isSystemField(sInfoPathField)) {
                return sInfoPathField;
            }
            try {
                Map oMapFields = InfoViewHelper.loadFieldsMap(_nInfoViewId);
                String oldField = sInfoPathField;
                sInfoPathField = InfoViewHelper.infoPathToFieldName(sInfoPathField);
                InfoViewField oField = (InfoViewField)oMapFields.get(sInfoPathField.toLowerCase());
                if (oField != null) {
                    String sTrueFieldName = null;
                    int nFromInfoViewId = InfoViewHelper.getNewRuleFromInfoViewId();
                    if (oField.getInfoViewID() < nFromInfoViewId) {
                        sTrueFieldName = InfoViewConstants.makeTrueFieldName(oField.getId());
                    } else {
                        sTrueFieldName = oField.getName();
                        sTrueFieldName = LetterConvertor.convertToFirstLetter(sTrueFieldName);
                    }
                    return bAppendTable ? sTrueTableName + "." + sTrueFieldName : sTrueFieldName;
                }
                return oldField;
            }
            catch (WCMException e) {
                return null;
            }
        }
        return sInfoPathField;
    }

    public static String infoPathToFieldName(String infoPathField) {
        String[] parts = infoPathField.split("/");
        ArrayList<String> lstParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            if (CMyString.isEmpty(parts[i])) continue;
            lstParts.add(parts[i].replaceAll("[^:]*:", ""));
        }
        return CMyString.join(lstParts, "_");
    }

    private static Map loadFieldsMap(int _nInfoViewId) throws WCMException {
        HashMap<String, InfoViewField> oMapFields = new HashMap<String, InfoViewField>();
        WCMFilter filter = new WCMFilter("", "INFOVIEWID=" + _nInfoViewId, "");
        try {
            InfoViewFields fields = new InfoViewFields(ContextHelper.getLoginUser());
            fields.open(filter);
            for (int i = 0; i < fields.size(); ++i) {
                InfoViewField field = (InfoViewField)fields.getAt(i);
                oMapFields.put(field.getName().toLowerCase(), field);
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label1", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u9879\u96c6\u5408\u51fa\u9519"), ex);
        }
        return oMapFields;
    }

    public static boolean isSystemField(String fieldName) {
        for (int i = 0; i < InfoViewConstants.SYSTEM_FIELD_NAMES.length; ++i) {
            if (!InfoViewConstants.SYSTEM_FIELD_NAMES[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInfoViewDefaultField(String fieldName) {
        for (int i = 0; i < InfoViewConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            InfoViewDataType fieldType = InfoViewConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String sFieldName = fieldType.getKey();
            if (!sFieldName.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static InfoViewEmployMgr getInfoViewEmployMgr() {
        if (m_oIVEmployMgr == null) {
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        }
        return m_oIVEmployMgr;
    }

    public static InfoView getInfoView(Channel _oChannel) throws WCMException {
        if (_oChannel.getType() != 13) {
            return null;
        }
        List list = InfoViewHelper.getInfoViewEmployMgr().getEmployedInfoViews(_oChannel);
        if (list != null && list.size() > 0) {
            return (InfoView)list.get(0);
        }
        return null;
    }

    public static String[] splitSelectFields(String sOutlineDBFields, String sTrueTableName) throws WCMException {
        logger.debug((Object)("sOutlineDBFields:" + sOutlineDBFields));
        String[] arrSelectFields = new String[]{"", ""};
        sTrueTableName = sTrueTableName.toUpperCase();
        if (!CMyString.isEmpty(sOutlineDBFields)) {
            String[] selectFields = sOutlineDBFields.split(",");
            DBManager dbManager = DBManager.getDBManager();
            for (int i = 0; i < selectFields.length; ++i) {
                boolean bIsInfoViewField;
                String sFieldName = selectFields[i].trim();
                if (CMyString.isEmpty(sFieldName) || sFieldName.startsWith("_")) continue;
                logger.debug((Object)(sTrueTableName + ".FieldName[" + i + "]:" + sFieldName));
                boolean bl = bIsInfoViewField = sFieldName.toUpperCase().startsWith(sTrueTableName + ".") || dbManager.getFieldInfo(sTrueTableName, sFieldName) != null;
                if (bIsInfoViewField) {
                    if (!CMyString.isEmpty(arrSelectFields[1])) {
                        arrSelectFields[1] = arrSelectFields[1] + ',';
                    }
                    arrSelectFields[1] = arrSelectFields[1] + sFieldName;
                    continue;
                }
                if (dbManager.getFieldInfo("WCMDOCUMENT", sFieldName) == null && dbManager.getFieldInfo("WCMCHNLDOC", sFieldName) == null) continue;
                if (!CMyString.isEmpty(arrSelectFields[0])) {
                    arrSelectFields[0] = arrSelectFields[0] + ',';
                }
                arrSelectFields[0] = arrSelectFields[0] + sFieldName;
            }
        }
        return arrSelectFields;
    }

    public static ComplexFieldData makeComplexFieldData(String _sFieldId, String _sFieldName, String _sVal, String _sParentFlag, InfoViewData _docData) {
        if (CMyString.isEmpty(_sFieldId) || CMyString.isEmpty(_sFieldName) || _docData == null) {
            return null;
        }
        ComplexFieldData result = new ComplexFieldData();
        try {
            result.setFieldId(_sFieldId);
            result.setFieldName(_sFieldName);
            result.setFieldValue(_sVal);
            result.setParentFlag(_sParentFlag);
            result.setInfoviewId(_docData.getInfoViewId());
            result.setInfoviewDataId(_docData.getId());
            result.setDocumentId(_docData.getDocumentId());
            result.setPostTime(_docData.getCrTime());
        }
        catch (WCMException ex) {
            logger.warn((Object)(I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label2", "\u7531\u4e8e\u4ee5\u4e0b\u539f\u56e0\u5bfc\u81f4\u521b\u5efa[ComplexFieldData]\u5bf9\u8c61\u5931\u8d25\uff1a") + ex.getMessage()));
            return null;
        }
        return result;
    }

    public static void restoreComplexFields(List _datas, int _nInfoviewDataId, int _nDocumentId) throws WCMException {
        InfoViewHelper.buildComplexFields(_datas, _nInfoviewDataId, _nDocumentId, true);
    }

    public static void buildComplexFields(List _datas, int _nInfoviewDataId, int _nDocumentId) throws WCMException {
        InfoViewHelper.buildComplexFields(_datas, _nInfoviewDataId, _nDocumentId, false);
    }

    public static void buildComplexFields(List _datas, int _nInfoviewDataId, int _nDocumentId, boolean _bIsRestore) throws WCMException {
        if (_nInfoviewDataId <= 0) {
            return;
        }
        if (_bIsRestore) {
            InfoViewHelper.clearComplexFieldDatas(_nInfoviewDataId);
        }
        if (_datas == null || _datas.isEmpty()) {
            return;
        }
        String sLastParentFlag = null;
        int nFieldOrder = 0;
        for (int i = 0; i < _datas.size(); ++i) {
            String sParentFlag;
            ComplexFieldData data = (ComplexFieldData)_datas.get(i);
            if (data == null) continue;
            if (!_bIsRestore) {
                data.setInfoviewDataId(_nInfoviewDataId);
                data.setDocumentId(_nDocumentId);
            }
            if (!(sParentFlag = CMyString.showEmpty(data.getParentFlag())).equals(sLastParentFlag)) {
                ++nFieldOrder;
                sLastParentFlag = sParentFlag;
            }
            data.setFieldOrder(nFieldOrder);
            data.save(InfoViewHelper.getLoginUser());
        }
    }

    public static void clearComplexFieldDatas(int _nInfoviewDataId) throws WCMException {
        if (_nInfoviewDataId <= 0) {
            return;
        }
        DBManager.getDBManager().sqlExecuteUpdate("delete from XWCMCOMPLEXFIELDDATA where InfoviewDataId=" + _nInfoviewDataId);
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int nFromInfoViewId = -1;
        String sConfigValue = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            nFromInfoViewId = Integer.parseInt(sConfigValue);
        }
        catch (NumberFormatException e) {
            logger.error((Object)(I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label3", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + sConfigValue + "]"), (Throwable)e);
            nFromInfoViewId = -1;
        }
        return nFromInfoViewId;
    }
}

