/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.filter;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.filter.IQueryFilter;
import com.trs.components.filter.QueryFilterFactory;
import com.trs.components.metadata.service.DefaultChannelMakerCenter;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

class PublishQueryFilter
implements IQueryFilter {
    public static final int FILTER_TYPE = 2;

    PublishQueryFilter() {
    }

    private WebSite makeWebSite(MethodContext _mc) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nSiteId = _mc.getValue("SiteID", 0);
        if (nSiteId != 0) {
            return WebSite.findById(nSiteId);
        }
        String sSiteIds = _mc.getValue("SiteIds");
        if (!CMyString.isEmpty(sSiteIds)) {
            WebSites oWebSites = WebSites.findByIds(loginUser, sSiteIds);
            int nSize = oWebSites.size();
            for (int i = 0; i < nSize; ++i) {
                WebSite oWebSite = (WebSite)oWebSites.getAt(i);
                if (oWebSite == null) continue;
                return oWebSite;
            }
            return null;
        }
        int nChannelId = _mc.getValue("ChannelId", 0);
        if (nChannelId != 0) {
            Channel oChannel = Channel.findById(nChannelId);
            return oChannel.getSite();
        }
        String sChannelIds = _mc.getValue("ChannelIds");
        if (!CMyString.isEmpty(sChannelIds)) {
            Channels oChannels = Channels.findByIds(loginUser, sChannelIds);
            int nSize = oChannels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel oChannel = (Channel)oChannels.getAt(i);
                if (oChannel == null) continue;
                return oChannel.getSite();
            }
            return null;
        }
        int nViewId = _mc.getValue("ViewId", 0);
        Channel oChannel = DefaultChannelMakerCenter.getInstance().makeDefaultChannel(loginUser, nViewId);
        if (oChannel != null) {
            return oChannel.getSite();
        }
        Channels oChannels = DefaultChannelMakerCenter.getInstance().getAvailableChannels(loginUser, nViewId);
        int nSize = oChannels.size();
        for (int i = 0; i < nSize; ++i) {
            oChannel = (Channel)oChannels.getAt(i);
            if (oChannel == null) continue;
            return oChannel.getSite();
        }
        return null;
    }

    @Override
    public WCMFilter getFilter(MethodContext _mc) throws WCMException {
        WebSite oSite = this.makeWebSite(_mc);
        if (oSite == null) {
            throw new WCMException(I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label5", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7684\u4e0a\u4e0b\u6587ChannelId/SiteId"));
        }
        IFolderPubStatusCacheMgr oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] pStatus = oCacheMgr.findStatusesCanDoIncreasePub(oSite.getWCMType(), oSite.getId());
        String sWhere = null;
        WCMFilter filter = new WCMFilter();
        if (pStatus == null) {
            pStatus = new int[]{-1};
        }
        for (int i = 0; i < pStatus.length; ++i) {
            sWhere = sWhere == null ? "WCMChnlDoc.DocStatus in(?" : sWhere + ",?";
            filter.addSearchValues(i, pStatus[i]);
        }
        sWhere = sWhere != null ? sWhere + ")" : "WCMChnlDoc.DocStatus in(1,2,16,18)";
        filter.setWhere(sWhere);
        return filter;
    }
}

