/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetServer;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.MasterMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.special.Special;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.wcag2.HTMLUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WidgetServer
implements IWidgetServer {
    private static Logger logger = Logger.getLogger(WidgetServer.class);
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)<div[^>]*>@!@--(\\d+)--@!@</div>");
    private static String m_oInstanceInTemplate = "(?is)<TRS_Widget\\s+id=(['\"]){0}\\1\\s*>.*?</TRS_Widget>";
    private static Pattern m_oTRSWidgetPattern = Pattern.compile("(?is)<TRS_Widget\\s+id=(['\"])(\\d+)\\1\\s*>.*?</TRS_Widget>");
    private static Pattern m_oBackgroundImagePattern = Pattern.compile("(?im)(<[^>]*?url\\((?:'|\"|&quot;)?)[^>]*?\\/([A-Z]{1,2}\\d+\\.[^>]+?)((?:'|\"|&quot;)?\\)[^>]*?>)");
    IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
    private TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");

    private String getNewTempName(String _sRealName, IPublishFolder _folder) throws WCMException {
        String sTempName = _sRealName;
        int k = 1;
        TemplateCacheMgr manager = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        while (manager.lookupByName(_folder.getRoot(), sTempName) != null) {
            sTempName = _sRealName + "_" + k;
            ++k;
        }
        return sTempName;
    }

    @Override
    public Template createTemplateFromMaster(IPublishFolder _oPageFolder, Master _oMaster, int _nMasterType) throws WCMException {
        IMasterMgr currMasterMgr = (IMasterMgr)DreamFactory.createObjectById("IMasterMgr");
        String sTempName = "template";
        switch (_nMasterType) {
            case 3: {
                sTempName = "\u6587\u6863\u9875\u9762\u6a21\u677f";
                break;
            }
            case 1: {
                sTempName = "\u9996\u9875\u57fa\u51c6\u6a21\u677f";
                break;
            }
            case 2: {
                sTempName = "\u5206\u7c7b\u9996\u9875\u6a21\u677f";
                break;
            }
        }
        Template template = Template.createNewInstance();
        template.setName(this.getNewTempName(sTempName + _oPageFolder.getId(), _oPageFolder.getFolder()));
        template.setFolder(_oPageFolder);
        template.setType(_nMasterType == 3 ? 2 : 1);
        template.setProperty("Visual", true);
        this.setTemplateContentFromMaster(template, _oMaster, _nMasterType);
        return template;
    }

    private Template setTemplateContentFromMaster(Template _template, Master oMaster, int _nFileType) throws WCMException {
        int nMasterId = oMaster.getId();
        String sMasterFileName = oMaster.getFileName();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(sMasterFileName, 0);
        if (!CMyFile.fileExists(sFilePath + sMasterFileName)) {
            throw new WCMException(CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label14", "\u6307\u5b9a\u7684\u6bcd\u677f[Id={0}]\u7684\u6bcd\u677f\u6587\u4ef6[{1}]\u4e0d\u5b58\u5728"), new String[]{CMyString.numberToStr(nMasterId), sMasterFileName}));
        }
        String sUnZipPath = sFilePath + "unZip" + CMyFile.extractMainFileName(sMasterFileName) + File.separatorChar;
        try {
            String sCurrFileName;
            String sAbsoluteFileName;
            String sFileFlag;
            HashMap<String, String> hAllFiles = new HashMap<String, String>();
            CMyUnzip myUnzip = new CMyUnzip();
            myUnzip.setZipFile(sFilePath + sMasterFileName);
            myUnzip.unzip(sUnZipPath, true);
            Enumeration eItems = myUnzip.getItems();
            ZipEntry ze = null;
            String sFileNameOfMaster = null;
            String string = sFileFlag = _nFileType == 3 ? "detail.html" : "index.html";
            while (eItems.hasMoreElements()) {
                ze = (ZipEntry)eItems.nextElement();
                if (ze.isDirectory()) continue;
                sAbsoluteFileName = sUnZipPath + ze.getName().replace('/', File.separatorChar);
                sCurrFileName = CMyFile.extractFileName(sAbsoluteFileName);
                hAllFiles.put(sCurrFileName.toLowerCase(), sAbsoluteFileName);
                if (sCurrFileName.toLowerCase().indexOf(".html") == -1) continue;
                sFileNameOfMaster = ze.getName();
                if (!sCurrFileName.equalsIgnoreCase(sFileFlag)) continue;
                break;
            }
            while (eItems.hasMoreElements()) {
                ze = (ZipEntry)eItems.nextElement();
                if (ze.isDirectory()) continue;
                sAbsoluteFileName = sUnZipPath + ze.getName().replace('/', File.separatorChar);
                sCurrFileName = CMyFile.extractFileName(sAbsoluteFileName);
                hAllFiles.put(sCurrFileName.toLowerCase(), sAbsoluteFileName);
            }
            if (sFileNameOfMaster == null) {
                CMyFile.deleteDir(sUnZipPath);
                return null;
            }
            String sFile = sUnZipPath + sFileNameOfMaster;
            String sEncode = CharsetDetector.detect(sFile);
            String sFileContent = CMyFile.readFile(sFile, sEncode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u7684\u6bcd\u677f\u5185\u5bb9\uff1a\n" + sFileContent));
            }
            String sContent = TagParseHelper.parseContent(_template.getFolder(), sFileContent, "EDIT")[0];
            sContent = sContent.replaceAll("(?is)(</?)#(TRS)", "$1$2");
            _template.setText(sContent);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6bcd\u677f\u89e3\u6790\u540e\u6a21\u677f\u7684\u5185\u5bb9\uff1a\n" + sContent));
            }
            TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
            templateMgr.processContent(_template, hAllFiles, true, 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6a21\u677f\u5904\u7406\u5b8c\u9644\u4ef6\u540e\u7684\u5185\u5bb9\uff1a\n" + _template.getText()));
            }
            CMyFile.deleteDir(sUnZipPath);
            return _template;
        }
        catch (Exception e) {
            CMyFile.deleteDir(sUnZipPath);
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label15", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25"), e);
        }
    }

    @Override
    public String parseToEditContent(IPublishElement _oPageElement, String _sTemplateContent) throws Exception {
        return TagParseHelper.parseContent(_oPageElement, _sTemplateContent, "EDIT")[0];
    }

    @Override
    public String parseToEditContent(IPublishElement _oPageElement, Template _oTemplateForEdit) throws Exception {
        String sAppendixPath = FilesMan.getFilesMan().getTemplateAppendixPath(_oTemplateForEdit.getRootType(), _oTemplateForEdit.getRootId(), 1, true);
        return TagParseHelper.parseContent(_oPageElement, _oTemplateForEdit.getTextWithImgFilter(sAppendixPath, true), "EDIT")[0];
    }

    @Override
    public String parseToEditContent(IPublishElement pageElement, WidgetInstance widgetInstance) throws Exception {
        String sContent = this.replaceWidgetInstParameters(widgetInstance);
        if (CMyString.isEmpty(sContent)) {
            return "";
        }
        return TagParseHelper.parseContent(pageElement, sContent, "EDIT")[0];
    }

    @Override
    public String replaceWidgetInstParameters(WidgetInstance widgetInstance) throws WCMException {
        String sWStyleName;
        Widget oWidget = widgetInstance.getWidget();
        String sTemplateContent = oWidget.getWidgetcontent();
        Map parameters = this.m_oWidgetInstParameterMgr.getParameters(widgetInstance);
        Pattern pattern = Pattern.compile("(?is)^<[^>]*trs-composite[^>]*>");
        Matcher matcher = pattern.matcher(sTemplateContent);
        if (matcher.find() && !CMyString.isEmpty(sWStyleName = (String)parameters.get("WSTYLEID"))) {
            parameters.put("WSTYLEID", sWStyleName + "-composite");
        }
        sTemplateContent = CMyString.parsePageVariables(sTemplateContent, parameters, WidgetParameter.PARAMETER_FLAG);
        return sTemplateContent;
    }

    @Override
    public String parseToTemplate(String sVisualHtml) throws WCMException {
        Matcher matcher = m_oInstancePattern.matcher(sVisualHtml);
        StringBuffer sbHtml = new StringBuffer(sVisualHtml.length());
        int nInstanceId = 0;
        int nStartIndex = 0;
        int nEndIndex = 0;
        while (matcher.find()) {
            nStartIndex = matcher.start();
            sbHtml.append(sVisualHtml.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            nInstanceId = Integer.parseInt(matcher.group(1));
            WidgetInstance widgetInstance = WidgetInstance.findById(nInstanceId);
            sbHtml.append("<TRS_Widget id='").append(nInstanceId).append("'>");
            sbHtml.append(this.replaceWidgetInstParameters(widgetInstance));
            sbHtml.append("</TRS_Widget>");
        }
        if (nEndIndex < sVisualHtml.length()) {
            sbHtml.append(sVisualHtml.substring(nEndIndex));
        }
        return this.formatBackgroundImage(sbHtml.toString());
    }

    private String formatBackgroundImage(String sVisualHtml) {
        return sVisualHtml;
    }

    @Override
    public void synchronizeWidgetInstances(Template template) throws WCMException {
        TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        TagDocument doc = null;
        try {
            doc = parseMgr.parse(template);
        }
        catch (Exception e) {
            throw new WCMException("\u540c\u6b65\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u8fc7\u7a0b\u4e2d\uff0c\u51fa\u73b0\u5f02\u5e38", e);
        }
        StringBuffer sbWhere = new StringBuffer();
        StringBuffer sbIds = new StringBuffer();
        String sText = template.getText();
        Pattern m_oParseWidget = Pattern.compile("(?is)id=trs-widget-(\\d+?)\\s");
        Matcher widgetMatcher = m_oParseWidget.matcher(sText);
        while (widgetMatcher.find()) {
            sbWhere.append("?,");
            sbIds.append(Integer.parseInt(widgetMatcher.group(1).trim())).append(",");
        }
        Iterator iterator = doc.findItems("TRS_WIDGET");
        while (iterator.hasNext()) {
            TagItem item = (TagItem)iterator.next();
            sbWhere.append("?,");
            sbIds.append(item.getIntAttribute("id", 0)).append(",");
        }
        if (sbWhere.length() <= 0) {
            sbWhere.append("?,");
            sbIds.append("0,");
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbIds.setLength(sbIds.length() - 1);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("delete from ");
        sbSQL.append("XWCMWIDGETINSTPARAMETER");
        sbSQL.append(" where WidgetInstId in ( select WidgetInstanceId from ");
        sbSQL.append("XWCMWIDGETINSTANCE");
        sbSQL.append(" where templateid=?");
        sbSQL.append(")");
        sbSQL.append(" and WidgetInstId not in (");
        sbSQL.append(sbWhere);
        sbSQL.append(")");
        sbIds.insert(0, template.getId() + ",");
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sbSQL.toString()}, CMyString.splitToInt(sbIds.toString(), ","));
        sbSQL.setLength(0);
        sbSQL.append("delete from ");
        sbSQL.append("XWCMWIDGETINSTANCE");
        sbSQL.append(" where templateid=? and ");
        sbSQL.append("WIDGETINSTANCEID");
        sbSQL.append(" not in(");
        sbSQL.append(sbWhere);
        sbSQL.append(")");
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sbSQL.toString()}, CMyString.splitToInt(sbIds.toString(), ","));
    }

    @Override
    public void insertStyleTag(Special special, Template template) throws WCMException, Exception {
        String sStyleName;
        PageStyle style;
        String content = template.getText();
        TagDocument tagDoc = TagDocumentReader.read(content);
        Iterator itr = tagDoc.findItems("TRS_PAGESTYLE");
        boolean hasFound = false;
        if (itr.hasNext()) {
            hasFound = true;
        }
        if ((style = PageStyle.findByName(sStyleName = special.getStyleName())) == null) {
            throw new WCMException("\u4e13\u9898\u5173\u8054\u7684\u98ce\u683c\u4e0d\u5b58\u5728\uff01[StyleName=" + sStyleName + "]");
        }
        String sAppendString = "<TRS_PAGESTYLE id=\"" + style.getId() + "\" name=\"" + sStyleName + "\"/>";
        if (!hasFound) {
            List tags = HTMLUtil.findTagOuterHTML(content, "HEAD");
            if (tags.size() > 0) {
                int[] pos = (int[])tags.get(0);
                String innerHTML = HTMLUtil.getEleInnerHTML(content, pos);
                template.setText(content.substring(0, pos[2]) + innerHTML + sAppendString + content.substring(pos[3]));
            } else {
                content = sAppendString + content;
                template.setText(content);
            }
        } else {
            content = content.replaceAll("(?i)<TRS_PAGESTYLE [^>]*(?:/>|></TRS_PAGESTYLE>)", sAppendString);
            template.setText(content);
        }
        TemplateMgr oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        oTemplateMgr.save(template, null, true, 2);
    }

    @Override
    public void refreshWidgetForTemplate(WidgetInstance instance) throws WCMException {
        int nTemplateId = instance.getTemplateId();
        Template temp = Template.findById(nTemplateId);
        if (temp == null) {
            return;
        }
        String sText = temp.getText();
        String sRegex = CMyString.format(m_oInstanceInTemplate, new int[]{instance.getId()});
        StringBuffer sbHtml = new StringBuffer(2000);
        sbHtml.append("<TRS_Widget id='").append(instance.getId()).append("'>");
        sbHtml.append(this.replaceWidgetInstParameters(instance));
        sbHtml.append("</TRS_Widget>");
        temp.setText(sText.replaceAll(sRegex, sbHtml.toString()));
        this.m_oTemplateMgr.save(temp, null, true, 2);
    }

    @Override
    public Master createMasterFromTemplate(Template template) throws WCMException {
        if (!template.getPropertyAsBoolean("Visual", false)) {
            return null;
        }
        String sVisualHtml = template.getText();
        Matcher matcher = m_oTRSWidgetPattern.matcher(sVisualHtml);
        StringBuffer sbHtml = new StringBuffer(sVisualHtml.length());
        int nInstanceId = 0;
        int nStartIndex = 0;
        int nEndIndex = 0;
        while (matcher.find()) {
            nStartIndex = matcher.start();
            sbHtml.append(sVisualHtml.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            nInstanceId = Integer.parseInt(matcher.group(1));
            WidgetInstance widgetInstance = WidgetInstance.findById(nInstanceId);
            Widget widget = widgetInstance.getWidget();
            sbHtml.append("<TRS_PreWidget");
            String sWidgetName = CMyString.filterForHTMLValue(widget.getWname());
            sbHtml.append(" name='").append(sWidgetName).append("'");
            Map parameters = this.m_oWidgetInstParameterMgr.getParameters(widgetInstance);
            for (Map.Entry entry : parameters.entrySet()) {
            }
            sbHtml.append(this.replaceWidgetInstParameters(widgetInstance));
            sbHtml.append("</TRS_PreWidget>");
        }
        if (nEndIndex < sVisualHtml.length()) {
            sbHtml.append(sVisualHtml.substring(nEndIndex));
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            Template oTemplate = Template.findById(53);
            System.out.println("-----------------------");
            System.out.println(oTemplate.getText());
            System.out.println("-----------------------");
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }
}

