/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class WidgetInstParameter
extends CMSObj {
    public static final int OBJ_TYPE = 1568980485;
    public static final String DB_TABLE_NAME = "XWCMWIDGETINSTPARAMETER";
    public static final String DB_ID_NAME = "WIDGETINSTPARAMETERID";
    public static final int MAX_BYTE_LENGTH_4_STRING = 1000;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1568980485;
    }

    public int getWidgetInstId() {
        return this.getPropertyAsInt("WIDGETINSTID", 0);
    }

    public boolean setWidgetInstId(int _nWidgetInstId) throws WCMException {
        return this.setProperty("WIDGETINSTID", _nWidgetInstId);
    }

    public String getParamName() {
        return this.getPropertyAsString("PARAMNAME");
    }

    public boolean setParamName(String _sParamName) throws WCMException {
        return this.setProperty("PARAMNAME", _sParamName);
    }

    public String getParamValue() {
        String sValue = this.getPropertyAsString("PARAMVALUE");
        if (CMyString.isEmpty(sValue)) {
            return this.getParamClobValue();
        }
        return sValue;
    }

    public boolean setParamValue(String _sParamValue) throws WCMException {
        if (CMyString.getBytesLength(_sParamValue) > 1000) {
            this.setProperty("PARAMVALUE", "");
            return this.setParamClobValue(_sParamValue);
        }
        if (CMyString.isEmpty(this.getPropertyAsString("PARAMVALUE"))) {
            this.setParamClobValue("");
        }
        return this.setProperty("PARAMVALUE", _sParamValue);
    }

    private String getParamClobValue() {
        CDBText txtValue = (CDBText)this.getProperty("PARAMCLOBVALUE");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    private boolean setParamClobValue(String _sParamClobValue) throws WCMException {
        return this.setProperty("PARAMCLOBVALUE", new CDBText(this.getDBManager().getDBTypeAsInt(), _sParamClobValue));
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String sParamName = this.getParamName();
            if (!CMyString.isEmpty(sParamName)) {
                this.setParamName(sParamName.toUpperCase());
            }
        } else {
            String sParamName = this.getNewPropertyAsString("PARAMNAME");
            if (!CMyString.isEmpty(sParamName)) {
                this.setParamName(sParamName.toUpperCase());
            }
            if (!this.isModified()) {
                throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(WidgetInstParameter.isValid)");
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final WidgetInstParameter findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (WidgetInstParameter)BaseObj.findById(WidgetInstParameter.class, _nId);
    }

    public static final WidgetInstParameter createNewInstance() throws WCMException {
        return (WidgetInstParameter)BaseObj.createNewInstance(WidgetInstParameter.class);
    }

    public static final WidgetInstParameter findByKey(Object _oKey) throws WCMException {
        return (WidgetInstParameter)BaseObj.findByKey(WidgetInstParameter.class, _oKey);
    }
}

