/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.components.common.publish.widget.Widget;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WidgetFixedParamProcessor {
    public void addFixedParamToWidget(Widget _oWidget) throws WCMException {
        if (_oWidget == null) {
            return;
        }
        String sContent = _oWidget.getNewPropertyAsString("WIDGETCONTENT");
        if (CMyString.isEmpty(sContent)) {
            sContent = _oWidget.getWidgetcontent();
        }
        if (CMyString.isEmpty(sContent)) {
            return;
        }
        sContent = CMyString.replaceStr(sContent, "$", "\\$");
        sContent = this.replaceIfNeed(sContent, "$[WSTYLEID]", "\\$\\[WSTYLEID\\]", "(?<=trs\\-res\\b).*?(?=(\"|\\b\\w+\\s*\\=|>))");
        sContent = this.replaceIfNeed(sContent, "$[CSTYLEID]", "\\$\\[CSTYLEID\\]", "(?<=p_w_body_bg\\b).*?(?=(\"|\\b\\w+\\s*\\=|>))");
        sContent = this.replaceIfNeed(sContent, "$[HEADDISPLAY]", "headdisplay-\\$\\[HEADDISPLAY\\]", "(?<=p_w_head\\b).*?(?=(\"|\\b\\w+\\s*\\=|>))");
        sContent = this.replaceIfNeed(sContent, "$[BACKGROUND]", "\\$\\[BACKGROUND\\]", "(?<=p_w_content(\"|\\b)).*?style\\s*\\=\\s*\"?.*?(?=(\"|>|\\b\\w+\\s*))");
        sContent = CMyString.replaceStr(sContent, "\\$", "$");
        _oWidget.setWidgetcontent(sContent);
    }

    private String replaceIfNeed(String _sContent, String _sSubStr, String _sAddWith, String _sRegex) throws WCMException {
        if (_sContent.indexOf(_sSubStr) != -1) {
            return _sContent;
        }
        Pattern p = Pattern.compile(_sRegex);
        Matcher m = p.matcher(_sContent);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group() + " " + _sAddWith + " ");
        }
        m.appendTail(sb);
        if (!"\\$\\[BACKGROUND\\]".equals(_sAddWith) || sb.indexOf(_sSubStr) > -1) {
            return sb.toString();
        }
        Pattern p2 = Pattern.compile("class\\s*=\\s*[\"']?\\bp_w_content\\b[^>].*?(?=>)");
        Matcher m2 = p2.matcher(_sContent);
        StringBuffer sb2 = new StringBuffer();
        while (m2.find()) {
            m2.appendReplacement(sb2, m2.group() + " style = \"" + _sAddWith + "\"");
        }
        m2.appendTail(sb2);
        return sb2.toString();
    }
}

