/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.Widgets;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SubjectDataInitHelper {
    private static Logger s_logger = Logger.getLogger(SubjectDataInitHelper.class);
    private static JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
    private static HashMap parameters = new HashMap();
    private static HashMap widgetAndChannel = new HashMap();
    private static HttpServletRequest request = null;
    static String[][] defaultData = new String[][]{{"*", "1"}, {"50:50", "2"}, {"30:70", "2"}, {"40:60", "2"}, {"38:*", "2"}, {"70:30", "2"}, {"60:40", "2"}, {"300:*", "1"}, {"400:*", "1"}, {"30:30:40", "2"}, {"33:*:33", "2"}, {"30:40:30", "2"}, {"350:350:*", "1"}, {"450:250:*", "1"}, {"25:25:25:25", "2"}, {"250:250:250:*", "1"}};

    public static String getSpecialInitDataPath(HttpServletRequest req) throws WCMException {
        s_logger.info((Object)"\u6b63\u5728\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u5305\u3002\u3002\u3002");
        String sAppDir = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if ("\\".equals(File.separator)) {
            sAppDir = CMyString.replaceStr(sAppDir, "/", File.separator);
        }
        if ((sAppDir = CMyString.setStrEndWith(sAppDir, File.separatorChar)) == null || sAppDir.trim().equals("")) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u6240\u5728\u8def\u5f84\uff01");
        }
        String sTestDataRootPath = sAppDir + "app" + File.separator + "special" + File.separator + "data" + File.separator;
        s_logger.info((Object)("\u83b7\u53d6\u5230\u7684\u4e13\u9898\u6f14\u793a\u6570\u636e\u6240\u5728\u7684\u76ee\u5f55\u4e3a\u3010" + sTestDataRootPath + "\u3011"));
        request = req;
        return sTestDataRootPath;
    }

    public static void importDemoDatasWebSite(String sTestDataRootPath) {
        WebSite website = null;
        try {
            website = SubjectDataInitHelper.getWebSiteByStyleName("\u4e13\u9898\u6f14\u793a\u6570\u636e");
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (website != null) {
            return;
        }
        String sSiteDataFullName = sTestDataRootPath + "specialDemoData-website.zip";
        if (!CMyFile.fileExists(sSiteDataFullName)) {
            s_logger.error((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sSiteDataFullName + "\u3011"));
            return;
        }
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u7ad9\u70b9\u3002\u3002\u3002");
        String sServiceId = "wcm6_website";
        String sMethodName = "importsites";
        processor.reset();
        parameters.clear();
        parameters.put("IMPORTFILE", sSiteDataFullName);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u7ad9\u70b9\u5b8c\u6210\uff01");
    }

    public static void importDemoDatasDocument(String sTestDataRootPath) {
        User loginUser = ContextHelper.getLoginUser();
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u680f\u76ee\u6587\u6863\u3002\u3002\u3002");
        WebSite website = null;
        try {
            website = SubjectDataInitHelper.getWebSiteByStyleName("\u4e13\u9898\u6f14\u793a\u6570\u636e");
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u5931\u8d25\uff01", (Throwable)e);
        }
        if (website == null) {
            s_logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\uff01");
            return;
        }
        try {
            String sHost = "127.0.0.1";
            int nPort = 8080;
            String sHostInfo = "";
            if (request != null) {
                sHost = request.getServerName();
                nPort = request.getServerPort();
                sHostInfo = sHost + ":" + nPort;
            } else {
                int nIndex;
                System.out.println("\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u4ece\u914d\u7f6e\u9879WCM_URL\u4e2d\u8bfb\u53d6\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                String sWCMUrl = ConfigServer.getServer().getSysConfigValue("WCM_URL", "http://127.0.0.1:8080/wcm/");
                if (CMyString.isEmpty(sWCMUrl)) {
                    sWCMUrl = "http://127.0.0.1:8080/wcm/";
                }
                sHostInfo = (nIndex = (sWCMUrl = sWCMUrl.substring("http://".length())).indexOf("/")) < 0 ? sWCMUrl : sWCMUrl.substring(0, nIndex);
            }
            String specialData_SiteHttp = "http://" + sHostInfo + "/pub/specialdata";
            IPublishElement publishElement = PublishElementFactory.lookupElement(103, website.getId());
            WCMFolderPublishConfig config = new WCMFolderPublishConfig((IPublishFolder)publishElement);
            config.setRootDomain(specialData_SiteHttp);
            config.canEdit(loginUser);
            config.save(loginUser);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u4fee\u6539\u7ad9\u70b9\u7684http\u5730\u5740\u51fa\u73b0\u9519\u8bef\uff01");
        }
        List<Channel> channleList = null;
        try {
            channleList = website.getChildren(loginUser);
        }
        catch (WCMException e1) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u4e0b\u7684\u680f\u76ee\u5931\u8d25\uff01", (Throwable)e1);
        }
        if (channleList == null) {
            s_logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u4e0b\u7684\u680f\u76ee\uff01");
            return;
        }
        HashMap<String, String> channelNameDataFileMap = new HashMap<String, String>();
        channelNameDataFileMap.put("\u5bfc\u8bfb\u6570\u636e", "specialDemoData-regionChnlDoc");
        channelNameDataFileMap.put("\u56fe\u7247\u65cb\u8f6c\u6570\u636e", "specialDemoData-picRotationChnlDoc");
        channelNameDataFileMap.put("\u56fe\u7247\u6458\u8981\u6570\u636e", "specialDemoData-picSummaryChnlDoc");
        channelNameDataFileMap.put("\u56fe\u7247\u5217\u8868\u6570\u636e", "specialDemoData-picListChnlDoc");
        channelNameDataFileMap.put("\u5355\u4e2a\u56fe\u7247\u6458\u8981\u6570\u636e", "specialDemoData-singlePicSummaryChnlDoc");
        channelNameDataFileMap.put("\u6587\u6863\u5217\u8868\u6570\u636e", "specialDemoData-documentListChnlDoc");
        channelNameDataFileMap.put("\u7ec6\u89c8\u6587\u6863", "specialDemoData-detailDocChnlDoc");
        channelNameDataFileMap.put("\u89c6\u9891\u62a5\u9053", "specialDemoData-videoChnlDoc");
        channelNameDataFileMap.put("\u5317\u4eac\u65c5\u6e38", "specialDemoData-newsCenterChnldoc");
        channelNameDataFileMap.put("\u4e0a\u6d77\u65c5\u6e38", "specialDemoData-productCenterChnlDoc");
        channelNameDataFileMap.put("\u6df1\u5733\u65c5\u6e38", "specialDemoData-organizationChnlDoc");
        channelNameDataFileMap.put("\u676d\u5dde\u65c5\u6e38", "specialDemoData-noticeChnlDoc");
        channelNameDataFileMap.put("\u98ce\u666f\u5c55\u793a", "specialDemoData-movePicShowChnlDoc");
        channelNameDataFileMap.put("\u5355\u4e2a\u56fe\u7247\u6458\u8981\u76f8\u5173\u6587\u6863\u680f\u76ee", "specialDemoData-singlePicSummaryRelationChnlDoc");
        channelNameDataFileMap.put("\u56fe\u7247\u6eda\u52a8\u6570\u636e", "specialDemoData-picRollingChnlDoc");
        channelNameDataFileMap.put("\u7011\u5e03\u6d41\u6570\u636e", "specialDemoData-waterfallChnlDoc");
        for (int i = channleList.size() - 1; i >= 0; --i) {
            BaseChannel currObj = channleList.get(i);
            if (currObj == null) continue;
            SubjectDataInitHelper.importChnlDocsForSingleChannel(currObj, channelNameDataFileMap, sTestDataRootPath);
            SubjectDataInitHelper.importChnlDocsForSubChannel(currObj, channelNameDataFileMap, sTestDataRootPath);
            if (!"\u6587\u6863\u5217\u8868\u6570\u636e".equals(currObj.getName())) continue;
            String sServiceId = "wcm6_publish";
            String sMethodName = "increasingPublish";
            processor.reset();
            parameters.clear();
            parameters.put("OBJECTIDS", String.valueOf(currObj.getId()));
            parameters.put("OBJECTTYPE", String.valueOf(101));
            try {
                processor.excute(sServiceId, sMethodName, parameters);
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u6587\u6863\u5217\u8868\u6570\u636e\u53d1\u5e03\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
            try {
                ConfigServer.getServer().updateConfigValue("SPECIAL_DEFAULT_CHANNELID", String.valueOf(currObj.getId()));
                continue;
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u521d\u59cb\u5316\u6587\u6863\u5217\u8868\u7684\u9ed8\u8ba4\u680f\u76eeID\u914d\u7f6e\u9879\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        s_logger.info((Object)"\u5bfc\u5165\u680f\u76ee\u6587\u6863\u5b8c\u6210\u3002\u3002\u3002");
    }

    private static void importChnlDocsForSubChannel(BaseChannel currObj, HashMap channelNameDataFileMap, String sTestDataRootPath) {
        User loginUser = ContextHelper.getLoginUser();
        if (!"\u680f\u76eetab\u5207\u6362".equals(currObj.getName()) && !"\u5355\u4e2a\u56fe\u7247\u6458\u8981\u6570\u636e".equals(currObj.getName())) {
            return;
        }
        List<Channel> subChannleList = null;
        try {
            subChannleList = currObj.getChildren(loginUser);
        }
        catch (WCMException e1) {
            s_logger.error((Object)"\u83b7\u53d6\u680f\u76ee\u7684\u5b50\u680f\u76ee\u5931\u8d25\uff01", (Throwable)e1);
        }
        if (subChannleList == null || subChannleList.size() == 0) {
            s_logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u680f\u76ee\u5b50\u680f\u76ee\uff01");
            return;
        }
        for (int i = subChannleList.size() - 1; i >= 0; --i) {
            BaseChannel currSubObj = subChannleList.get(i);
            if (currSubObj == null) continue;
            SubjectDataInitHelper.importChnlDocsForSingleChannel(currSubObj, channelNameDataFileMap, sTestDataRootPath);
            if (!"\u5355\u4e2a\u56fe\u7247\u6458\u8981\u76f8\u5173\u6587\u6863\u680f\u76ee".equals(currSubObj.getName())) continue;
            String sServiceId = "wcm6_publish";
            String sMethodName = "increasingPublish";
            processor.reset();
            parameters.clear();
            parameters.put("OBJECTIDS", String.valueOf(currSubObj.getId()));
            parameters.put("OBJECTTYPE", String.valueOf(101));
            try {
                processor.excute(sServiceId, sMethodName, parameters);
                continue;
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u5355\u4e2a\u56fe\u7247\u6458\u8981\u76f8\u5173\u6587\u6863\u680f\u76ee\u53d1\u5e03\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }

    private static void importChnlDocsForSingleChannel(BaseChannel currObj, HashMap channelNameDataFileMap, String sTestDataRootPath) {
        String sChannelName = currObj.getName();
        String sChnnelDataFileName = (String)channelNameDataFileMap.get(sChannelName);
        if (CMyString.isEmpty(sChnnelDataFileName)) {
            return;
        }
        String sFileFullName = sTestDataRootPath + sChnnelDataFileName + ".zip";
        if (!CMyFile.fileExists(sFileFullName)) {
            return;
        }
        String sBakFileFullName = sTestDataRootPath + sChnnelDataFileName + "bak.zip";
        try {
            CMyFile.copyFile(sFileFullName, sBakFileFullName);
        }
        catch (CMyException e1) {
            s_logger.error((Object)"\u590d\u5236\u9700\u8981\u7684\u5bfc\u5165\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u6587\u6863zip\u5305\u5931\u8d25\uff01", (Throwable)e1);
        }
        if (!CMyFile.fileExists(sBakFileFullName)) {
            s_logger.error((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sBakFileFullName + "\u3011"));
            return;
        }
        String sServiceId = "wcm6_document";
        String sMethodName = "importDocuments";
        processor.reset();
        parameters.clear();
        parameters.put("CHANNELID", String.valueOf(currObj.getId()));
        parameters.put("IMPORTFILE", sBakFileFullName);
        parameters.put("IMPORTXSLFILE", "");
        parameters.put("IMPORTTOCURRCHANNEL", "true");
        parameters.put("IMPORTBYCHNLNAME", "false");
        parameters.put("IGNORETITLESIM", "false");
        parameters.put("ISTRSSERVERFILE", "false");
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u4e0b\u7684\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        if ("\u7ec6\u89c8\u6587\u6863".equals(sChannelName)) {
            DocumentMgr oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            try {
                Documents oDocuments = oDocumentMgr.getDocuments(currObj, null);
                if (oDocuments != null && oDocuments.size() >= 1) {
                    Document currDocument = (Document)oDocuments.getAt(0);
                    int nDocId = currDocument.getId();
                    ConfigServer.getServer().updateConfigValue("SPECIAL_DETAIL_DOCID", String.valueOf(nDocId));
                }
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e\u4e2d\u7684\u4e13\u9898\u7ec6\u89c8\u6587\u6863ID\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void setRelationDoc() {
        DocumentMgr oDocumentMgr;
        s_logger.info((Object)"\u5f00\u59cb\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\uff01");
        WebSite website = null;
        try {
            website = SubjectDataInitHelper.getWebSiteByStyleName("\u4e13\u9898\u6f14\u793a\u6570\u636e");
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u7ad9\u70b9\u5931\u8d25\uff01", (Throwable)e);
            return;
        }
        ChannelMgr oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        Channel docListChannel = null;
        Channel detailDocChannel = null;
        Channel singlePicSumChannel = null;
        Channel singlePicSumRelationChannel = null;
        if (website != null) {
            docListChannel = oChannelMgr.getChannelByName(website.getId(), "\u6587\u6863\u5217\u8868\u6570\u636e");
            detailDocChannel = oChannelMgr.getChannelByName(website.getId(), "\u7ec6\u89c8\u6587\u6863");
            singlePicSumChannel = oChannelMgr.getChannelByName(website.getId(), "\u5355\u4e2a\u56fe\u7247\u6458\u8981\u6570\u636e");
            singlePicSumRelationChannel = oChannelMgr.getChannelByName(website.getId(), "\u5355\u4e2a\u56fe\u7247\u6458\u8981\u76f8\u5173\u6587\u6863\u680f\u76ee");
        }
        if (docListChannel != null && detailDocChannel != null) {
            try {
                oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                Documents detailDocs = oDocumentMgr.getDocuments(detailDocChannel, null);
                Documents sourceDocs = oDocumentMgr.getDocuments(docListChannel, null);
                SubjectDataInitHelper.setRelationForDocs(detailDocs, sourceDocs);
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u7ed9\u7ec6\u89c8\u6587\u6863\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        if (docListChannel != null && detailDocChannel != null) {
            try {
                oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                Documents singlePicSumDocs = oDocumentMgr.getDocuments(singlePicSumChannel, null);
                Documents singlePicSumRelationDocs = oDocumentMgr.getDocuments(singlePicSumRelationChannel, null);
                SubjectDataInitHelper.setRelationForDocs(singlePicSumDocs, singlePicSumRelationDocs);
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u7ed9\u56fe\u7247\u6458\u8981\u6587\u6863\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        s_logger.info((Object)"\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\u5b8c\u6210\uff01");
    }

    public static void setRelationForDocs(Documents targetDocs, Documents sourceDocs) {
        int nDocId = 0;
        int nSize = targetDocs.size();
        for (int i = 0; i < nSize; ++i) {
            Document element = (Document)targetDocs.getAt(i);
            if (element == null) continue;
            nDocId = element.getId();
            break;
        }
        StringBuffer oStrBuffer = new StringBuffer();
        oStrBuffer.append("<OBJECTS>");
        int k = 0;
        int nSize2 = sourceDocs.size();
        for (int i = nSize2 - 1; i >= 0; --i) {
            int nId;
            Document doc = (Document)sourceDocs.getAt(i);
            if (doc == null || (nId = doc.getId()) <= 0) continue;
            oStrBuffer.append("<OBJECT ID=\"0\" RELDOCID=\"" + nId + "\"/>");
            if (++k == 5) break;
        }
        oStrBuffer.append("</OBJECTS>");
        String sSetRelationId = "wcm6_document";
        String sSetMethodName = "saveRelation";
        processor.reset();
        parameters.clear();
        parameters.put("DOCID", String.valueOf(nDocId));
        parameters.put("RELATIONSXML", oStrBuffer.toString());
        try {
            processor.excute(sSetRelationId, sSetMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void importDemoDatasMaster(String sTestDataRootPath) {
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u4e13\u9898\u6bcd\u7248\u3002\u3002\u3002");
        String sMasterFullFile = sTestDataRootPath + "specialDemoData-master.zip";
        if (!CMyFile.fileExists(sMasterFullFile)) {
            s_logger.info((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u6bcd\u7248\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sMasterFullFile + "\u3011"));
            return;
        }
        String sServiceId = "wcm61_master";
        String sMethodName = "importMasters";
        processor.reset();
        parameters.clear();
        parameters.put("FILENAME", sMasterFullFile);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u6bcd\u677f\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u4e13\u9898\u6bcd\u7248\u5b8c\u6210\uff01");
    }

    public static void importDemoDatasWidget(String sTestDataRootPath) {
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u8d44\u6e90\u3002\u3002\u3002");
        String sWidgetFullFile = sTestDataRootPath + "specialDemoData-widget.zip";
        if (!CMyFile.fileExists(sWidgetFullFile)) {
            s_logger.info((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u8d44\u6e90\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sWidgetFullFile + "\u3011"));
            return;
        }
        String sServiceId = "wcm61_widget";
        String sMethodName = "importWidgets";
        processor.reset();
        parameters.clear();
        parameters.put("IMPORTFILE", sWidgetFullFile);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u8d44\u6e90\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u8d44\u6e90\u5b8c\u6210\uff01");
    }

    public static void importDemoDatasResourceStyle(String sTestDataRootPath) {
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u7cfb\u7edf\u8d44\u6e90\u53ef\u7528\u98ce\u683c\uff01");
        String sResourceStyleFullFile = sTestDataRootPath + "specialDemoDataResourceStyle.zip";
        if (!CMyFile.fileExists(sResourceStyleFullFile)) {
            s_logger.info((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u8d44\u6e90\u98ce\u683c\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sResourceStyleFullFile + "\u3011"));
            return;
        }
        String sServiceId = "wcm61_resourcestyle";
        String sMethodName = "importResourceStyleZip";
        processor.reset();
        parameters.clear();
        parameters.put("IMPORTMODE", "1");
        parameters.put("RESOURCESTYLEZIPFILE", sResourceStyleFullFile);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u8d44\u6e90\u98ce\u683c\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5b8c\u6210\uff01");
    }

    public static void importDemoDatasContentStyle(String sTestDataRootPath) {
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u7cfb\u7edf\u5185\u5bb9\u53ef\u7528\u98ce\u683c\uff01");
        String sContentStyleFullFile = sTestDataRootPath + "specialDemoDataContentStyle.zip";
        if (!CMyFile.fileExists(sContentStyleFullFile)) {
            s_logger.info((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u5185\u5bb9\u98ce\u683c\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sContentStyleFullFile + "\u3011"));
            return;
        }
        String sServiceId = "wcm61_contentstyle";
        String sMethodName = "importContentStyleZip";
        processor.reset();
        parameters.clear();
        parameters.put("IMPORTMODE", "1");
        parameters.put("ContentStyleZipFile", sContentStyleFullFile);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u5185\u5bb9\u98ce\u683c\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5b8c\u6210\uff01");
    }

    public static void importDemoDatasPageStyle(String sTestDataRootPath) {
        s_logger.info((Object)"\u6b63\u5728\u5bfc\u5165\u9875\u9762\u98ce\u683c\u3002\u3002\u3002");
        String sPageStyleFullFile = sTestDataRootPath + "specialDemoDataPageStyle.zip";
        if (!CMyFile.fileExists(sPageStyleFullFile)) {
            s_logger.info((Object)("\u672a\u627e\u5230\u7b26\u5408\u76ee\u5f55\u89c4\u5219\u7684\u4e13\u9898\u9875\u9762\u98ce\u683c\u6570\u636e\u6587\u4ef6\uff0c\u6b63\u786e\u7684\u8def\u5f84\u4e3a\u3010" + sPageStyleFullFile + "\u3011"));
            return;
        }
        String sServiceId = "wcm61_pagestyle";
        String sMethodName = "importPageStyleZip";
        processor.reset();
        parameters.clear();
        parameters.put("PageStyleZipFile", sPageStyleFullFile);
        try {
            processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u5bfc\u5165\u4e13\u9898\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01", (Throwable)e);
        }
        s_logger.info((Object)"\u5bfc\u5165\u9875\u9762\u98ce\u683c\u5b8c\u6210\uff01");
    }

    public static void updateDemoDataWidgetParamtersAndRegion() throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        s_logger.info((Object)"\u6b63\u5728\u66f4\u65b0\u8d44\u6e90\u53d8\u91cf\u7684\u9ed8\u8ba4\u6570\u636e\u3002\u3002\u3002\u3002\u3002");
        IWidgetParameterMgr oIWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");
        WebSite oWebSite = null;
        try {
            oWebSite = SubjectDataInitHelper.getWebSiteByStyleName("\u4e13\u9898\u6f14\u793a\u6570\u636e");
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u5931\u8d25\uff01", (Throwable)e);
        }
        if (oWebSite == null) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u4e3a\u7a7a\uff01");
            return;
        }
        List<Channel> channleList = null;
        try {
            channleList = oWebSite.getChildren(loginUser);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u4e0b\u7684\u680f\u76ee\u5931\u8d25\uff01", (Throwable)e);
        }
        if (channleList == null) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u7ad9\u70b9\u4e0b\u7684\u680f\u76ee\u4e3a\u7a7a\uff01");
            return;
        }
        SubjectDataInitHelper.initWidgetAndChannelParameter();
        Widgets widgets = null;
        try {
            widgets = SubjectDataInitHelper.getAllWidget();
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u7684\u8d44\u6e90\u5931\u8d25\uff01", (Throwable)e);
        }
        if (widgets == null) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u7684\u8d44\u6e90\u4e3a\u7a7a\uff01");
            return;
        }
        WidgetParameter oWidgetParameter = null;
        int nRegionChannelId = 0;
        int nSize = widgets.size();
        for (int i = 0; i < nSize; ++i) {
            Widget widget = (Widget)widgets.getAt(i);
            if (widget == null) continue;
            String sWidgetName = widget.getWname();
            String sChannelName = (String)widgetAndChannel.get(sWidgetName);
            int nTrueChannelId = 0;
            if (sChannelName != null) {
                int nChannelSize = channleList.size();
                for (int j = 0; j < nChannelSize; ++j) {
                    BaseChannel channel = channleList.get(j);
                    if (channel == null) continue;
                    String currChannelName = channel.getName();
                    if (currChannelName.equals("\u5bfc\u8bfb\u6570\u636e")) {
                        nRegionChannelId = channel.getId();
                    }
                    if (!currChannelName.equals(sChannelName)) continue;
                    nTrueChannelId = channel.getId();
                    break;
                }
            }
            if (nTrueChannelId <= 0) continue;
            ArrayList<String> oArrWidgetNames = new ArrayList<String>();
            oArrWidgetNames.add("\u663e\u793a\u7236\u680f\u76ee\u7684Tab\u5bfc\u822a\u6587\u6863\u5217\u8868");
            oArrWidgetNames.add("\u680f\u76eeTab\u5bfc\u822a_\u5355\u5217\u6587\u6863\u5217\u8868-\u7b2c\u4e00\u5217\u56fe\u7247");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a-\u5e26\u65f6\u95f4");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a1");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a2");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a3");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a4");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a5");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a6");
            oArrWidgetNames.add("\u680f\u76ee\u5bfc\u822a-\u5e26\u65f6\u95f4");
            oArrWidgetNames.add("\u680f\u76eeTab\u5bfc\u822a_\u4e24\u5217\u6587\u6863\u5217\u8868");
            oArrWidgetNames.add("\u591a\u4e2a\u680f\u76ee-\u666e\u901a\u65b0\u95fb\u5217\u8868");
            oArrWidgetNames.add("\u680f\u76eetab\u6587\u6863\u5217\u8868");
            if (oArrWidgetNames.contains(sWidgetName)) {
                try {
                    oWidgetParameter = oIWidgetParameterMgr.findParameterByName(widget, "\u7236\u680f\u76ee");
                }
                catch (WCMException e) {
                    s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u7684\u680f\u76ee\u5bfc\u822a\u8d44\u6e90\u7684\u7236\u680f\u76ee\u8d44\u6e90\u53d8\u91cf\u5931\u8d25\uff01", (Throwable)e);
                }
            } else {
                try {
                    oWidgetParameter = oIWidgetParameterMgr.findParameterByName(widget, "\u6240\u5c5e\u680f\u76ee");
                }
                catch (WCMException e) {
                    s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u6240\u5c5e\u680f\u76ee\u8d44\u6e90\u53d8\u91cf\u5931\u8d25\uff01", (Throwable)e);
                }
            }
            if (oWidgetParameter == null) {
                s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u7684\u8d44\u6e90\u53d8\u91cf\u5bf9\u8c61\u4e3a\u7a7a\uff01");
                continue;
            }
            try {
                oWidgetParameter.setDefaultValue(String.valueOf(nTrueChannelId));
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u4e0b\u7684\u8d44\u6e90\u53d8\u91cf\u7684\u9ed8\u8ba4\u503c\u5931\u8d25\uff01", (Throwable)e);
            }
            try {
                oWidgetParameter.save();
                continue;
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u4fdd\u5b58\u8d44\u6e90\u53d8\u91cf\u7684\u9ed8\u8ba4\u503c\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        s_logger.info((Object)"\u66f4\u65b0\u8d44\u6e90\u53d8\u91cf\u7684\u9ed8\u8ba4\u6570\u636e\u5b8c\u6210\uff01");
        if (nRegionChannelId > 0) {
            SubjectDataInitHelper.createDemoDataRegionInfo(nRegionChannelId);
        }
    }

    private static void createDemoDataRegionInfo(int nChannelId) {
        String sServiceId = "wcm61_viewdocument";
        String sMethodName = "jQuery";
        processor.reset();
        parameters.clear();
        parameters.put("CHANNELID", String.valueOf(nChannelId));
        parameters.put("SITETYPE", "0");
        parameters.put("CHANNELTYPE", "0");
        parameters.put("FIELDSTOHTML", "DocTitle,DocChannel.Name");
        parameters.put("CHNLDOCSELECTFIELDS", "WCMChnlDoc.RecId,WCMChnlDoc.DOCID");
        parameters.put("DOCUMENTSELECTFIELDS", "WCMDOCUMENT.DOCID,WCMDOCUMENT.DocTitle,WCMDOCUMENT.CrTime");
        parameters.put("CHANNELIDS", String.valueOf(nChannelId));
        parameters.put("SITEIDS", "");
        parameters.put("FILTERTYPE", "0");
        parameters.put("OrderBy", "WCMChnlDoc.crtime desc");
        ViewDocuments viewDocuments = null;
        try {
            viewDocuments = (ViewDocuments)processor.excute(sServiceId, sMethodName, parameters);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u4e0b\u7684\u5bfc\u8bfb\u6570\u636e\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        if (viewDocuments == null) {
            s_logger.error((Object)"\u83b7\u53d6\u4e13\u9898\u6f14\u793a\u6570\u636e\u4e0b\u7684\u5bfc\u8bfb\u6570\u636e\u6587\u6863\u4e3a\u7a7a\uff01");
            return;
        }
        int nRegionId = 0;
        try {
            nRegionId = SubjectDataInitHelper.makeRegionInfo(nChannelId);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u521b\u5efa\u4e13\u9898\u6f14\u793a\u6570\u636e\u5bfc\u8bfb\u5931\u8d25\uff01", (Throwable)e);
        }
        if (nRegionId == 0) {
            s_logger.error((Object)"\u521b\u5efa\u4e13\u9898\u6f14\u793a\u6570\u636e\u5bfc\u8bfb\u6ca1\u6709\u521b\u5efa\u6210\u529f\uff01");
            return;
        }
        try {
            SubjectDataInitHelper.makeRegionCellInfo2(nRegionId, viewDocuments);
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u521b\u5efa\u4e13\u9898\u6f14\u793a\u6570\u636e\u5bfc\u8bfb\u5355\u5143\u683c\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private static int makeRegionInfo(int nChannelId) throws WCMException {
        String sServiceId = "wcm6_regioninfo";
        String sMethodName = "save";
        processor.reset();
        parameters.clear();
        parameters.put("CSSTEXT", "");
        parameters.put("OBJECTID", "0");
        parameters.put("CHANNELID", String.valueOf(nChannelId));
        parameters.put("WEBSITEID", "0");
        parameters.put("BPUBLISH", "false");
        parameters.put("RNAME", "\u65b0\u95fb2");
        parameters.put("WIDTH", "385");
        parameters.put("REGIONFONTSIZE", "12");
        parameters.put("CELLPADDING", "3");
        parameters.put("ROWNUMBER", "4");
        parameters.put("CELLNUM", "4");
        return (Integer)processor.excute(sServiceId, sMethodName, parameters);
    }

    private static void makeRegionCellInfo2(int _nRegionId, ViewDocuments viewDocuments) throws WCMException {
        String sTitile;
        int i;
        StringBuffer sCellsXml = new StringBuffer();
        sCellsXml.append("<OBJECTS>");
        int nDocSize = viewDocuments.size();
        for (int i2 = 0; i2 < nDocSize && i2 != 1; ++i2) {
            ViewDocument oViewDocument = (ViewDocument)viewDocuments.getAt(i2);
            if (oViewDocument == null) continue;
            int nDocId = oViewDocument.getDocId();
            int nRecId = oViewDocument.getId();
            String sTitile2 = oViewDocument.getPropertyAsString("DocTitle", "");
            sTitile2 = "&lt;FONT style=&quot;FONT-SIZE: 16pt&quot; color=#ff0000&gt;" + sTitile2 + "&lt;/FONT&gt;";
            sCellsXml.append("<OBJECT ID=\"0\" docId=\"" + nDocId + "\" recId=\"" + nRecId + "\" chnlId=\"0\" appendixId=\"0\" ");
            sCellsXml.append("rowIndex=\"0\" cellIndex=\"" + i2 + "\" docTitle=\"" + sTitile2 + "\"/>");
        }
        int nCellIndex = 0;
        for (int i3 = 1; i3 < nDocSize && i3 != 4; ++i3) {
            ViewDocument oViewDocument = (ViewDocument)viewDocuments.getAt(i3);
            if (oViewDocument == null) continue;
            int nDocId = oViewDocument.getDocId();
            int nRecId = oViewDocument.getId();
            String sTitile3 = oViewDocument.getPropertyAsString("DocTitle", "");
            sCellsXml.append("<OBJECT ID=\"0\" docId=\"" + nDocId + "\" recId=\"" + nRecId + "\" chnlId=\"0\" appendixId=\"0\" ");
            sCellsXml.append("rowIndex=\"1\" cellIndex=\"" + nCellIndex + "\" docTitle=\"" + sTitile3 + "\"/>");
            ++nCellIndex;
        }
        int k = 0;
        for (i = 4; i < nDocSize && i != 5; ++i) {
            ViewDocument oViewDocument = (ViewDocument)viewDocuments.getAt(i);
            if (oViewDocument == null) continue;
            int nDocId = oViewDocument.getDocId();
            int nRecId = oViewDocument.getId();
            sTitile = oViewDocument.getPropertyAsString("DocTitle", "");
            sCellsXml.append("<OBJECT ID=\"0\" docId=\"" + nDocId + "\" recId=\"" + nRecId + "\" chnlId=\"0\" appendixId=\"0\" ");
            sCellsXml.append("rowIndex=\"2\" cellIndex=\"" + k + "\" docTitle=\"" + sTitile + "\"/>");
            ++k;
        }
        k = 0;
        for (i = 5; i < nDocSize && i != 6; ++i) {
            ViewDocument oViewDocument = (ViewDocument)viewDocuments.getAt(i);
            if (oViewDocument == null) continue;
            int nDocId = oViewDocument.getDocId();
            int nRecId = oViewDocument.getId();
            sTitile = oViewDocument.getPropertyAsString("DocTitle", "");
            sCellsXml.append("<OBJECT ID=\"0\" docId=\"" + nDocId + "\" recId=\"" + nRecId + "\" chnlId=\"0\" appendixId=\"0\" ");
            sCellsXml.append("rowIndex=\"3\" cellIndex=\"" + k + "\" docTitle=\"" + sTitile + "\"/>");
            ++k;
        }
        sCellsXml.append("</OBJECTS>");
        String sServiceId = "wcm6_cellinfo";
        String sMethodName = "saveCells";
        processor.reset();
        parameters.clear();
        parameters.put("CellsXML", sCellsXml.toString());
        parameters.put("REGIONINFOID", String.valueOf(String.valueOf(_nRegionId)));
        parameters.put("BPUBLISH", "false");
        processor.excute(sServiceId, sMethodName, parameters);
    }

    private static WebSite getWebSiteByStyleName(String _sSiiteName) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMWEBSITE", "SiteName=?", "SiteId");
        filter.addSearchValues(0, _sSiiteName);
        WebSites websites = WebSites.openWCMObjs(null, filter);
        if (websites.size() > 0) {
            return (WebSite)websites.getAt(0);
        }
        return null;
    }

    private static void initWidgetAndChannelParameter() {
        if (widgetAndChannel.size() == 0) {
            widgetAndChannel.put("\u5355\u6761\u91cd\u8981\u65b0\u95fb-\u4e0a\u56fe\u7247\u4e0b\u6458\u8981", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u56fe\u7247\u5e7b\u706f\u7247\u5207\u6362", "\u56fe\u7247\u65cb\u8f6c\u6570\u636e");
            widgetAndChannel.put("\u56fe\u7247\u8f6e\u6362\u6570\u5b57\u5bfc\u822a", "\u56fe\u7247\u65cb\u8f6c\u6570\u636e");
            widgetAndChannel.put("\u5355\u4e2a\u56fe\u7247\u6458\u8981", "\u5355\u4e2a\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u5782\u76f4\u6eda\u52a8\u65b0\u95fb\u5217\u8868", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a1", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a2", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a3", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a4", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a5", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a6", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76ee\u5bfc\u822a-\u5e26\u65f6\u95f4", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u680f\u76eeTab\u5bfc\u822a_\u5355\u5217\u6587\u6863\u5217\u8868-\u7b2c\u4e00\u5217\u56fe\u7247", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u4e0b\u62c9\u5217\u8868\u70b9\u51fb\u8df3\u8f6c", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u680f\u76eeTab\u5bfc\u822a_\u4e24\u5217\u6587\u6863\u5217\u8868", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u516c\u544a\u680f\u6eda\u52a8\u65b0\u95fb", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u680f\u76eeTab\u5bfc\u822a_\u5355\u5217\u6587\u6863\u5217\u8868", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u591a\u4e2a\u680f\u76ee-\u666e\u901a\u65b0\u95fb\u5217\u8868", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u4e24\u5217\u6587\u6863\u5217\u8868", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u6587\u6863\u5217\u8868\u7b2c\u4e00\u7bc7\u663e\u793a\u6458\u8981", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u591a\u884c\u56fe\u7247\u5217\u8868", "\u56fe\u7247\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u6807\u9898\u591a\u5217\u663e\u793a", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u98d8\u7a97", "\u5355\u4e2a\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u6807\u9898\u91cd\u8981\u663e\u793a", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u5e26\u7f29\u7565\u56fe\u7684\u56fe\u7247\u5207\u6362", "\u56fe\u7247\u65cb\u8f6c\u6570\u636e");
            widgetAndChannel.put("\u666e\u901a\u65b0\u95fb\u5217\u8868", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u666e\u901a\u6587\u6863\u5217\u8868_\u5e26\u6765\u6e90", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u6587\u6863\u9644\u4ef6\u89c6\u9891", "\u89c6\u9891\u62a5\u9053");
            widgetAndChannel.put("\u56fe\u7247\u6458\u8981\u5217\u8868", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u56fe\u7247\u5217\u8868", "\u56fe\u7247\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u5de6\u4fa7\u56fe\u7247\u6458\u8981\u53f3\u4fa7\u5217\u8868", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u9996\u7bc7\u56fe\u7247\u9644\u4ef6\u52a0\u6587\u6863\u5217\u8868", "\u56fe\u7247\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u666e\u901a\u6587\u6863\u5217\u8868", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u680f\u76eetab\u6587\u6863\u5217\u8868", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u6eda\u52a8\u65b0\u95fb", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u56fe\u7247\u6458\u8981\u5207\u6362", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u52a8\u6001\u56fe\u7247\u5c55\u793a", "\u98ce\u666f\u5c55\u793a");
            widgetAndChannel.put("\u7f6e\u9876\u7a81\u51fa\u6587\u6863\u5217\u8868", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u7b2c\u4e00\u7bc7\u6587\u6863\u6709\u56fe\u6587\u6863\u5217\u8868", "\u56fe\u7247\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u666e\u901a\u6587\u6863\u5217\u8868\u5e26\u5206\u9875", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u56fe\u6587\u5217\u8868", "\u56fe\u7247\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u6c34\u5e73\u6eda\u52a8\u56fe\u7247", "\u56fe\u7247\u6eda\u52a8\u6570\u636e");
            widgetAndChannel.put("\u5782\u76f4\u6eda\u52a8\u56fe\u7247", "\u56fe\u7247\u6eda\u52a8\u6570\u636e");
            widgetAndChannel.put("\u6458\u8981\u4ecb\u7ecd", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u5f53\u524d\u4f4d\u7f6e", "\u680f\u76ee\u5bfc\u822a");
            widgetAndChannel.put("\u663e\u793a\u7236\u680f\u76ee\u7684Tab\u5bfc\u822a\u6587\u6863\u5217\u8868", "\u680f\u76eetab\u5207\u6362");
            widgetAndChannel.put("\u5927\u6807\u9898\u5e26\u6458\u8981\u5217\u8868", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u5927\u6807\u9898\u5217\u8868\u5e26\u65f6\u95f4", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u5de6\u56fe\u53f3\u6458\u8981\u4e0b\u5217\u8868", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u5927\u6807\u9898\u91cd\u8981\u5217\u8868\u663e\u793a", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u7ec4\u5408\u8d44\u6e90-\u6709\u5934\u90e8", "\u6587\u6863\u5217\u8868\u6570\u636e");
            widgetAndChannel.put("\u56fe\u7247\u65e0\u89c4\u5219\u6392\u5e8f", "\u56fe\u7247\u65cb\u8f6c\u6570\u636e");
            widgetAndChannel.put("\u5e26\u6458\u8981\u56fe\u7247\u5c55\u793a", "\u56fe\u7247\u6458\u8981\u6570\u636e");
            widgetAndChannel.put("\u7011\u5e03\u6d41", "\u7011\u5e03\u6d41\u6570\u636e");
        }
    }

    private static Widgets getAllWidget() throws WCMException {
        WCMFilter filter = new WCMFilter("XWCMWIDGET", "", "WidgetId, WNAME");
        Widgets widgets = Widgets.openWCMObjs(null, filter);
        return widgets;
    }

    private static void layoutGenerator(String[] data) {
        processor.reset();
        parameters.clear();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ObjectId", "0");
        parameters.put("LayoutName", "");
        parameters.put("Columns", new Integer(data[0].split(Layout.RATIO_SEPERATE).length));
        parameters.put("RatioType", new Integer(data[1]));
        parameters.put("Ratio", data[0]);
        try {
            processor.excute("wcm61_layout", "save", parameters);
        }
        catch (Exception e) {
            s_logger.error((Object)("\u751f\u6210\u5e03\u5c40\u9ed8\u8ba4\u53c2\u6570\u65f6\u51fa\u73b0\u5f02\u5e38\uff01\u5e03\u5c40\u4fe1\u606f\u4e3a\uff1aratio=" + data[0] + ",ratiotype=" + data[1]));
        }
    }

    private static void makeDefaultLayouts() {
        s_logger.info((Object)"\u6b63\u5728\u521b\u5efa\u4e13\u9898\u7cfb\u7edf\u9ed8\u8ba4\u5e03\u5c40......");
        for (int i = 0; i < defaultData.length; ++i) {
            SubjectDataInitHelper.layoutGenerator(defaultData[i]);
        }
        s_logger.info((Object)"\u521b\u5efa\u4e13\u9898\u7cfb\u7edf\u9ed8\u8ba4\u5e03\u5c40\u5b8c\u6210\uff01");
    }

    public static void initData(HttpServletRequest req) throws WCMException {
        processor = new JSPRequestProcessor(req, null);
        String sSpecialDataPath = SubjectDataInitHelper.getSpecialInitDataPath(req);
        HttpSession session = req.getSession();
        if (session != null) {
            try {
                session.setAttribute("currentPageStyle", (Object)"\u521b\u5efa\u7ad9\u70b9\uff0c");
                SubjectDataInitHelper.importDemoDatasWebSite(sSpecialDataPath);
                session.setAttribute("currentPageStyle", (Object)"\u521b\u5efa\u6587\u6863\uff0c");
                SubjectDataInitHelper.importDemoDatasDocument(sSpecialDataPath);
                session.setAttribute("currentPageStyle", (Object)"\u8bbe\u7f6e\u76f8\u5173\u6587\u6863\uff0c");
                SubjectDataInitHelper.setRelationDoc();
                session.setAttribute("currentPageStyle", (Object)"\u521b\u5efa\u6bcd\u7248\uff0c");
                SubjectDataInitHelper.importDemoDatasMaster(sSpecialDataPath);
                session.setAttribute("currentPageStyle", (Object)"\u521b\u5efa\u8d44\u6e90\uff0c");
                SubjectDataInitHelper.importDemoDatasWidget(sSpecialDataPath);
                session.setAttribute("currentPageStyle", (Object)"\u521b\u5efa\u98ce\u683c\uff0c");
                SubjectDataInitHelper.importDemoDatasPageStyle(sSpecialDataPath);
                session.setAttribute("currentPageStyle", (Object)"\u8bbe\u7f6e\u8d44\u6e90\u9ed8\u8ba4\u5c5e\u6027\uff0c");
                SubjectDataInitHelper.updateDemoDataWidgetParamtersAndRegion();
                session.setAttribute("currentPageStyle", (Object)"\u8bbe\u7f6e\u9ed8\u8ba4\u5e03\u5c40\uff0c");
                SubjectDataInitHelper.makeDefaultLayouts();
            }
            catch (Exception e) {
                session.setAttribute("ErrorInfo", (Object)e.getStackTrace());
            }
        }
    }
}

