/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.HashMap;

public class StyleItemMgr
implements IStyleItemMgr {
    @Override
    public void delete(User _currUser, StyleItem styleItem) throws WCMException {
        if (styleItem == null) {
            return;
        }
        if (_currUser == null) {
            _currUser = this.getLoginUser();
        }
        styleItem.delete(_currUser);
    }

    @Override
    public StyleItems queryStyleItems(BaseStyle _baseStyle, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (_baseStyle == null) {
            return StyleItems.createNewInstance(loginUser);
        }
        WCMFilter filter = new WCMFilter("", "STYLEOBJTYPE=? and STYLEOBJID=?", "");
        filter.addSearchValues(_baseStyle.getWCMType());
        filter.addSearchValues(_baseStyle.getId());
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        return StyleItems.openWCMObjs(loginUser, filter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public StyleItems query(WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        return StyleItems.openWCMObjs(loginUser, _filter);
    }

    @Override
    public StyleItem save(User _currUser, BaseStyle _baseStyle, StyleItem _styleItem) throws WCMException {
        int nStyleObjId = 0;
        int nStyleObjType = 368170809;
        if (_baseStyle != null) {
            nStyleObjId = _baseStyle.getId();
            nStyleObjType = _baseStyle.getWCMType();
        }
        _styleItem.setStyleObjId(nStyleObjId);
        _styleItem.setStyleObjType(nStyleObjType);
        _styleItem.save(_currUser);
        return _styleItem;
    }

    @Override
    public void deleteUnuseStyleItems(BaseStyle baseStyle, String _sUseingIds) throws WCMException {
        if (_sUseingIds == null || _sUseingIds.length() == 0) {
            return;
        }
        if (baseStyle == null) {
            throw new WCMException(20, "\u98ce\u683c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u98ce\u683c\u9879\uff01");
        }
        String sDelWhere = "STYLEITEMID not in (" + _sUseingIds + ")";
        WCMFilter apdsFilter = new WCMFilter("", sDelWhere, "", "");
        StyleItems delStyleItems = this.queryStyleItems(baseStyle, apdsFilter);
        for (int i = 0; i < delStyleItems.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleItem)delStyleItems.getAt(i));
        }
    }

    @Override
    public void delete(User user, BaseStyle _baseStyle) throws WCMException {
        if (_baseStyle == null) {
            return;
        }
        StyleItems styleItems = this.queryStyleItems(_baseStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            styleItem.delete(user);
        }
    }

    @Override
    public HashMap queryStyleItemMap(BaseStyle _baseStyle, WCMFilter _filter) throws WCMException {
        StyleItems styleItems = this.queryStyleItems(_baseStyle, _filter);
        HashMap<String, StyleItem> map = new HashMap<String, StyleItem>();
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            map.put(styleItem.getClassName(), styleItem);
        }
        return map;
    }

    @Override
    public void deleteUnusePageOtherStyleItems(PageStyle _pageStyle, String _sUseingIds) throws WCMException {
        if (_sUseingIds == null || _sUseingIds.length() == 0) {
            return;
        }
        if (_pageStyle == null) {
            throw new WCMException(20, "\u98ce\u683c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u98ce\u683c\u9879\uff01");
        }
        String sDelWhere = "STYLEITEMID not in (" + _sUseingIds + ") and STYLEOBJTYPE=? and STYLEOBJID=?";
        WCMFilter apdsFilter = new WCMFilter("", sDelWhere, "", "");
        apdsFilter.addSearchValues(1);
        apdsFilter.addSearchValues(_pageStyle.getId());
        StyleItems delStyleItems = StyleItems.openWCMObjs(this.getLoginUser(), apdsFilter);
        for (int i = 0; i < delStyleItems.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleItem)delStyleItems.getAt(i));
        }
    }

    @Override
    public StyleItem savePageOtherStyleItem(User _currUser, PageStyle pageStyle, StyleItem _styleItem) throws WCMException {
        int nStyleObjId = 0;
        int nStyleObjType = 1;
        if (pageStyle != null) {
            nStyleObjId = pageStyle.getId();
        }
        _styleItem.setStyleObjId(nStyleObjId);
        _styleItem.setStyleObjType(nStyleObjType);
        _styleItem.save(_currUser);
        return _styleItem;
    }

    @Override
    public StyleItems queryPageOtherStyleItems(PageStyle _pageStyle, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (_pageStyle == null) {
            return StyleItems.createNewInstance(loginUser);
        }
        WCMFilter filter = new WCMFilter("", "STYLEOBJTYPE=? and STYLEOBJID=?", "");
        filter.addSearchValues(1);
        filter.addSearchValues(_pageStyle.getId());
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        return StyleItems.openWCMObjs(loginUser, filter);
    }

    @Override
    public HashMap queryPageOtherStyleItemMap(PageStyle pageStyle, WCMFilter _filter) throws WCMException {
        StyleItems styleItems = this.queryPageOtherStyleItems(pageStyle, _filter);
        HashMap<String, StyleItem> map = new HashMap<String, StyleItem>();
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            map.put(styleItem.getClassName(), styleItem);
        }
        return map;
    }
}

