/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleServiceProvider;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleExporter;
import com.trs.components.common.publish.widget.PageStyleImporter;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.webframework.context.MethodContext;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PageStyleServiceProvider
implements IPageStyleServiceProvider {
    private static transient Logger mLogger = Logger.getLogger(PageStyleServiceProvider.class);
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
    private IStyleCenterMgr m_oStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sPageStyleIds = context.getObjectIds();
        PageStyles pageStyles = PageStyles.findByIds(loginUser, sPageStyleIds);
        HttpServletRequest hsRequest = context.getServiceContext().getRequest();
        HttpSession hsSession = null;
        if (hsRequest != null) {
            hsSession = hsRequest.getSession();
        }
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 13);
            if (!bHasRight) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff0c");
            }
            if (hsSession != null) {
                hsSession.setAttribute("currentPageStyle", (Object)("\u5220\u9664\u9875\u9762\u98ce\u683c\u3010" + pageStyle.getProperty("STYLEDESC") + "\u3011\uff0c"));
            }
            try {
                this.m_oPageStyleMgr.delete(loginUser, pageStyle);
                continue;
            }
            catch (Exception e) {
                if (hsSession == null) continue;
                hsSession.setAttribute("ErrorInfo", (Object)e.getStackTrace());
            }
        }
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        PageStyles pageStyles = this.m_oPageStyleMgr.query(extraFilter);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        return pageStyles;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        int nRightIndex;
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = null;
        if (nPageStyleId > 0) {
            pageStyle = PageStyle.findById(nPageStyleId);
            if (pageStyle == null) {
                throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
            }
        } else {
            pageStyle = new PageStyle();
        }
        if (!(bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, nRightIndex = nPageStyleId > 0 ? 12 : 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (nPageStyleId > 0 ? "\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01" : "\u65b0\u5efa\u98ce\u683c\uff01"));
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        if (nPageStyleId > 0) {
            pLogicFields = new String[]{"ObjectId", "StyleName"};
        }
        pageStyle = (PageStyle)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, pageStyle, pLogicFields);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        if (nPageStyleId == 0) {
            this.m_oStyleCenterMgr.createImgesDir(pageStyle);
            this.m_oStyleCenterMgr.copySystemStyle(loginUser, pageStyle);
            StyleItem oItem = new StyleItem();
            oItem.setClassName("template_box_width");
            oItem.setClassValue("950px");
            this.m_oStyleItemMgr.save(loginUser, pageStyle, oItem);
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        return pageStyle.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveBaseStyle(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(context.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnuseStyleItems(pageStyle, xmlToCMSObj.getObjectIds());
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.save(loginUser, pageStyle, styleItem);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException ex) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + ex));
        }
        return pageStyle.getId();
    }

    public int saveCustomStyle(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        String sCustomStyle = context.getValue("CustomStyle");
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        pageStyle.setCustomStyle(sCustomStyle);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException ex) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + ex));
        }
        return pageStyle.getId();
    }

    public int saveStyleThumb(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        String sStyleThumb = context.getValue("StyleThumb");
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        pageStyle.setStyleThumb(sStyleThumb);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        this.m_oStyleCenterMgr.saveStyleThumb(sStyleThumb);
        return pageStyle.getId();
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return PageStyle.findById(context.getObjectId());
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return PageStyles.findByIds(this.getLoginUser(), context.getObjectIds());
    }

    @Override
    public String exportCssFile(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 4);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.export(pageStyle);
    }

    public String exportPageStyleZip(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sPageStyleIds = context.getObjectIds();
        PageStyles pageStyles = PageStyles.findByIds(loginUser, sPageStyleIds);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        PageStyleExporter pageStyleExporter = (PageStyleExporter)DreamFactory.createObjectById("PageStyleExporter");
        return pageStyleExporter.export(pageStyles, false);
    }

    public String importPageStyleZip(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, PageStyle.createNewInstance(), 11);
        if (!bHasRight) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u98ce\u683c\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u98ce\u683c");
        }
        SpecialPageStyleImportThread sPageThread = new SpecialPageStyleImportThread(loginUser, context);
        sPageThread.doExecute();
        return null;
    }

    public String checkExistPageStyle(MethodContext context) throws Throwable {
        String sPageStyleZipFile = context.getValue("PageStyleZipFile");
        if (sPageStyleZipFile == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        PageStyleImporter pageStyleImporter = (PageStyleImporter)DreamFactory.createObjectById("PageStyleImporter");
        return pageStyleImporter.checkPageStyleNameExists(sPageStyleZipFile);
    }

    public void importCssFile(MethodContext context) throws Throwable {
        int nPageStyleId = context.getObjectId();
        String sUploadCssFile = context.getValue("UploadCssFile");
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        this.m_oStyleCenterMgr.importCssFile(pageStyle, sUploadCssFile);
    }

    @Override
    public String makeCssFile(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
    }

    @Override
    public int copy(MethodContext context) throws Throwable {
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nSourcePageStyleId = context.getValue("SourcePageStyleId", -1);
        String sStyleName = context.getValue("StyleName");
        String sStyleDesc = context.getValue("StyleDesc");
        PageStyle sourcePageStyle = PageStyle.findById(nSourcePageStyleId);
        if (sourcePageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nSourcePageStyleId + "]");
        }
        String sStyleThumb = sourcePageStyle.getStyleThumb();
        PageStyle targetPageStyle = new PageStyle();
        targetPageStyle.setStyleName(sStyleName);
        targetPageStyle.setStyleDesc(sStyleDesc);
        if (!CMyString.isEmpty(sStyleThumb)) {
            targetPageStyle.setStyleThumb(sStyleThumb);
        }
        if (!(bHasRight = SpecialAuthServer.hasRight(loginUser, targetPageStyle, 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7c7b\u4f3c\u521b\u5efa\u98ce\u683c\u3010" + targetPageStyle.getStyleDesc() + "\u3011\uff01");
        }
        targetPageStyle = this.m_oPageStyleMgr.copy(this.getLoginUser(), sourcePageStyle, targetPageStyle);
        return targetPageStyle.getId();
    }

    public boolean checkStyleName(MethodContext context) throws WCMException {
        String sStyleName = context.getValue("StyleName");
        if (CMyString.isEmpty(sStyleName)) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u98ce\u683c\u540d\u79f0\u3010StyleName\u3011\uff01");
        }
        int nObjectId = context.getObjectId();
        WCMFilter filter = new WCMFilter("XWCMPAGESTYLE", "", "", "PageStyleId");
        StringBuffer sWhereBuffer = new StringBuffer();
        sWhereBuffer.append("StyleName=?");
        if (nObjectId > 0) {
            sWhereBuffer.append(" and PageStyleId not in (" + nObjectId + ")");
        }
        filter.addSearchValues(sStyleName);
        filter.setWhere(sWhereBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    public boolean checkStyleDesc(MethodContext context) throws WCMException {
        String sStyleDesc = context.getValue("StyleDesc");
        if (CMyString.isEmpty(sStyleDesc)) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u98ce\u683c\u540d\u79f0\u3010StyleDesc\u3011\uff01");
        }
        int nObjectId = context.getObjectId();
        WCMFilter filter = new WCMFilter("XWCMPAGESTYLE", "", "", "PageStyleId");
        StringBuffer sWhereBuffer = new StringBuffer();
        sWhereBuffer.append("StyleDesc=?");
        if (nObjectId > 0) {
            sWhereBuffer.append(" and PageStyleId not in (" + nObjectId + ")");
        }
        filter.addSearchValues(sStyleDesc);
        filter.setWhere(sWhereBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    public String findStyleImageDir(MethodContext context) throws WCMException {
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        return this.m_oStyleCenterMgr.findStyleImageDir(pageStyle);
    }

    public String makePreviewCssContent(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = _context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle);
    }

    public String previewStyle(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = _context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(_context.getValue("StyleItemXML"));
        StyleItems styleItems = StyleItems.createNewInstance(loginUser);
        int nSize = xmlToCMSObj.getCMSObjs().length;
        for (int i = 0; i < nSize; ++i) {
            StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
            if (styleItem == null) continue;
            styleItem.setId(i + 1);
            styleItem.setAddMode(false);
            styleItem.setStyleObjId(nPageStyleId);
            styleItem.setStyleObjType(368170809);
            styleItems.addElement(styleItem);
        }
        return this.m_oPageStyleMgr.previewStyle(pageStyle, styleItems);
    }

    public PageStyles queryPageStyles(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sWhere = "PageStyleId!=0";
        WCMFilter filter = new WCMFilter("", sWhere, "", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(filter);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        return pageStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int savePageOtherStyle(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(context.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnusePageOtherStyleItems(pageStyle, xmlToCMSObj.getObjectIds());
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.savePageOtherStyleItem(loginUser, pageStyle, styleItem);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException ex) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + ex));
        }
        return pageStyle.getId();
    }

    public ArrayList queryUploadImageFileList(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = _context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[PageStyleId=" + nPageStyleId + "]\u4e0d\u5b58\u5728\uff01");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5c5e\u4e8e\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\u7684\u56fe\u7247\uff01");
        }
        String sFilterExts = _context.getValue("FilterExts");
        ArrayList<FileStore> resultList = new ArrayList<FileStore>();
        IStyleCenterMgr styleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
        String sStyleImagePath = styleCenterMgr.findStyleImageDir(pageStyle);
        if (sStyleImagePath == null) {
            return resultList;
        }
        FileService uploadImageFolder = new FileService(sStyleImagePath);
        if (uploadImageFolder == null) {
            return resultList;
        }
        FileStore[] fs = uploadImageFolder.listFiles();
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                FileStore aFile = fs[i];
                if (aFile == null || aFile.isDirectory() || sFilterExts != null && this.ignoreFile(aFile, sFilterExts)) continue;
                resultList.add(aFile);
            }
        }
        return resultList;
    }

    private boolean ignoreFile(FileStore _aFile, String _sFilterExts) {
        if (_aFile == null || _sFilterExts == null) {
            return true;
        }
        _sFilterExts = "," + _sFilterExts + ",";
        String sFileName = _aFile.getName();
        int nPeriodIndex = sFileName.indexOf(".");
        if (nPeriodIndex < 0 || sFileName.endsWith(".")) {
            return true;
        }
        String sFileExt = "," + sFileName.substring(nPeriodIndex + 1) + ",";
        return _sFilterExts.indexOf(sFileExt) < 0;
    }

    public void deleteUploadImages(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = _context.getObjectId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (pageStyle == null) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[PageStyleId=" + nPageStyleId + "]\u4e0d\u5b58\u5728\uff01");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, pageStyle, 13);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u5c5e\u4e8e\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\u7684\u56fe\u7247\uff01");
        }
        String sDeleteImgNames = _context.getValue("DeleteImgNames");
        IStyleCenterMgr styleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
        String sStyleImagePath = styleCenterMgr.findStyleImageDir(pageStyle);
        if (sStyleImagePath == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c[Id=" + nPageStyleId + "]\u7684\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u4e3anull\uff01");
        }
        FileService uploadImageFolder = new FileService(sStyleImagePath);
        if (uploadImageFolder == null || !uploadImageFolder.exists()) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[Id=" + nPageStyleId + "]\u6240\u5bf9\u5e94\u7684\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84[" + sStyleImagePath + "]\u4e0d\u5b58\u5728\uff01");
        }
        FileStore[] fs = uploadImageFolder.listFiles();
        String sOneFileName = null;
        sDeleteImgNames = "," + sDeleteImgNames + ",";
        for (int i = 0; i < fs.length; ++i) {
            FileStore aFile = fs[i];
            if (aFile == null || aFile.isDirectory() || sDeleteImgNames.indexOf(sOneFileName = "," + aFile.getName() + ",") < 0) continue;
            aFile.delete();
        }
    }

    private class SpecialPageStyleImportThread
    extends Thread {
        private MethodContext methodContext = null;
        private User loginUser = null;
        private int nSuccess = 0;
        private HttpSession m_oSession = null;

        public SpecialPageStyleImportThread(User _currUser, MethodContext _methodContext) {
            this.methodContext = _methodContext;
            HttpServletRequest oRequest = _methodContext.getServiceContext().getRequest();
            if (oRequest != null) {
                this.m_oSession = oRequest.getSession();
            }
            this.loginUser = _currUser;
        }

        public void doExecute() {
            if (this.m_oSession != null) {
                this.start();
                return;
            }
            mLogger.info((Object)"\u6b63\u5728\u8fdb\u884c\u4e13\u9898\u98ce\u683c\u7684\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u521d\u59cb\u5316\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85...");
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            User previousContextUser = null;
            try {
                try {
                    previousContextUser = ContextHelper.getLoginUser();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ContextHelper.initContext(this.loginUser);
                if (this.m_oSession != null) {
                    this.m_oSession.setAttribute("isSuccess", (Object)new Integer(this.nSuccess));
                    this.m_oSession.setAttribute("currentPageStyle", (Object)"\u4fdd\u5b58\u9875\u9762\u98ce\u683c\uff0c");
                    ContextHelper.setArg(5, this.m_oSession);
                }
                String sPageStyleZipFile = this.methodContext.getValue("PageStyleZipFile");
                int nImportMode = this.methodContext.getValue("ImportMode", 1);
                int nSubStyleImportMode = this.methodContext.getValue("SubStyleImportMode", 1);
                if (sPageStyleZipFile == null) {
                    throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
                }
                PageStyleImporter pageStyleImporter = (PageStyleImporter)DreamFactory.createObjectById("PageStyleImporter");
                Reports importReports = pageStyleImporter.importFromFile(sPageStyleZipFile, nImportMode, nSubStyleImportMode);
                if (importReports == null) {
                    return;
                }
                if (this.m_oSession != null) {
                    ArrayList successList = importReports.getExtraData();
                    if (successList == null || successList.size() == 0) {
                        return;
                    }
                    StringBuffer sbSuccessResult = new StringBuffer();
                    boolean bFirstAppend = true;
                    for (int i = 0; i < successList.size(); ++i) {
                        String sOneResult = (String)successList.get(i);
                        if (sOneResult == null || "".equals(sOneResult)) continue;
                        if (!bFirstAppend) {
                            sbSuccessResult.append(",");
                        }
                        sbSuccessResult.append(sOneResult);
                        bFirstAppend = false;
                    }
                    if (bFirstAppend) {
                        return;
                    }
                    this.m_oSession.setAttribute("SuccessInfo", (Object)sbSuccessResult.toString());
                    this.nSuccess = 1;
                    this.m_oSession.setAttribute("isSuccess", (Object)new Integer(this.nSuccess));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.m_oSession != null) {
                    this.m_oSession.setAttribute("ErrorInfo", (Object)e.getMessage());
                }
            }
            finally {
                ContextHelper.clear();
                if (previousContextUser != null) {
                    ContextHelper.setLoginUser(previousContextUser);
                }
            }
        }
    }
}

