/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class TemplateEmploy
extends CMSObj {
    public static final int OBJ_TYPE = 953;
    public static final String DB_TABLE_NAME = "WCMTEMPLATEEMPLOY";
    public static final String DB_ID_NAME = "TEMPLATEEMPLOYID";
    private IPublishElement m_oEmployer = null;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 953;
    }

    public int getEmployerType() {
        return this.getPropertyAsInt("EMPLOYERTYPE", 0);
    }

    public int getEmployerId() {
        return this.getPropertyAsInt("EMPLOYERID", 0);
    }

    public IPublishElement getEmployer() throws Exception {
        if (this.m_oEmployer == null) {
            this.m_oEmployer = PublishElementFactory.lookupElement(this.getEmployerType(), this.getEmployerId());
        }
        return this.m_oEmployer;
    }

    public boolean setEmployer(int _nType, int _nId) throws WCMException {
        return this.setProperty("EMPLOYERTYPE", _nType) && this.setProperty("EMPLOYERID", _nId);
    }

    public boolean setEmployer(IPublishElement _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid employer required!");
        }
        return this.setEmployer(_employer.getType(), _employer.getId());
    }

    public int getTemplateId() {
        return this.getPropertyAsInt("TEMPLATEID", 0);
    }

    public boolean setTemplate(int _nTemplateType, int _nTemplateId) throws WCMException {
        return this.setProperty("TEMPLATEID", _nTemplateId) && this.setProperty("TEMPLATETYPE", _nTemplateType);
    }

    public boolean setTemplate(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        return this.setTemplate(_template.getType(), _template.getId());
    }

    public int getTemplateType() {
        return this.getPropertyAsInt("TEMPLATETYPE", 0);
    }

    public boolean isDefault() {
        return this.getPropertyAsBoolean("ISDEFAULT", false);
    }

    public boolean setDefault(boolean _isDefault) throws WCMException {
        int nDefault = _isDefault ? 1 : 0;
        return this.setProperty("ISDEFAULT", nDefault);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("EMPLOYERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateEmploy.class, "TemplateEmploy.label1", "\u5c5e\u6027EmployerType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("EMPLOYERID") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateEmploy.class, "TemplateEmploy.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TEMPLATEID") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateEmploy.class, "TemplateEmploy.label3", "\u5c5e\u6027TemplateId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TEMPLATETYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateEmploy.class, "TemplateEmploy.label4", "\u5c5e\u6027TemplateType\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(TemplateEmploy.class, "TemplateEmploy.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final TemplateEmploy findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (TemplateEmploy)BaseObj.findById(TemplateEmploy.class, _nId);
    }

    public static final TemplateEmploy createNewInstance() throws WCMException {
        return (TemplateEmploy)BaseObj.createNewInstance(TemplateEmploy.class);
    }

    public static final TemplateEmploy findByKey(Object _oKey) throws WCMException {
        return (TemplateEmploy)BaseObj.findByKey(TemplateEmploy.class, _oKey);
    }

    public Template getTemplate() throws WCMException {
        return Template.findById(this.getTemplateId());
    }
}

