/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TempApdRels;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Template
extends CMSObj {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Template.class);
    public static final int OBJ_TYPE = 102;
    public static final String DB_TABLE_NAME = "WCMTEMPLATE";
    public static final String DB_ID_NAME = "TEMPID";
    public static final int INPUT_TEMPLATE = 0;
    public static final int DETAIL_TEMPLATE = 2;
    public static final int OUTLINE_TEMPLATE = 1;
    public static final int ALL_TEMPLATE = -1;
    public static Pattern m_oBackgroundImagePattern = Pattern.compile("(?im)(<[^>]*?url\\((?:'|\"|&quot;)?)[^>]*?([^>]+?)((?:'|\"|&quot;)?\\)[^>]*?>)");
    private TemplateParameterList m_oParameters = null;
    private boolean m_zHadSetPara = false;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 102;
    }

    public static int guessTypeByName(String _sTempName) {
        if (_sTempName.indexOf(I18NMessage.get(Template.class, "Template.label1", "\u6982\u89c8")) >= 0 || _sTempName.indexOf("outline") >= 0) {
            return 1;
        }
        if (_sTempName.indexOf(I18NMessage.get(Template.class, "Template.label2", "\u7ec6\u89c8")) >= 0 || _sTempName.indexOf("detail") >= 0) {
            return 2;
        }
        if (_sTempName.indexOf(I18NMessage.get(Template.class, "Template.label3", "\u5d4c\u5957")) >= 0) {
            return 0;
        }
        return 1;
    }

    public String getName() {
        return (String)this.getProperty("TEMPNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("TEMPNAME", _name);
    }

    public boolean setType(int _type) throws WCMException {
        return this.setProperty("TEMPTYPE", _type);
    }

    public int getType() {
        return this.getPropertyAsInt("TEMPTYPE", -1);
    }

    public String getOutputFileName() {
        String sFileName = this.getPropertyAsString("OUTPUTFILENAME");
        if (CMyString.isEmpty(sFileName)) {
            if (this.getType() == 1) {
                sFileName = "index";
            }
        } else {
            sFileName = sFileName.replace('/', File.separatorChar);
            sFileName = CMyFile.extractMainFileName(sFileName);
        }
        return sFileName;
    }

    public boolean setOutputFileName(String _sFileName) throws WCMException {
        return this.setProperty("OUTPUTFILENAME", CMyFile.extractFileName(_sFileName));
    }

    public String getOutputFileExt() {
        String sExt = (String)this.getProperty("TEMPEXT");
        if (CMyString.isEmpty(sExt)) {
            sExt = "html";
        } else {
            int nDotIndex;
            int nSlahsIndex = (sExt = sExt.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
            if (nSlahsIndex != -1) {
                sExt = sExt.substring(nSlahsIndex + 1);
            }
            if ((nDotIndex = sExt.lastIndexOf(46)) != -1) {
                sExt = sExt.substring(nDotIndex + 1);
            }
        }
        return sExt;
    }

    public boolean setOutputFileExt(String _ext) throws WCMException {
        return this.setProperty("TEMPEXT", CMyFile.extractFileExt(_ext));
    }

    public int getRootType() {
        return this.getPropertyAsInt("ROOTTYPE", 0);
    }

    public int getRootId() {
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public IPublishFolder getRoot() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getRootType(), this.getRootId());
    }

    public boolean setRoot(int _nType, int _nId) throws WCMException {
        return this.setProperty("ROOTTYPE", _nType) && this.setProperty("ROOTID", _nId);
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public IPublishFolder getFolder() throws WCMException {
        int nId = this.getFolderId();
        if (nId <= 0) {
            return null;
        }
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), nId);
    }

    public boolean setFolder(int _nFolderType, int _nFolderId, int _nRootType, int _nRootId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nFolderType) && this.setProperty("FOLDERID", _nFolderId) && this.setRoot(_nRootType, _nRootId);
    }

    public boolean setFolder(IPublishFolder _folder, IPublishFolder _root) throws WCMException {
        return this.setFolder(_folder.getType(), _folder.getId(), _root.getType(), _root.getId());
    }

    public boolean setFolder(int _nType, int _nId) throws WCMException {
        IPublishFolder folder;
        try {
            folder = (IPublishFolder)PublishElementFactory.lookupElement(_nType, _nId);
        }
        catch (Exception ex) {
            throw new WCMException(200006, "Failed to lookup the specified folder [type=" + _nType + ", id=" + _nId + "]!", ex);
        }
        if (folder == null) {
            throw new WCMException(200006, "The specified folder [type=" + _nType + ", id=" + _nId + "] is not found!");
        }
        return this.setFolder(folder);
    }

    public boolean setFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        IPublishFolder root = _folder.getRoot();
        if (root == null) {
            throw new WCMException(200006, "Root of the folder not found!");
        }
        return this.setFolder(_folder.getType(), _folder.getId(), root.getType(), root.getId());
    }

    public String getDesc() {
        return (String)this.getProperty("TEMPDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("TEMPDESC", _desc);
    }

    public String getTempText() {
        return ((CDBText)this.getProperty("TEMPTEXT")).getText();
    }

    public String getText() {
        return CMyString.showNull(((CDBText)this.getProperty("TEMPTEXT")).getText(), I18NMessage.get(Template.class, "Template.label4", "\u65e0\u5185\u5bb9"));
    }

    public boolean setText(String _text) throws WCMException {
        return this.setTextProperty("TEMPTEXT", _text);
    }

    public boolean isApdModified() {
        return this.getPropertyAsBoolean("APDMODIFIED", false);
    }

    public boolean setApdModified(boolean _bModified) throws WCMException {
        return this.setProperty("APDMODIFIED", _bModified);
    }

    public boolean isParsed() {
        return this.getPropertyAsBoolean("ISPARSED", false);
    }

    public boolean setParsed(boolean _bParsed) throws WCMException {
        return this.setProperty("ISPARSED", _bParsed);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sOutputFileName;
        String sName = null;
        String sAllowJsp = ConfigServer.getServer().getSysConfigValue("TEMPLATE_ALLOW_JSP_EXT", "false");
        if (!"true".equalsIgnoreCase(sAllowJsp)) {
            String sSuffix = this.getFinalPropertyAsString("TEMPEXT");
            if ("jsp".equals(sSuffix = CMyString.showEmpty(sSuffix).toLowerCase()) || "jspx".equals(sSuffix)) {
                throw new WCMException("\u6a21\u677f\u540e\u7f00\u4e0d\u5141\u8bb8\u4e3aJSP(X)!");
            }
        }
        if (this.isAddMode()) {
            sName = (String)this.getProperty("TEMPNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label5", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TEMPTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label6", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ROOTTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label7", "\u5c5e\u6027RootType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label8", "\u5c5e\u6027RootId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") != null && this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label9", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (CMyString.isEmpty(this.getPropertyAsString("TEMPEXT"))) {
                this.setPropertyWithString("TEMPEXT", "html");
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Template.class, "Template.label10", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            sName = (String)this.getNewProperty("TEMPNAME");
        }
        if (sName != null) {
            WCMFilter filter = new WCMFilter();
            filter.setFrom(DB_TABLE_NAME);
            StringBuilder where = new StringBuilder("ROOTTYPE = ? and ROOTID = ? and TEMPNAME = ?");
            filter.addSearchValues(this.getRootType());
            filter.addSearchValues(this.getRootId());
            filter.addSearchValues(sName);
            if (!this.isAddMode()) {
                where.append(" and " + this.getIdFieldName() + " <> ?");
                filter.addSearchValues(this.getId());
            }
            filter.setWhere(where.toString());
            if (DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0) {
                throw new BizError("\u6a21\u677f\u540d\u79f0[" + sName + "]\u5df2\u7ecf\u5b58\u5728");
            }
        }
        if ((sOutputFileName = this.getFinalPropertyAsString("OUTPUTFILENAME", "")).matches("^.*[\\.\\\\//].*$")) {
            throw new WCMException("The outputfilename contains invalid chars [.\\/].");
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setApdModified(true);
            if (this.getProperty("FOLDERID") == null) {
                this.setFolder(0, 0);
            }
            if (this.getProperty("ISPARSED") == null) {
                this.setParsed(false);
            }
            this.setCrUser(_currUser);
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    @Override
    public void save(User _currUser) throws WCMException {
        this.setLastModified(_currUser);
        super.save(_currUser);
    }

    private void setLastModified(User _currUser) throws WCMException {
        this.setProperty("LASTMODIFIEDUSER", _currUser.getName());
        this.setProperty("LASTMODIFIEDTIME", CMyDateTime.now());
    }

    public TempAppendixes getAppendixes(User _currUser) throws WCMException {
        return this.getAppendixes(_currUser, null);
    }

    public TempAppendixes getAppendixes(User _currUser, int[] arrFlags) throws WCMException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("WCMTempApdRel.TEMPID=").append(this.getId());
            buff.append(" AND WCMTempAppendix.TEMPAPPENDIXID=WCMTempApdRel.APPENDIXID");
            if (arrFlags != null) {
                buff.append(" AND WCMTempAppendix.APDFLAG");
                if (arrFlags.length == 1) {
                    buff.append('=').append(arrFlags[0]);
                } else {
                    buff.append(" in (");
                    for (int i = 0; i < arrFlags.length; ++i) {
                        if (i > 0) {
                            buff.append(',');
                        }
                        buff.append(arrFlags[i]);
                    }
                    buff.append(')');
                }
            }
            String sWhere = buff.toString();
            buff.setLength(0);
            TempAppendixes appendixes = new TempAppendixes(_currUser);
            appendixes.open(new WCMFilter("WCMTempAppendix, WCMTempApdRel", sWhere, "", "WCMTempAppendix.*"));
            return appendixes;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label13", "\u63d0\u53d6\u6a21\u677f\u7684\u9644\u4ef6\u96c6\u5408\u5931\u8d25"), ex);
        }
    }

    public TempApdRels getApdRels(WCMFilter _filter) throws WCMException {
        try {
            WCMFilter filter = new WCMFilter("", "TEMPID=" + this.getId(), "");
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            TempApdRels rels = new TempApdRels(ContextHelper.getLoginUser());
            rels.open(filter);
            return rels;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the template appendix relations!", ex);
        }
    }

    public TempAppendix addAppendix(User _currUser, String _sFile, boolean _bAddRelation) throws WCMException {
        TempAppendix appendix = null;
        try {
            int nRootType = this.getRootType();
            int nRootId = this.getRootId();
            String sWhere = "APDFILE='" + CMyString.filterForSQL(_sFile) + "' AND ROOTID=" + nRootId + " AND ROOTTYPE=" + nRootType;
            TempAppendixes appendixes = new TempAppendixes(_currUser, 1, 1);
            appendixes.open(new WCMFilter("", sWhere, ""));
            if (appendixes.isEmpty()) {
                try {
                    appendix = (TempAppendix)appendixes.addNew();
                    appendix.setRoot(nRootType, nRootId);
                    appendix.setFile(_sFile);
                    appendix.setFlag(0);
                    appendix.setCrUser(_currUser);
                    appendixes.update();
                }
                catch (Exception ex2) {
                    throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label14", "\u65b0\u5efa\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), ex2);
                }
            } else {
                appendix = (TempAppendix)appendixes.getAt(0);
            }
            if (_bAddRelation) {
                appendix.addRelation(this);
            }
            return appendix;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label15", "\u6dfb\u52a0\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), ex);
        }
    }

    public boolean deleteAppendix(TempAppendix _appendix) throws WCMException {
        if (_appendix == null || !_appendix.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Template.class, "Template.label16", "\u65e0\u6548\u7684\u6a21\u677f\u9644\u4ef6\u5bf9\u8c61"));
        }
        return _appendix.deleteRelation(this);
    }

    public boolean deleteAppendix(int _appendixId) throws WCMException {
        String SQL = "DELETE FROM WCMTEMPAPDREL WHERE TEMPID=? AND APPENDIXID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = this.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPAPDREL WHERE TEMPID=? AND APPENDIXID=?");
            oPreStmt.setInt(1, this.getId());
            oPreStmt.setInt(2, _appendixId);
            boolean bl = oPreStmt.executeUpdate() > 0;
            return bl;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label17", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25"), ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public int clearAppendixes() throws WCMException {
        TempAppendixes appendixes = this.getAppendixes(ContextHelper.getLoginUser());
        int nCount = this.clearAppendixRelaion();
        this.clearAppendixsData(appendixes);
        return nCount;
    }

    private int clearAppendixRelaion() throws WCMException {
        String SQL = "DELETE FROM WCMTEMPAPDREL WHERE TEMPID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = this.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPAPDREL WHERE TEMPID=?");
            oPreStmt.setInt(1, this.getId());
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label17", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25"), ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    protected void clearAppendixsData(TempAppendixes _appendixes) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        for (int i = 0; i < _appendixes.size(); ++i) {
            TempAppendix appendix = (TempAppendix)_appendixes.getAt(i);
            if (appendix == null || this.isInUse(appendix)) continue;
            appendix.delete(currUser);
            this.deleteLocalAppendixFile(appendix.getFile());
            this.deleteAppendixFileDistributed(appendix.getFile());
        }
    }

    private boolean isInUse(TempAppendix _appendix) throws WCMException {
        String SQL = "SELECT COUNT(*) FROM WCMTEMPAPDREL WHERE AppendixId=" + _appendix.getId();
        return this.getDBManager().sqlExecuteIntQuery(SQL) > 0;
    }

    private void deleteLocalAppendixFile(String _sFile) {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sLocalSrcPath = "";
        try {
            sLocalSrcPath = filesMan.getTemplateAppendixPath(this.getRootType(), this.getRootId(), 0, false);
        }
        catch (WCMException e) {
            logger.error((Object)"failed to get the appendix local source path!", (Throwable)e);
        }
        String sLocalPubHttpPath = "";
        try {
            sLocalPubHttpPath = filesMan.getPathConfigValue("LP", 0) + this.getApdFilePubHttpPath();
        }
        catch (Exception e) {
            logger.error((Object)"failed to get the appendix local pub path!", (Throwable)e);
        }
        CMyFile.deleteFile(sLocalSrcPath + _sFile);
        CMyFile.deleteFile(sLocalPubHttpPath + _sFile);
    }

    private void deleteAppendixFileDistributed(String _sFile) {
        FileDistributeShip ship = new FileDistributeShip();
        try {
            ship.withdrawFile(_sFile, this.getRoot(), this.getApdFilePubHttpPath());
        }
        catch (Exception e) {
            logger.error((Object)("failed to withdraw a distributed template appendix file[" + _sFile + "]"), (Throwable)e);
        }
    }

    public String getApdFilePubHttpPath() throws Exception {
        IPublishFolder root = this.getRoot();
        if (root == null) {
            return null;
        }
        return "/" + root.getDataPath() + "/images/";
    }

    public String getPubText() throws WCMException {
        boolean bStartImagesSite;
        boolean bImageURLDisanbledByConfig = false;
        int nWebSiteid = this.getRoot().getId();
        logger.debug((Object)"get into IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS");
        logger.debug((Object)this.getName());
        String imageUrlFilterBySiteIds = ConfigServer.getServer().getSysConfigValue("IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS", "");
        if (("," + imageUrlFilterBySiteIds + ",").indexOf("," + String.valueOf(nWebSiteid) + ",") >= 0) {
            bImageURLDisanbledByConfig = true;
        }
        if ((bStartImagesSite = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"))) && !bImageURLDisanbledByConfig) {
            IPublishFolder rootFolder = this.getRoot();
            if (rootFolder == null) {
                throw new WCMException(I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label19", "]\u7684Root[ID=") + this.getRootId() + I18NMessage.get(Template.class, "Template.label20", "]\u4e0d\u5b58\u5728\uff01"));
            }
            String[] pImgSrcPre = Template.convertURL2ImageURL(rootFolder.getDataPath());
            return this.getTextWithImgFilter(pImgSrcPre, true);
        }
        return this.getTextWithImgFilter("${ROOT_PATH}images/", true);
    }

    public String getTextWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute) throws WCMException {
        return this.getTextWithImgFilter(new String[]{_sImgSrcPre}, _bRemoveExtraAttribute);
    }

    public String getTextWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute, boolean _bRemoveIgnoreApdAttr) throws WCMException {
        return this.getTextWithImgFilter(new String[]{_sImgSrcPre}, _bRemoveExtraAttribute, _bRemoveIgnoreApdAttr);
    }

    public String getTextWithImgFilter(String[] _pImgSrcPre, boolean _bRemoveExtraAttribute) throws WCMException {
        return this.getTextWithImgFilter(_pImgSrcPre, _bRemoveExtraAttribute, true);
    }

    private String getTextWithImgFilter(String[] _pImgSrcPre, boolean _bRemoveExtraAttribute, boolean _bRemoveIgnoreApdAttr) throws WCMException {
        String sText = this.getText();
        if (sText == null || sText.length() == 0) {
            return "";
        }
        if ("XML".equalsIgnoreCase(this.getOutputFileExt())) {
            return sText;
        }
        String[] arTagName = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] arTagSrcName = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        int nImgSrcPreIndex = 0;
        try {
            for (int nTagIndex = 0; nTagIndex < arTagName.length; ++nTagIndex) {
                HtmlElement element;
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                HtmlElementFinder imgFinder = new HtmlElementFinder(sText);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String strSrc;
                    if (_bRemoveIgnoreApdAttr) {
                        element.removeAttribute("ignoreapd");
                    }
                    if ((strSrc = element.getAttributeValue("OLDSRC")) != null) {
                        String sSrcPre = _pImgSrcPre[nImgSrcPreIndex++];
                        strSrc = sSrcPre + strSrc;
                        if (nImgSrcPreIndex >= _pImgSrcPre.length) {
                            nImgSrcPreIndex = 0;
                        }
                        element.setAttribute(currTagSrcName, strSrc);
                        if (_bRemoveExtraAttribute) {
                            element.removeAttribute("OLDSRC");
                            element.removeAttribute("OLDID");
                            element.removeAttribute("RELATED");
                        }
                    }
                    imgFinder.putElement(element);
                }
                sText = imgFinder.getContent();
            }
            StringBuffer sbResult = new StringBuffer(sText.length() + 200);
            Matcher oMatcher = m_oBackgroundImagePattern.matcher(sText);
            int nStartIndex = 0;
            while (oMatcher.find()) {
                sbResult.append(sText.substring(nStartIndex, oMatcher.start()));
                nStartIndex = oMatcher.end();
                String sSrcAttributeValue = oMatcher.group(2);
                int nPos = sSrcAttributeValue.lastIndexOf(92);
                if (nPos < 0) {
                    nPos = sSrcAttributeValue.lastIndexOf(47);
                }
                String sResFileName = sSrcAttributeValue.substring(nPos + 1);
                int nAppendixId = this.queryTemplateApdRelationId(this.getId(), sResFileName);
                if (nAppendixId <= 0) {
                    sbResult.append(oMatcher.group());
                    continue;
                }
                sbResult.append(oMatcher.group(1));
                String sSrcPre = _pImgSrcPre[nImgSrcPreIndex++];
                if (nImgSrcPreIndex >= _pImgSrcPre.length) {
                    nImgSrcPreIndex = 0;
                }
                sbResult.append(sSrcPre + sResFileName);
                sbResult.append(oMatcher.group(3));
            }
            if (nStartIndex < sText.length()) {
                sbResult.append(sText.substring(nStartIndex, sText.length()));
            }
            return sbResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(Template.class, "Template.label21", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6a21\u677f\u6b63\u6587\u5185\u5bb9\u5931\u8d25"), ex);
        }
    }

    private int queryTemplateApdRelationId(int _nTemplateId, String _sSrcAttributeName) throws WCMException {
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select AppendixId from WCMTempApdRel where TempId=? and exists(select 1 from wcmtempappendix where ApdFile=? and WCMTempApdRel.AppendixId=wcmtempappendix.TempAppendixId)";
        ArrayList<Object> lParameters = new ArrayList<Object>();
        lParameters.add(new Integer(_nTemplateId));
        lParameters.add(_sSrcAttributeName);
        return dbMgr.sqlExecuteIntQuery(strSQL, lParameters);
    }

    public synchronized void updateAppendixStatus() throws WCMException {
        block6: {
            try {
                if (!this.canEdit(User.getSystem())) break block6;
                try {
                    this.setApdModified(false);
                    this.update(User.getSystem());
                }
                catch (Exception ex) {
                    try {
                        this.cancelUpdate(User.getSystem());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this.getName() + I18NMessage.get(Template.class, "Template.label22", "]\u9644\u4ef6\u5c5e\u6027\u66f4\u65b0\u9519\u8bef!"), ex);
                }
            }
            catch (Exception ex) {
                throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this.getName() + I18NMessage.get(Template.class, "Template.label22", "]\u9644\u4ef6\u5c5e\u6027\u66f4\u65b0\u9519\u8bef!"), ex);
            }
        }
    }

    public boolean isHaveRelation(Connection _oConn, int _nAppendixId) throws Exception {
        Statement oStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        boolean bExisted = false;
        oStmt = _oConn.createStatement();
        rsData = oStmt.executeQuery(strSQL = "select count(*) from WCMTempApdRel  where tempid=" + this.getId() + " and appendixid=" + _nAppendixId);
        if (rsData.next()) {
            bExisted = rsData.getInt(1) > 0;
        }
        rsData.close();
        oStmt.close();
        return bExisted;
    }

    public static final Template findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Template)BaseObj.findById(Template.class, _nId);
    }

    public static final Template createNewInstance() throws WCMException {
        return (Template)BaseObj.createNewInstance(Template.class);
    }

    public static final Template findByKey(Object _oKey) throws WCMException {
        return (Template)BaseObj.findByKey(Template.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getInfo();
    }

    public String getInfo() {
        return this.getName() + I18NMessage.get(Template.class, "Template.label23", "[\u6a21\u677f-") + this.getId() + "]";
    }

    public TemplateParameterList getTemplateParameters() {
        if (!this.m_zHadSetPara) {
            try {
                this.m_zHadSetPara = true;
                TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
                parseMgr.parse(this);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(Template.class, "Template.label24", "\u83b7\u53d6\u6a21\u677f\u7684\u5f62\u5f0f\u53c2\u6570\u5217\u8868\u5931\u8d25!"), (Throwable)e);
            }
        }
        return this.m_oParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateParameterList getTemplateParameters(boolean zRecursion) {
        TemplateParameterList list = this.getTemplateParameters();
        if (zRecursion && list != null) {
            Template template = this;
            synchronized (template) {
                if (!list.getNestParsed()) {
                    list.setNestParsed(true);
                }
            }
        }
        return list;
    }

    public void setTemplateParameters(TemplateParameterList list) {
        this.m_oParameters = list;
        this.m_zHadSetPara = true;
    }

    public boolean isAccessibleFrom(IPublishFolder _folder) {
        int thisFolderType = this.getFolderType();
        int thisFolderId = this.getFolderId();
        while (_folder != null) {
            if (thisFolderType == _folder.getType() && thisFolderId == _folder.getId()) {
                return true;
            }
            try {
                _folder = _folder.getParent();
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(Template.class, "Template.label25", "\u83b7\u53d6") + _folder.getInfo() + I18NMessage.get(Template.class, "Template.label26", "\u7684\u7236\u76ee\u5f55\u5931\u8d25")), (Throwable)e);
                break;
            }
        }
        return false;
    }

    public Template getNestedTemplate(IPublishElement element, String sIdentity) {
        if (sIdentity == null || sIdentity.length() <= 0) {
            return null;
        }
        try {
            TagItem tagItem;
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDoc = parseMgr.parse(this);
            Iterator itr = tagDoc.findItems("TRS_TEMPLATE");
            while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
                String sIdAuto = this.makeNestedIndentiy(tagItem.getAttribute("TEMPNAME"));
                if (!sIdentity.equals(tagItem.getAttribute("IDENTITY")) && !sIdentity.equals(sIdAuto)) continue;
                PublishPageContext p = new PublishPageContext(element, null);
                PublishTagContext t = new PublishTagContext(p);
                t.setTagItem(tagItem);
                return TagParseHelper.findNestedTemplate(t);
            }
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(Template.class, "Template.label27", "\u83b7\u53d6\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label28", "]\u4e2d\u6307\u5b9a\u6807\u8bc6[") + sIdentity + I18NMessage.get(Template.class, "Template.label29", "]\u7684\u5d4c\u5957\u6a21\u677f\u5931\u8d25!")), (Throwable)e);
        }
        return null;
    }

    public String makeNestedIndentiy(String nestedName) {
        StringBuffer buff = new StringBuffer(32);
        buff.append(nestedName).append('_').append(this.id);
        return buff.toString();
    }

    public Iterator iterateNestedIdentity() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            TagItem tagItem;
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDoc = parseMgr.parse(this);
            Iterator itr = tagDoc.findItems("TRS_TEMPLATE");
            String sIdAuto = null;
            while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
                String sIdentity = tagItem.getAttribute("IDENTITY");
                if (sIdentity != null) {
                    list.add(sIdentity);
                    continue;
                }
                sIdAuto = this.makeNestedIndentiy(tagItem.getAttribute("TEMPNAME"));
                if (list.contains(sIdAuto)) continue;
                list.add(sIdAuto);
            }
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(Template.class, "Template.label30", "\u679a\u4e3e\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label31", "]\u4e2d\u5e26\u6709\u6807\u8bc6\u7684\u5d4c\u5957\u6a21\u677f\u5931\u8d25!")), (Throwable)e);
        }
        if (list.size() > 0) {
            return list.listIterator();
        }
        return null;
    }

    public static String[] convertURL2ImageURL(String _sRootDataPath) throws WCMException {
        String sImageSiteCount = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
        int nImageSiteCount = Integer.parseInt(sImageSiteCount);
        String sImgSitePre = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String sImgMainDomain = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String[] pResult = new String[nImageSiteCount];
        if ("TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("IMAGE_PUBLISH_IN52", "FALSE"))) {
            for (int i = 0; i < nImageSiteCount; ++i) {
                pResult[i] = "http://" + sImgSitePre + (i + 1) + "." + sImgMainDomain + "/" + _sRootDataPath + "/" + "images/";
            }
        } else {
            pResult[0] = "http://" + sImgSitePre + "." + sImgMainDomain + "/" + _sRootDataPath + "/" + "images/";
            for (int i = 1; i < nImageSiteCount; ++i) {
                pResult[i] = "http://" + sImgSitePre + i + "." + sImgMainDomain + "/" + _sRootDataPath + "/" + "images/";
            }
        }
        return pResult;
    }

    public String getCharSet() throws WCMException {
        String charset = this.getPropertyAsString("TEMPCHARSET");
        if (CMyString.isEmpty(charset)) {
            charset = this.getRoot().getEncoding();
        }
        if (CMyString.isEmpty(charset)) {
            charset = "utf-8";
        }
        return charset;
    }

    public boolean setCharSet(String charset) throws WCMException {
        return this.setPropertyWithString("TEMPCHARSET", charset);
    }
}

