/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.taskdispatch;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishErrorLog;
import com.trs.components.common.publish.persistent.taskdispatch.PublishErrorLogs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class PublishTask
extends CMSObj {
    private static final Logger s_logger = Logger.getLogger(PublishTask.class);
    public static final int OBJ_TYPE = -1676813972;
    public static final String DB_TABLE_NAME = "WCMPUBLISHTASK";
    public static final String DB_ID_NAME = "PUBLISHTASKID";
    public static final int TITLE_LENGTH_MAX = 266;
    public static final int DESC_LENGTH_MAX = 1333;
    public static final int CONTENT_IDS_LENGTH_MAX = 400;
    private static final int MAX_URL_LENGTH = 500;
    private static final char URL_SEPERATOR = '~';
    private static Logger logger = Logger.getLogger(PublishTask.class);

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return -1676813972;
    }

    public int getPublishType() {
        return this.getPropertyAsInt("PUBLISHTYPE", 0);
    }

    public boolean setPublishType(int _nPublishType) throws WCMException {
        return this.setProperty("PUBLISHTYPE", _nPublishType);
    }

    public int getPriority() {
        return this.getPropertyAsInt("TASKPRIORITY", 5);
    }

    public void setPriority(int _nPriority) throws WCMException {
        this.setProperty("TASKPRIORITY", _nPriority);
    }

    public int getStatus() {
        return this.getPropertyAsInt("TASKSTATUS", 0);
    }

    public boolean isExecuted() {
        return PublishConstants.isTaskExecuted(this.getStatus());
    }

    public boolean setStatus(int _nStatus) throws WCMException {
        return this.setProperty("TASKSTATUS", _nStatus);
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public IPublishFolder getFolder() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), this.getFolderId());
    }

    public boolean setFolder(int _nType, int _nId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nType) && this.setProperty("FOLDERID", _nId);
    }

    public boolean setFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig required!");
        }
        return this.setFolder(_folder.getType(), _folder.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("CONTENTTYPE", 0);
    }

    public String getContentIds() {
        return this.getPropertyAsString("CONTENTIDS");
    }

    public IPublishElements getContents() throws WCMException {
        String sContentIds = this.getContentIds();
        if (sContentIds == null || (sContentIds = sContentIds.trim()).length() == 0) {
            return null;
        }
        return PublishElementFactory.lookupElements(this.getContentType(), sContentIds);
    }

    public boolean setContent(int _nType, String _sIds) throws WCMException {
        return this.setProperty("CONTENTTYPE", _nType) && this.setProperty("CONTENTIDS", _sIds);
    }

    public boolean setContent(IPublishContent _content) throws WCMException {
        if (_content == null) {
            return this.setProperty("CONTENTTYPE", 0L);
        }
        return this.setContent(_content.getType(), String.valueOf(_content.getId()));
    }

    public String getTitle() {
        return this.getPropertyAsString("TASKTITLE");
    }

    public boolean setTitle(String _sTitle) throws WCMException {
        if (_sTitle == null) {
            return false;
        }
        if (_sTitle.length() > 266) {
            _sTitle = _sTitle.substring(0, 263) + "...";
        }
        return this.setProperty("TASKTITLE", _sTitle);
    }

    public String[] getURLs() {
        String sTaskUrl = this.getPropertyAsString("TASKURL");
        return sTaskUrl == null ? null : CMyString.split(sTaskUrl, String.valueOf('~'));
    }

    public boolean setURL(String[] _sURL) throws WCMException {
        if (_sURL == null) {
            return false;
        }
        String sTaskURL = null;
        if (_sURL != null) {
            int nCurrentLen = 0;
            for (int i = 0; i < _sURL.length && (nCurrentLen += _sURL[i].length()) < 500; ++i) {
                sTaskURL = i == 0 ? _sURL[i] : sTaskURL + '~' + _sURL[i];
            }
        } else {
            sTaskURL = "";
        }
        return this.setProperty("TASKURL", sTaskURL);
    }

    public String getDesc() {
        return this.getPropertyAsString("TASKDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        if (_sDesc == null) {
            return false;
        }
        if (_sDesc.length() > 1333) {
            _sDesc = _sDesc.substring(0, 1330) + "...";
        }
        return this.setProperty("TASKDESC", _sDesc);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("STARTTIME");
    }

    public boolean setStartTime(CMyDateTime _startTime) throws WCMException {
        return this.setProperty("STARTTIME", _startTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("ENDTIME");
    }

    public boolean setEndTime(CMyDateTime _endTime) throws WCMException {
        return this.setProperty("ENDTIME", _endTime);
    }

    public int getTimeUsed() {
        int nTimeUsed = this.getPropertyAsInt("TIMEUSED", 0);
        if (nTimeUsed <= 0 && (this.getEndTime() == null || this.getEndTime().isNull())) {
            long ltStartTime = this.getStartTime().getTimeInMillis();
            if (ltStartTime <= 0L) {
                return 0;
            }
            return (int)(System.currentTimeMillis() - ltStartTime);
        }
        return nTimeUsed;
    }

    public boolean setTimeUsed(int _nTimeUsed) throws WCMException {
        return this.setProperty("TIMEUSED", _nTimeUsed);
    }

    public boolean isHasWarnings() {
        return this.getPropertyAsBoolean("HASWARNINGS", false);
    }

    public boolean setHasWarnings(boolean _bHasWarnings) throws WCMException {
        return this.setProperty("HASWARNINGS", _bHasWarnings);
    }

    public int getPageTaskCount() {
        return this.getPropertyAsInt("PAGETASKCOUNT", 0);
    }

    public boolean setPageTaskCount(int _nCount) throws WCMException {
        return this.setProperty("PAGETASKCOUNT", _nCount);
    }

    public String getAnalyzeError() {
        return this.getPropertyAsString("ANALYZEERROR");
    }

    public boolean setAnalyzeError(String _sAnalyzeError) throws WCMException {
        if (_sAnalyzeError != null && _sAnalyzeError.length() > 1000) {
            _sAnalyzeError = _sAnalyzeError.substring(0, 1000);
        }
        return this.setProperty("ANALYZEERROR", _sAnalyzeError);
    }

    public int getDetailPageCount() {
        return this.getPropertyAsInt("DETAILPAGES", 0);
    }

    public boolean setDetailPageCount(int _nCount) throws WCMException {
        return this.setProperty("DETAILPAGES", _nCount);
    }

    public int getOutlinePageCount() {
        return this.getPropertyAsInt("OUTLINEPAGES", 0);
    }

    public boolean setOutlinePageCount(int _nCount) throws WCMException {
        return this.setProperty("OUTLINEPAGES", _nCount);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("FOLDERTYPE") == null) {
                throw new WCMException(1106, "Property of FolerType required!");
            }
            if (this.getAllProperty().get("FOLDERID") == null) {
                throw new WCMException(1106, "Property of FolderId required!");
            }
            if (this.getAllProperty().get("PUBLISHTYPE") == null) {
                throw new WCMException(1106, "Property of PublishType required!");
            }
            if (this.getAllProperty().get("TASKSTATUS") == null) {
                throw new WCMException(1106, "Property of Status required!");
            }
            if (this.getAllProperty().get("TASKTITLE") == null) {
                throw new WCMException(1106, "Property of Title required!");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishTask.class, "PublishTask.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (logger.isDebugEnabled() && _currUser.isSystem()) {
            logger.debug((Object)"who call me?", (Throwable)new Exception());
        }
        if (this.isAddMode() && this.getAllProperty() != null) {
            Hashtable<String, Object> properties = this.getAllProperty();
            if (properties.get("TASKSTATUS") == null) {
                this.setStatus(1);
            }
            if (properties.get("CONTENTTYPE") == null) {
                this.setContent(null);
            }
            if (properties.get("HASWARNINGS") == null) {
                this.setHasWarnings(false);
            }
            if (properties.get("TIMEUSED") == null) {
                this.setTimeUsed(0);
            }
            if (properties.get("PAGETASKCOUNT") == null) {
                this.setPageTaskCount(0);
            }
            if (properties.get("CRUSER") == null) {
                this.setCrUser(_currUser);
            }
            if (properties.get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(_currUser);
        }
    }

    public static final PublishTask findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (PublishTask)BaseObj.findById(PublishTask.class, _nId);
    }

    public static final PublishTask createNewInstance() throws WCMException {
        return (PublishTask)BaseObj.createNewInstance(PublishTask.class);
    }

    public static final PublishTask findByKey(Object _oKey) throws WCMException {
        return (PublishTask)BaseObj.findByKey(PublishTask.class, _oKey);
    }

    public boolean isPublishContent() {
        return this.getContentType() != 0;
    }

    public boolean isPublishFolder() {
        return this.getContentType() == 0;
    }

    public PublishErrorLogs getErrorLogs(User _currUser, WCMFilter _filter) throws WCMException {
        try {
            String sWhere = "PUBLISHTASKID=?";
            WCMFilter filter = new WCMFilter("", sWhere, "");
            filter.addSearchValues(this.getId());
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            PublishErrorLogs logs = new PublishErrorLogs(_currUser);
            logs.open(filter);
            logs.setPageSize(logs.size());
            return logs;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the task error logs!", ex);
        }
    }

    public PublishErrorLog addErrorLog(User _currUser, IPublishElement _publishElement, String _sDesc, int _nResult, String _sErrorDetail) throws WCMException {
        try {
            PublishErrorLog log = PublishErrorLog.createNewInstance();
            if (_publishElement != null) {
                if (_publishElement instanceof IPublishFolder) {
                    log.setFolder((IPublishFolder)_publishElement);
                } else {
                    log.setContent((IPublishContent)_publishElement);
                    log.setFolder(((IPublishContent)_publishElement).getFolder());
                }
            }
            log.setPublishTask(this);
            log.setDesc(_sDesc);
            log.setResult(_nResult);
            log.setErrorDetail(_sErrorDetail);
            log.setCrUser(_currUser);
            log.insert(_currUser);
            return log;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to add error log for publish task!", ex);
        }
    }

    public PublishTask duplicate(User _currUser, boolean _bInsert2DB) throws WCMException {
        try {
            PublishTask copy = PublishTask.createNewInstance();
            copy.setPublishType(this.getPublishType());
            copy.setFolder(this.getFolderType(), this.getFolderId());
            copy.setContent(this.getContentType(), this.getContentIds());
            copy.setPriority(this.getPriority());
            copy.setStatus(1);
            copy.setCrUser(_currUser);
            if (_bInsert2DB) {
                copy.insert(_currUser);
            }
            return copy;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to duplicate the publish task!", ex);
        }
    }

    public String getFolderIds() {
        return this.getPropertyAsString("FOLDERIDS");
    }

    public IPublishElements getFolders() throws WCMException {
        String sFolderIds = this.getFolderIds();
        if (sFolderIds == null || (sFolderIds = sFolderIds.trim()).length() == 0) {
            return null;
        }
        return PublishElementFactory.lookupElements(this.getFolderType(), sFolderIds);
    }

    public boolean setFolders(IPublishElements folders) throws WCMException {
        if (folders.size() > 0) {
            IPublishElement obj = folders.get(0);
            if (obj instanceof IPublishFolder) {
                int iType = obj.getType();
                StringBuffer sb = new StringBuffer();
                sb.append(obj.getId());
                int size = folders.size();
                for (int i = 1; i < size; ++i) {
                    sb.append(',');
                    sb.append(folders.get(i).getSubstance().getId());
                }
                return this.setProperty("FOLDERTYPE", iType) && this.setFolders(sb.toString());
            }
            StringBuffer sb = new StringBuffer(256);
            sb.append('[').append(obj.getInfo()).append("] 's class is [");
            sb.append(obj.getClass().getName());
            sb.append("], not IPublishFolder");
            s_logger.warn((Object)sb.toString());
        }
        return false;
    }

    public boolean setFolders(String sFolders) throws WCMException {
        if (sFolders != null && (sFolders = sFolders.trim()).length() > 0) {
            return this.setProperty("FOLDERIDS", sFolders);
        }
        return false;
    }

    public boolean isSchedulePublishTask() {
        return this.getPropertyAsBoolean("ISSCHEDULEDTASK", false);
    }

    public boolean setSchedulePublishTask(boolean _bSchedulePublishTask) throws WCMException {
        return this.setProperty("ISSCHEDULEDTASK", _bSchedulePublishTask);
    }
}

