/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.taskdispatch;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.Hashtable;

public class PublishErrorLog
extends CMSObj {
    public static final int OBJ_TYPE = 826020995;
    public static final String DB_TABLE_NAME = "WCMPUBLISHERRORLOG";
    public static final String DB_ID_NAME = "PUBLISHERRORLOGID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 826020995;
    }

    public int getPublishTaskId() {
        return this.getPropertyAsInt("PUBLISHTASKID", 0);
    }

    public boolean setPublishTask(int _nPublishTaskId) throws WCMException {
        return this.setProperty("PUBLISHTASKID", _nPublishTaskId);
    }

    public boolean setPublishTask(PublishTask _task) throws WCMException {
        if (_task == null || !_task.isValidInstance()) {
            throw new WCMException(10, "PublishTask must be valid instance!");
        }
        return this.setPublishTask(_task.getId());
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int _nType, int _nId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nType) && this.setProperty("FOLDERID", _nId);
    }

    public boolean setFolder(IPublishFolder _folder) throws WCMException {
        CMSObj objFolder = null;
        if (_folder != null) {
            objFolder = _folder.getSubstance();
        }
        if (objFolder == null) {
            return this.setFolder(0, 0);
        }
        return this.setFolder(objFolder.getWCMType(), objFolder.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("CONTENTTYPE", 0);
    }

    public int getContentId() {
        return this.getPropertyAsInt("CONTENTID", 0);
    }

    public boolean setContent(int _nType, int _nId) throws WCMException {
        return this.setProperty("CONTENTTYPE", _nType) && this.setProperty("CONTENTID", _nId);
    }

    public boolean setContent(IPublishContent _content) throws WCMException {
        CMSObj objContent = null;
        if (_content != null) {
            objContent = _content.getSubstance();
        }
        if (objContent == null) {
            return this.setContent(0, 0);
        }
        return this.setContent(objContent.getWCMType(), objContent.getId());
    }

    public int getResult() {
        return this.getPropertyAsInt("EXERESULT", 0);
    }

    public boolean setResult(int _nResult) throws WCMException {
        return this.setProperty("EXERESULT", _nResult);
    }

    public String getDesc() {
        return this.getPropertyAsString("PAGETASKDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("PAGETASKDESC", _sDesc);
    }

    public String getErrorDetail() {
        return this.getPropertyAsString("ERRORDETAIL");
    }

    public boolean setErrorDetail(String _sDetail) throws WCMException {
        if (_sDetail != null && _sDetail.length() > 2000) {
            _sDetail = _sDetail.substring(0, 2000);
        }
        return this.setProperty("ERRORDETAIL", _sDetail);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("PUBLISHTASKID") == null) {
                throw new WCMException(1106, "Property of PublishTaskId required!");
            }
            if (this.getAllProperty().get("FOLDERTYPE") == null) {
                throw new WCMException(1106, "Property of FolderTypeConfig required!");
            }
            if (this.getAllProperty().get("FOLDERID") == null) {
                throw new WCMException(1106, "Property of FolderId required!");
            }
            if (this.getAllProperty().get("EXERESULT") == null) {
                throw new WCMException(1106, "Property of Result required!");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishErrorLog.class, "PublishErrorLog.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            Hashtable<String, Object> properties = this.getAllProperty();
            if (properties.get("CONTENTTYPE") == null || properties.get("CONTENTID") == null) {
                this.setContent(null);
            }
            if (properties.get("CRUSER") == null) {
                this.setCrUser(_currUser);
            }
            if (properties.get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(_currUser);
        }
    }

    public static final PublishErrorLog findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (PublishErrorLog)BaseObj.findById(PublishErrorLog.class, _nId);
    }

    public static final PublishErrorLog createNewInstance() throws WCMException {
        return (PublishErrorLog)BaseObj.createNewInstance(PublishErrorLog.class);
    }

    public static final PublishErrorLog findByKey(Object _oKey) throws WCMException {
        return (PublishErrorLog)BaseObj.findByKey(PublishErrorLog.class, _oKey);
    }
}

