/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.publisher;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class FolderPublishConfigCacheMgr {
    private static Logger logger = Logger.getLogger(FolderPublishConfigCacheMgr.class);
    private LRUCacheContainer m_lruCache = null;
    public static int MAX_CACHE_SIZE = 30000;

    private synchronized void initCache() {
        if (this.m_lruCache != null) {
            return;
        }
        this.m_lruCache = new LRUCacheContainer();
        this.m_lruCache.setMaxSize(MAX_CACHE_SIZE);
        WCMFilter filter = new WCMFilter("", "FolderType != 605", "FolderId desc");
        filter.setMaxRowNumber(MAX_CACHE_SIZE);
        try {
            FolderPublishConfigs aConfigs = FolderPublishConfigs.openWCMObjs(User.getSystem(), filter);
            int nSize = aConfigs.size();
            for (int i = 0; i < nSize; ++i) {
                FolderPublishConfig config = (FolderPublishConfig)aConfigs.getAt(i);
                if (config == null) continue;
                String sKey = this.makeKey(config.getFolderType(), config.getFolderId());
                this.m_lruCache.put((Object)sKey, (Object)config);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(FolderPublishConfigCacheMgr.class, "FolderPublishConfigCacheMgr.label1", "\u521d\u59cb\u5316\u9891\u9053\u7684\u53d1\u5e03\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    protected void notifyOnRemoveConfig(FolderPublishConfig _removeConfig) {
        if (this.m_lruCache == null) {
            this.initCache();
        }
        this.m_lruCache.remove((Object)this.makeKey(_removeConfig.getFolderType(), _removeConfig.getFolderId()));
    }

    protected FolderPublishConfig findConfig(int _nFolderType, int _nFolderId) throws WCMException {
        Object oValue;
        if (this.m_lruCache == null) {
            this.initCache();
        }
        if ((oValue = this.m_lruCache.get((Object)this.makeKey(_nFolderType, _nFolderId))) != null) {
            return (FolderPublishConfig)oValue;
        }
        return this.loadConfig(_nFolderType, _nFolderId);
    }

    private synchronized FolderPublishConfig loadConfig(int _nFolderType, int _nFolderId) throws WCMException {
        String sKey = this.makeKey(_nFolderType, _nFolderId);
        Object oValue = this.m_lruCache.get((Object)sKey);
        if (oValue != null) {
            return (FolderPublishConfig)oValue;
        }
        String sWhere = "FolderType=? and FolderId=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(0, _nFolderType);
        aFilter.addSearchValues(1, _nFolderId);
        aFilter.setMaxRowNumber(1);
        FolderPublishConfigs aConfigs = FolderPublishConfigs.openWCMObjs(User.getSystem(), aFilter);
        if (aConfigs.isEmpty()) {
            return null;
        }
        FolderPublishConfig aConfig = (FolderPublishConfig)aConfigs.getAt(0);
        if (aConfig == null) {
            return null;
        }
        this.m_lruCache.put((Object)sKey, (Object)aConfig);
        return aConfig;
    }

    private String makeKey(int _nFolderType, int _nFolderId) {
        return _nFolderType + "_" + _nFolderId;
    }
}

