/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.template.TemplateArgumentCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateQuoteMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.Collection;
import java.util.HashMap;

public abstract class PublishFolderImplBase
implements IPublishFolder {
    public static boolean INHERIT_ROOT_DETAIL_TEMPLATE = false;
    private Templates m_oOutlineTemplates = null;
    private Template m_oDetailTemplate = null;

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public IPublishFolder getFolder() {
        return this;
    }

    @Override
    public String getEncoding() throws WCMException {
        FolderPublishConfig config = FolderPublishConfig.findOf(this.getRoot());
        if (config == null) {
            throw new WCMDatainvalidException(1100, "[" + this.getRoot().getInfo() + I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"));
        }
        return config.getPageEncoding();
    }

    @Override
    public HashMap getTemplateArguments() throws WCMException {
        TemplateArgumentCacheMgr tac = (TemplateArgumentCacheMgr)DreamFactory.createObjectById("TemplateArgumentCacheMgr");
        return tac.getArguments(this);
    }

    @Override
    public Collection getFoldersQuotingMe() throws WCMException {
        TemplateQuoteMgr mgr = (TemplateQuoteMgr)DreamFactory.createObjectById("TemplateQuoteMgr");
        return mgr.getFoldersWhoseOutlineQuotesContentsOf(this);
    }

    @Override
    public Templates getOutlineTemplates() {
        if (this.m_oOutlineTemplates == null) {
            TemplateEmployMgr mgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            try {
                this.m_oOutlineTemplates = mgr.getOutlineTemplates(this);
            }
            catch (Exception e) {
                throw new RuntimeException(CMyString.format(I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label7", "\u83b7\u53d6[{0}]\u7684\u6982\u89c8\u6a21\u677f\u53d1\u751f\u5f02\u5e38"), new Object[]{this.getInfo()}), e);
            }
        }
        return this.m_oOutlineTemplates;
    }

    @Override
    public Template getDetailTemplate() {
        if (this.m_oDetailTemplate == null) {
            TemplateEmployMgr mgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            try {
                this.m_oDetailTemplate = mgr.getDetailTemplate(this);
            }
            catch (Exception e) {
                throw new RuntimeException(CMyString.format(I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label8", "\u83b7\u53d6[{0}]\u7684\u7ec6\u89c8\u6a21\u677f\u5931\u8d25"), new Object[]{this.getInfo()}), e);
            }
            if (this.m_oDetailTemplate == null && INHERIT_ROOT_DETAIL_TEMPLATE && !this.isRoot()) {
                try {
                    IPublishFolder root = this.getRoot();
                    if (!this.equals(root)) {
                        this.m_oDetailTemplate = root.getDetailTemplate();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(CMyString.format(I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label9", "\u83b7\u53d6[{0}]Root\u7684\u7ec6\u89c8\u6a21\u677f\u5931\u8d25"), new Object[]{this.getInfo()}), e);
                }
            }
        }
        return this.m_oDetailTemplate;
    }

    @Override
    public String getRootDomain() throws WCMException {
        FolderPublishConfig config = FolderPublishConfig.findOf(this);
        if (config == null) {
            throw new WCMDatainvalidException(1100, "[" + this.getInfo() + I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"));
        }
        return config.getRootDomain();
    }

    @Override
    public String getDataPath() throws WCMException {
        FolderPublishConfig config = FolderPublishConfig.findOf(this);
        if (config == null) {
            return String.valueOf(this.getId());
        }
        return config.getDataPath();
    }

    @Override
    public String getInfo() {
        if (this.getSubstance() == null) {
            return I18NMessage.get(PublishFolderImplBase.class, "PublishFolderImplBase.label6", "\u5bf9\u8c61\u4e0d\u5b58\u5728[Type=") + this.getType() + ",Id=" + this.getId() + "]";
        }
        return this.getSubstance().toString();
    }

    @Override
    public boolean canDoPreview() {
        return true;
    }

    public boolean equals(Object _another) {
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof IPublishFolder)) {
            return false;
        }
        IPublishFolder anotherCMS = (IPublishFolder)_another;
        return this.getType() == anotherCMS.getType() && this.getId() == anotherCMS.getId();
    }

    @Override
    public String getPathKey() {
        return Integer.toHexString(this.getId()) + '.' + Integer.toHexString(this.getType());
    }

    public int hashCode() {
        int id = this.getId();
        int type = this.getType();
        int result = 1;
        result = 31 * result + id ^ id >>> 32;
        result = 31 * result + type ^ type >>> 32;
        return result;
    }
}

