/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishContentImplBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.util.Iterator;

public class PublishContentDefaultObjImpl
extends PublishContentImplBase {
    private DefaultObj m_oDefaultObj = null;
    private DBManager dbMgr = DBManager.getDBManager();
    private String m_sStatusFieldName = null;
    private int m_nPublishedStatus = 50;
    private String m_sPubTimeFieldName = null;
    private String m_sURLFieldName = null;

    public PublishContentDefaultObjImpl() {
    }

    public PublishContentDefaultObjImpl(DefaultObj _obj) {
        this.m_oDefaultObj = _obj;
    }

    public void setStatusFieldName(String _sStatusFieldName) {
        this.m_sStatusFieldName = _sStatusFieldName;
    }

    public void setPubTimeAndURLFieldName(String _sPubTimeFieldName, String _sURLFieldName) {
        this.m_sPubTimeFieldName = _sPubTimeFieldName;
        this.m_sURLFieldName = _sURLFieldName;
    }

    public void setPublishedStatus(int _nPublishedStatus) {
        this.m_nPublishedStatus = _nPublishedStatus;
    }

    @Override
    public int getBodyType() {
        return this.m_oDefaultObj.getWCMType();
    }

    @Override
    public boolean isPublishedInHome() throws Exception {
        if (this.m_sStatusFieldName != null) {
            int nStatus = this.m_oDefaultObj.getPropertyAsInt("DOCSTATUS", 1);
            return nStatus == this.m_nPublishedStatus;
        }
        return true;
    }

    @Override
    public void setPublishStatus(int _nStatus) throws WCMException {
        if (this.m_sStatusFieldName == null) {
            return;
        }
        int nNewStatusId = this.transformStatusId(_nStatus);
        String[] pSQL = new String[]{"update " + this.m_oDefaultObj.getDbTableName() + " set " + this.m_sStatusFieldName + "=? where " + this.m_oDefaultObj.getIdFieldName() + "=?"};
        int[] pParameters = new int[]{nNewStatusId, this.m_oDefaultObj.getId()};
        this.dbMgr.sqlExecuteUpdate(pSQL, pParameters);
    }

    private int transformStatusId(int status) {
        switch (status) {
            case 50: {
                return this.m_nPublishedStatus;
            }
        }
        return 0;
    }

    @Override
    public void setPublishTime(CMyDateTime _dtTime) throws WCMException {
        if (this.m_sPubTimeFieldName == null) {
            return;
        }
        String[] pSQL = new String[]{"update " + this.m_oDefaultObj.getDbTableName() + " set " + this.m_sPubTimeFieldName + "=? where " + this.m_oDefaultObj.getIdFieldName() + "=?"};
        Object[] pParameters = new Object[]{_dtTime.toTimestamp(), new Integer(this.m_oDefaultObj.getId())};
        this.dbMgr.sqlExecuteUpdate(pSQL, pParameters);
    }

    @Override
    public void setPublishTimeAndURL(CMyDateTime _time, String url) throws WCMException {
        String sUpdateSQL = null;
        if (this.m_sPubTimeFieldName != null && this.m_sStatusFieldName != null) {
            sUpdateSQL = "update " + this.m_oDefaultObj.getDbTableName() + " set " + this.m_sPubTimeFieldName + "=?, " + this.m_sURLFieldName + "=? where " + this.m_oDefaultObj.getIdFieldName() + "=?";
        } else {
            if (this.m_sPubTimeFieldName != null) {
                this.setPublishTime(_time);
                return;
            }
            if (this.m_sURLFieldName != null) {
                return;
            }
        }
        if (sUpdateSQL == null) {
            return;
        }
        String[] pSQL = new String[]{sUpdateSQL};
        Object[] pParameters = new Object[]{_time.toTimestamp(), url, new Integer(this.m_oDefaultObj.getId())};
        this.dbMgr.sqlExecuteUpdate(pSQL, pParameters);
    }

    @Override
    public IPublishFolder getOriginalHome() {
        return this.m_folder;
    }

    @Override
    public void validateCanDoPreview() throws WCMException {
        this.m_folder.validateCanDoPreview();
    }

    @Override
    public int getType() {
        return 8888;
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oDefaultObj;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_oDefaultObj = (DefaultObj)_cmsObj;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        throw new WCMException(I18NMessage.get(PublishContentDefaultObjImpl.class, "PublishContentDefaultObjImpl.label1", "\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u65b9\u6cd5\uff01"));
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) throws WCMException {
        if (!(_cmsObj instanceof DefaultObj)) {
            throw new WCMException(I18NMessage.get(PublishContentDefaultObjImpl.class, "PublishContentDefaultObjImpl.label2", "\u5bf9\u8c61[") + _cmsObj + I18NMessage.get(PublishContentDefaultObjImpl.class, "PublishContentDefaultObjImpl.label3", "]\u7c7b\u578b\u4e0d\u5339\u914d\uff01"));
        }
        this.m_oDefaultObj = (DefaultObj)_cmsObj;
    }

    @Override
    public Iterator getRelatedResources() {
        return null;
    }

    @Override
    public boolean isCanDoSave(User _loginUser) {
        return false;
    }
}

