/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class PublishTaskMgrImpl
implements IPublishTaskMgr {
    @Override
    public PublishTask save(PublishTask _task) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        if (_task == null) {
            throw new WCMException(10, "The publish task must be a valid instance!");
        }
        if (_task.isValidInstance()) {
            _task.update(currUser);
        } else {
            _task.insert(currUser);
        }
        return _task;
    }

    @Override
    public boolean delete(PublishTask _task) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        if (_task == null) {
            throw new WCMException(10, "The publish task must be a valid instance!");
        }
        int nRet = _task.delete(currUser);
        return nRet == 1;
    }

    @Override
    public PublishTasks getMyTasks(WCMFilter _filter) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        String sWhere = "CRUSER='" + CMyString.filterForSQL(currUser.getName()) + "'";
        WCMFilter filter = new WCMFilter("", sWhere, "CRTIME DESC");
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        PublishTasks tasks = new PublishTasks(currUser);
        tasks.open(filter);
        return tasks;
    }

    @Override
    public PublishTasks getTasks(WCMFilter _filter) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        WCMFilter filter = new WCMFilter("", "", "CRTIME DESC");
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        PublishTasks tasks = new PublishTasks(currUser);
        tasks.open(filter);
        return tasks;
    }

    @Override
    public PublishTasks getUnfinishedTasks() throws WCMException {
        String FILTER_WHERE = "TASKSTATUS<7";
        try {
            User currUser = ContextHelper.getLoginUser();
            PublishTasks tasks = new PublishTasks(currUser);
            tasks.open(new WCMFilter("", "TASKSTATUS<7", ""));
            return tasks;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the unfinished publish tasks!", ex);
        }
    }

    @Override
    public PublishTask createFolderPublishTask(IPublishFolder _folder, int _nPublishType) throws WCMException {
        if (!PublishConstants.isPublishTypeOfFolder(_nPublishType)) {
            throw new WCMException(10, "Invalid folder publish type: " + _nPublishType);
        }
        String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]");
        String sTitle = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{_folder.getInfo(), sPublishTypeName});
        return this.createPublishTask(_folder, 0, null, _nPublishType, sTitle, sTitle, 1, null);
    }

    @Override
    public PublishTask createPublishTaskForFolderAndPubDocs(IPublishFolder _folder, int _nPublishType, CMyDateTime _startDocCrTime, CMyDateTime _endDocCrtime) throws WCMException {
        if (!PublishConstants.isPublishTypeOfFolder(_nPublishType)) {
            throw new WCMException(10, "Invalid folder publish type: " + _nPublishType);
        }
        String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]");
        String sTitle = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{_folder.getInfo(), sPublishTypeName});
        return this.creatPublishTaskForFolderAndPublishedDocs(_folder, _nPublishType, sTitle, sTitle, 1, _startDocCrTime, _endDocCrtime);
    }

    @Override
    public PublishTask createContentPublishTask(IPublishContent _content, int _nPublishType) throws WCMException {
        if (!PublishConstants.isPublishTypeOfContent(_nPublishType)) {
            throw new WCMException(10, "Invalid content publish type: " + _nPublishType);
        }
        IPublishFolder folder = _content.getFolder();
        if (folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (plz call IPublishContent.setFolder())!");
        }
        String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]", true);
        String sTitle = sPublishTypeName + ": " + _content.getInfo();
        String sDesc = sTitle + I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label2", "\n \u5728") + folder.getInfo() + I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d");
        CMSObj objContent = _content.getSubstance();
        return this.createPublishTask(folder, objContent.getWCMType(), String.valueOf(objContent.getId()), _nPublishType, sTitle, sDesc, 9, null);
    }

    @Override
    public List<PublishTask> createContentPublishTask(IPublishElements _contents, IPublishFolder _folder, int _nPublishType) throws WCMException {
        if (!PublishConstants.isPublishTypeOfContent(_nPublishType)) {
            throw new WCMException(10, "Invalid content publish type: " + _nPublishType);
        }
        if (_contents == null || _contents.isEmpty()) {
            return new ArrayList<PublishTask>();
        }
        List<List<IPublishContent>> contentslists = this.splitContentsByIdMaxLen(_contents);
        ArrayList<PublishTask> tasks = new ArrayList<PublishTask>();
        for (List<IPublishContent> contents : contentslists) {
            tasks.add(this.createContentPublishTask(contents, _folder, _nPublishType));
        }
        return tasks;
    }

    public List<List<IPublishContent>> splitContentsByIdMaxLen(IPublishElements _contents) throws WCMException {
        ArrayList<List<IPublishContent>> contentLists = new ArrayList<List<IPublishContent>>();
        StringBuffer buffIds = new StringBuffer();
        boolean isStart = true;
        ArrayList<IPublishContent> contents = new ArrayList<IPublishContent>();
        for (int i = 0; i < _contents.size(); ++i) {
            try {
                IPublishContent aContent = (IPublishContent)_contents.get(i);
                if (buffIds.length() + ("," + aContent.getId()).length() > 400) {
                    contentLists.add(contents);
                    isStart = true;
                    contents = new ArrayList();
                    buffIds = new StringBuffer();
                }
                if (!isStart) {
                    buffIds.append(',');
                }
                buffIds.append(aContent.getId());
                contents.add(aContent);
                isStart = false;
                continue;
            }
            catch (Exception ex) {
                throw new WCMException(224, "Failed to create contents publishing task!", ex);
            }
        }
        if (!contents.isEmpty()) {
            contentLists.add(contents);
        }
        return contentLists;
    }

    public List<List<IPublishElement>> splitDestroyContentsByIdMaxLen(IPublishElements _contents) throws WCMException {
        ArrayList<List<IPublishElement>> contentLists = new ArrayList<List<IPublishElement>>();
        StringBuffer buffIds = new StringBuffer();
        boolean isStart = true;
        ArrayList<IPublishElement> contents = new ArrayList<IPublishElement>();
        for (int i = 0; i < _contents.size(); ++i) {
            try {
                IPublishElement aContent = _contents.get(i);
                if (buffIds.length() + ("," + aContent.getId()).length() > 400) {
                    contentLists.add(contents);
                    isStart = true;
                    contents = new ArrayList();
                    buffIds = new StringBuffer();
                }
                if (!isStart) {
                    buffIds.append(',');
                }
                buffIds.append(aContent.getSubstance().getId());
                contents.add(aContent);
                isStart = false;
                continue;
            }
            catch (Exception ex) {
                throw new WCMException(224, "Failed to create contents publishing task!", ex);
            }
        }
        if (!contents.isEmpty()) {
            contentLists.add(contents);
        }
        return contentLists;
    }

    private PublishTask createContentPublishTask(List<IPublishContent> _contents, IPublishFolder _folder, int _nPublishType) throws WCMException {
        StringBuffer buffIds = null;
        try {
            StringBuffer buffDesc = new StringBuffer();
            IPublishContent aContent = null;
            buffIds = new StringBuffer(_contents.size() * 7);
            for (int i = 0; i < _contents.size(); ++i) {
                aContent = _contents.get(i);
                if (i > 0) {
                    buffIds.append(',');
                    buffDesc.append("\n");
                }
                buffIds.append(aContent.getId());
                buffDesc.append(aContent.getInfo());
            }
            String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]", true);
            String sTitle = sPublishTypeName + ": " + CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7b49[{1}]\u7bc7\u6587\u7ae0"), new String[]{_contents.get(0).getInfo(), String.valueOf(_contents.size())});
            buffDesc.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label2", "\n \u5728"));
            buffDesc.append(_folder.getInfo());
            buffDesc.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d"));
            String sDesc = sPublishTypeName + ": \n" + buffDesc.toString();
            if (aContent == null) {
                throw new WCMException(224, "Failed to create contents publishing task!");
            }
            PublishTask publishTask = this.createPublishTask(_folder, aContent.getSubstance().getWCMType(), buffIds.toString(), _nPublishType, sTitle, sDesc, 9, null);
            return publishTask;
        }
        catch (Exception ex) {
            throw new WCMException(224, "Failed to create contents publishing task!", ex);
        }
    }

    private PublishTask createPublishTask(IPublishFolder _folder, int _nContentType, String _sContentIds, int _nPublishType, String _sTitle, String _sDesc, int _nPriority, String _sFolderIds) throws WCMException {
        if (this.isExistsPublishTask(_folder, _nContentType, _sContentIds, _nPublishType, _sFolderIds)) {
            return null;
        }
        PublishTask newTask = null;
        User currUser = ContextHelper.getLoginUser();
        try {
            newTask = PublishTask.createNewInstance();
            Object contextParam = ContextParameters.get(7);
            if (Boolean.TRUE == contextParam) {
                newTask.setSchedulePublishTask(true);
            } else {
                newTask.setSchedulePublishTask(false);
            }
            newTask.setPublishType(_nPublishType);
            newTask.setFolder(_folder);
            if (_sContentIds != null) {
                newTask.setContent(_nContentType, _sContentIds);
            }
            newTask.setPriority(_nPriority);
            newTask.setStatus(1);
            newTask.setTitle(_sTitle);
            newTask.setDesc(_sDesc);
            newTask.setCrUser(currUser);
            if (_sFolderIds != null) {
                newTask.setFolders(_sFolderIds);
            }
            newTask.insert(currUser);
            return newTask;
        }
        catch (Exception ex) {
            throw new WCMException(224, "Failed to create publishing task for [" + _sTitle + "].", ex);
        }
    }

    private PublishTask creatPublishTaskForFolderAndPublishedDocs(IPublishFolder _folder, int _nPublishType, String _sTitle, String _sDesc, int _nPriority, CMyDateTime _startDocCrtime, CMyDateTime _endDocCrTime) throws WCMException {
        if (this.isExistsPublishTask(_folder, 0, null, _nPublishType, null)) {
            return null;
        }
        PublishTask newTask = null;
        User currUser = ContextHelper.getLoginUser();
        try {
            newTask = PublishTask.createNewInstance();
            Object contextParam = ContextParameters.get(7);
            if (Boolean.TRUE == contextParam) {
                newTask.setSchedulePublishTask(true);
            } else {
                newTask.setSchedulePublishTask(false);
            }
            newTask.setPublishType(_nPublishType);
            newTask.setFolder(_folder);
            newTask.setPriority(_nPriority);
            newTask.setStatus(1);
            newTask.setTitle(_sTitle);
            newTask.setDesc(_sDesc);
            newTask.setCrUser(currUser);
            newTask.setAttribute("StartDocCrtime", _startDocCrtime.toString());
            newTask.setAttribute("EndDocCrtime", _endDocCrTime.toString());
            newTask.insert(currUser);
            return newTask;
        }
        catch (Exception ex) {
            throw new WCMException(224, "Failed to create publishing task for [" + _sTitle + "].", ex);
        }
    }

    private boolean isExistsPublishTask(IPublishFolder _folder, int _nContentType, String _sContentIds, int _nPublishType, String _sFolderIds) throws WCMException {
        int nExistsTaskId;
        int nParamLength = 3;
        StringBuffer sbQuerySQL = new StringBuffer(200);
        sbQuerySQL.append("select PUBLISHTASKID from WCMPUBLISHTASK where PUBLISHTYPE=? and FOLDERTYPE=? and FOLDERID=? AND TASKSTATUS in(");
        sbQuerySQL.append(1);
        sbQuerySQL.append(")");
        if (_sContentIds != null) {
            sbQuerySQL.append(" and CONTENTTYPE=? and CONTENTIDS=? ");
            nParamLength += 2;
        }
        if (_sFolderIds != null && (_sFolderIds = _sFolderIds.trim()).length() > 0) {
            sbQuerySQL.append(" and FOLDERIDS=?");
            ++nParamLength;
        }
        int nParamIndex = 0;
        Object[] oParameters = new Object[nParamLength];
        oParameters[nParamIndex++] = new Integer(_nPublishType);
        oParameters[nParamIndex++] = new Integer(_folder.getType());
        oParameters[nParamIndex++] = new Integer(_folder.getId());
        if (_sContentIds != null) {
            oParameters[nParamIndex++] = new Integer(_nContentType);
            oParameters[nParamIndex++] = _sContentIds;
        }
        if (_sFolderIds != null && (_sFolderIds = _sFolderIds.trim()).length() > 0) {
            oParameters[nParamIndex++] = _sFolderIds;
        }
        return (nExistsTaskId = this.sqlExecuteIntQuery(sbQuerySQL.toString(), oParameters)) > 0;
    }

    @Override
    public PublishTask createContentPublishTask(IPublishContent _content, IPublishFolder _folder, IPublishElements _folders) throws WCMException {
        if (_content == null) {
            return null;
        }
        if (_folder == null) {
            return null;
        }
        try {
            PublishTask task;
            String sPublishTypeName = PublishConstants.getPublishTypeName(10, "[unknown publish type PUBLISH_CONTENT_DIRECT]", true);
            String sTitle = sPublishTypeName + ": " + _content.getInfo();
            int iCount = 0;
            StringBuffer buffIds = new StringBuffer();
            StringBuffer buffDesc = new StringBuffer();
            buffDesc.append(sTitle).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label4", " \u5728"));
            buffDesc.append(_folder.getInfo()).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d"));
            if (_folders != null) {
                int size = _folders.size();
                for (int i = 0; i < size; ++i) {
                    IPublishElement folder = _folders.get(i);
                    if (folder == null) continue;
                    if (iCount > 0) {
                        buffIds.append(',');
                    } else {
                        buffDesc.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label5", "\uff0c\u5e76\u89e6\u53d1\u4ee5\u4e0b\u9891\u9053\u7684\u6982\u89c8\u66f4\u65b0\uff1a"));
                    }
                    buffIds.append(folder.getSubstance().getId());
                    buffDesc.append("\n").append(folder.getInfo());
                    ++iCount;
                }
            }
            String sDesc = buffDesc.toString();
            PublishTask publishTask = task = this.createPublishTask(_folder, _content.getSubstance().getWCMType(), String.valueOf(_content.getSubstance().getId()), 10, sTitle, sDesc, 9, buffIds.toString());
            return publishTask;
        }
        catch (Exception ex) {
            throw new WCMException(224, "Failed to create contents publish task!", ex);
        }
    }

    @Override
    public List<PublishTask> createDestroyPublishTask(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders) throws WCMException {
        if (_contents == null || _contents.isEmpty()) {
            return new ArrayList<PublishTask>();
        }
        if (_folder == null) {
            return new ArrayList<PublishTask>();
        }
        ArrayList<PublishTask> tasks = new ArrayList<PublishTask>();
        try {
            List<List<IPublishElement>> contentsLists = this.splitDestroyContentsByIdMaxLen(_contents);
            for (List<IPublishElement> contents : contentsLists) {
                tasks.add(this.createDestroyPublishTask(contents, _folder, _folders));
            }
            ArrayList<PublishTask> arrayList = tasks;
            return arrayList;
        }
        catch (Exception ex) {
            throw new WCMException(224, "Failed to create contents publish task!", ex);
        }
    }

    private PublishTask createDestroyPublishTask(List<IPublishElement> _contents, IPublishFolder _folder, IPublishElements _folders) throws WCMException {
        String sPublishTypeName = PublishConstants.getPublishTypeName(7, "[unknown publish type PUBLISH_RECALL]");
        int iContentType = 0;
        StringBuffer sbContentIds = new StringBuffer();
        StringBuffer sbDesc = new StringBuffer();
        sbDesc.append(sPublishTypeName).append(": ");
        for (int i = 0; i < _contents.size(); ++i) {
            IPublishElement content = _contents.get(i);
            if (i > 0) {
                sbContentIds.append(',');
                sbDesc.append(',');
            } else {
                iContentType = content.getSubstance().getWCMType();
            }
            sbContentIds.append(content.getSubstance().getId());
            sbDesc.append(content.getInfo());
        }
        String sTitle = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7b49[{1}]\u7bc7\u6587\u7ae0"), new String[]{_contents.get(0).getInfo(), String.valueOf(_contents.size())});
        sbDesc.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label4", " \u5728")).append(_folder.getInfo()).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d"));
        String sContentIds = sbContentIds.toString();
        String sDesc = sbDesc.toString();
        StringBuffer sbFolderIds = new StringBuffer();
        if (_folders != null && !_folders.isEmpty()) {
            for (int i = 0; i < _folders.size(); ++i) {
                IPublishElement folder = _folders.get(i);
                if (folder == null) continue;
                if (i > 0) {
                    sbFolderIds.append(',');
                }
                sbFolderIds.append(folder.getSubstance().getId());
            }
        }
        String sFolderIds = sbFolderIds.toString();
        PublishTask task = this.createPublishTask(_folder, iContentType, sContentIds, 7, sTitle, sDesc, 9, sFolderIds);
        return task;
    }

    private int sqlExecuteIntQuery(String _sQuerySQL, Object[] _pParamerters) throws WCMException {
        int nResult = -999;
        DBManager dbMgr = DBManager.getDBManager();
        Connection conn = dbMgr.getConnection();
        PreparedStatement preStm = null;
        ResultSet rsData = null;
        try {
            preStm = conn.prepareStatement(_sQuerySQL);
            for (int j = 0; j < _pParamerters.length; ++j) {
                preStm.setObject(j + 1, _pParamerters[j]);
            }
            preStm.setMaxRows(1);
            rsData = preStm.executeQuery();
            if (rsData.next()) {
                nResult = rsData.getInt(1);
            }
            rsData.close();
            rsData = null;
            preStm.close();
            preStm = null;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label6", "\u66f4\u65b0DocStatus\u5931\u8d25\uff01"), e);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            dbMgr.freeConnection(conn);
        }
        return nResult;
    }

    @Override
    public PublishTask createDeleteContentsSynPublishTask(IPublishFolder _folder, IPublishElements _contents) throws WCMException {
        int _nPublishType = 12;
        int nContentType = 0;
        StringBuffer sbContentIds = new StringBuffer(_contents.size() * 7);
        for (int i = 0; i < _contents.size(); ++i) {
            IPublishContent content = (IPublishContent)_contents.get(i);
            nContentType = content.getType();
            sbContentIds.append(content.getId());
            sbContentIds.append(",");
        }
        sbContentIds.setLength(sbContentIds.length() - 1);
        String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]");
        String sTitle = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{_folder.getInfo(), sPublishTypeName});
        return this.createPublishTask(_folder, nContentType, sbContentIds.toString(), _nPublishType, sTitle, sTitle, 9, null);
    }

    @Override
    public PublishTask createDeleteContentsSynPublishTask(IPublishFolder _folder, IPublishContent _content) throws WCMException {
        int _nPublishType = 12;
        String sPublishTypeName = PublishConstants.getPublishTypeName(_nPublishType, "[unknown publish type " + _nPublishType + "]");
        String sTitle = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{_folder.getInfo(), sPublishTypeName});
        return this.createPublishTask(_folder, _content.getType(), String.valueOf(_content.getId()).toString(), _nPublishType, sTitle, sTitle, 9, null);
    }
}

