/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.domain.taskdispatch.SinglePageTask;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class BatchDetailPageTask
implements IPageTask,
IClearable {
    private static Logger logger = Logger.getLogger(BatchDetailPageTask.class);
    private IPublishFolder m_folder;
    private boolean m_bPublishAll;
    private int m_nPublishType = 0;
    private IPublishElementsIterator m_itContents = null;
    private IPublishElements m_contents = null;
    private int m_nCurrPos = -1;
    private int m_nLoadBatchContentsModal = 1;
    private int m_nLoadBatchContentsPageSize = 100;

    public BatchDetailPageTask(IPublishFolder _folder, boolean _bPublishAll) {
        try {
            this.m_nLoadBatchContentsModal = PublishServerConfigMapper.getLoadBatchContentsModal();
            this.m_nLoadBatchContentsPageSize = PublishServerConfigMapper.getLoadBatchContentsPageSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_folder = _folder;
        this.m_bPublishAll = _bPublishAll;
    }

    public BatchDetailPageTask(IPublishFolder _folder, boolean _bPublishAll, int _nBatchContentsModal) {
        try {
            this.m_nLoadBatchContentsModal = _nBatchContentsModal;
            this.m_nLoadBatchContentsPageSize = PublishServerConfigMapper.getLoadBatchContentsPageSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_folder = _folder;
        this.m_bPublishAll = _bPublishAll;
    }

    @Override
    public String getInfo() {
        return "batch detail page task to publish " + (this.m_bPublishAll ? "full" : "increasing") + " contents in " + this.m_folder.getInfo();
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    public void clear() {
        if (this.m_itContents != null) {
            this.m_itContents.clear();
            this.m_itContents = null;
        }
        if (this.m_contents != null) {
            this.m_contents.clear();
            this.m_contents = null;
        }
        if (this.m_nCurrPos < 0) {
            return;
        }
        this.m_nCurrPos = -1;
    }

    public SinglePageTask getNext() throws WCMException {
        switch (this.m_nLoadBatchContentsModal) {
            case 2: {
                return this.getNextFromIterator();
            }
        }
        return this.getNextFromObjects();
    }

    @Override
    public IPublishElement getPublishElement() {
        return this.m_folder;
    }

    @Override
    public void setPublishElement(IPublishElement _element) {
        this.m_folder = (IPublishFolder)_element;
    }

    private void insureContentsLoadedByObjects() throws Exception {
        if (this.m_nCurrPos >= 0) {
            return;
        }
        DebugTimer timer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            timer.start();
        }
        WCMFilter pageFilter = new WCMFilter();
        pageFilter.setPageSize(this.m_nLoadBatchContentsPageSize);
        this.m_contents = this.m_bPublishAll ? this.m_folder.getAllContents(pageFilter) : (this.m_nPublishType == 13 ? this.m_folder.getPublishedContents(pageFilter) : this.m_folder.getIncreasedContents(pageFilter));
        this.m_nCurrPos = 0;
        if (logger.isDebugEnabled()) {
            timer.stop();
            logger.debug((Object)("load " + this.m_folder.getInfo() + " by objects use [" + timer.getTime() + "]ms."));
        }
    }

    private SinglePageTask getNextFromObjects() throws WCMException {
        try {
            this.insureContentsLoadedByObjects();
            DebugTimer timer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                timer.start();
            }
            if (this.m_contents == null || this.m_nCurrPos >= this.m_contents.size()) {
                return null;
            }
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int size = this.m_contents.size();
            while (content == null && this.m_nCurrPos < size) {
                content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            }
            if (logger.isDebugEnabled()) {
                timer.stop();
                if (timer.getTime() > 30L) {
                    logger.debug((Object)("get next content of " + this.m_folder.getInfo() + " from objects  use [" + timer.getTime() + "]ms."));
                }
            }
            if (content == null) {
                return null;
            }
            content.setFolder(this.m_folder);
            return new SinglePageTask(content);
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the next page task to execute!", ex);
        }
    }

    private void insureContentsLoadedByIterator() throws Exception {
        if (this.m_itContents != null) {
            return;
        }
        DebugTimer timer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            timer.start();
        }
        this.m_itContents = this.m_bPublishAll ? this.m_folder.getAllContentsIterator(null) : (this.m_nPublishType == 13 ? this.m_folder.getPublishedContentsIterator(null) : this.m_folder.getIncreasedContentsIterator(null));
        if (logger.isDebugEnabled()) {
            timer.stop();
            logger.debug((Object)("load " + this.m_folder.getInfo() + " by iterator  use [" + timer.getTime() + "]ms."));
        }
    }

    private SinglePageTask getNextFromIterator() throws WCMException {
        try {
            this.insureContentsLoadedByIterator();
            DebugTimer timer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                timer.start();
            }
            if (this.m_itContents == null || !this.m_itContents.hasNext()) {
                return null;
            }
            IPublishContent content = (IPublishContent)this.m_itContents.next();
            while (content == null && this.m_itContents.hasNext()) {
                content = (IPublishContent)this.m_itContents.next();
            }
            if (logger.isDebugEnabled()) {
                timer.stop();
                if (timer.getTime() > 30L) {
                    logger.debug((Object)("get next content of " + this.m_folder.getInfo() + " from iterator  use [" + timer.getTime() + "]ms."));
                }
            }
            if (content == null) {
                return null;
            }
            if (content.getFolder() == null) {
                if (this.m_folder.isRoot()) {
                    content.setFolder(content.getOriginalHome());
                } else {
                    content.setFolder(this.m_folder);
                }
            }
            return new SinglePageTask(content);
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the next page task to execute!", ex);
        }
    }

    void setPublishType(int _nPublishType) {
        this.m_nPublishType = _nPublishType;
    }
}

