/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class TemplateParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Type[] VALID_TYPES = new Type[]{Type.BOOLEAN, Type.INTEGER, Type.NUMBER, Type.STRING, Type.MULTI};
    private int m_iTemplateId;
    private String m_sTemplateName;
    private String m_sParameterName;
    private Type m_sParameterType;
    private String m_sParameterDefault;
    private String m_sParameterDefaultValue;
    private String m_sParameterDefaultDisplay;
    private List m_oEnumList;
    private Token[] m_sEnumValue;
    private char m_cEnumSplit = (char)96;
    private int m_iCustomFlag;
    private TemplateParameter m_oPreDeclared;

    public TemplateParameter() {
        this.setCanCustomDefault(true);
        this.m_sParameterType = Type.STRING;
    }

    public TemplateParameter getPreDeclared() {
        return this.m_oPreDeclared;
    }

    public void setPreDeclared(TemplateParameter preDeclared) {
        this.m_oPreDeclared = preDeclared;
    }

    public String getParameterName() {
        return this.m_sParameterName;
    }

    public void setParameterName(String parameterName) {
        this.m_sParameterName = parameterName;
    }

    public Type getParameterType() {
        return this.m_sParameterType;
    }

    public void setParameterType(Type parameterType) {
        this.m_sParameterType = parameterType;
    }

    public void setParameterType(String sTypeName) {
        if (sTypeName == null || sTypeName.length() <= 0) {
            this.setParameterType(Type.STRING);
            return;
        }
        sTypeName = sTypeName.toUpperCase();
        for (int i = VALID_TYPES.length - 1; i >= 0; --i) {
            Type type = VALID_TYPES[i];
            if (!sTypeName.equals(type.getName()) && !sTypeName.equals(type.getAlias())) continue;
            this.setParameterType(type);
            return;
        }
        this.setParameterType(Type.STRING);
    }

    public String getParameterDefault() {
        return this.m_sParameterDefault;
    }

    public String getParameterDefaultValue() {
        if (this.m_oPreDeclared != null) {
            return this.m_oPreDeclared.getParameterDefaultValue();
        }
        return this.m_sParameterDefaultValue;
    }

    public String getParameterDefaultDisplay() {
        return this.m_sParameterDefaultDisplay;
    }

    public void setParameterDefault(String parameterDefault) {
        if (parameterDefault != null) {
            int iSplit = parameterDefault.indexOf(this.m_cEnumSplit);
            if (iSplit >= 0) {
                this.m_sParameterDefaultValue = parameterDefault.substring(0, iSplit);
                this.m_sParameterDefaultDisplay = parameterDefault.substring(iSplit + 1);
            } else {
                this.m_sParameterDefaultValue = parameterDefault;
                this.m_sParameterDefaultDisplay = parameterDefault;
            }
        } else {
            this.m_sParameterDefaultValue = null;
            this.m_sParameterDefaultDisplay = null;
        }
        this.m_sParameterDefault = parameterDefault;
    }

    public Token[] getEnumValue() {
        if (this.m_sEnumValue == null && this.m_oEnumList != null && this.m_oEnumList.size() > 0) {
            Token[] tokens = new Token[this.m_oEnumList.size()];
            this.m_oEnumList.toArray(tokens);
            this.m_sEnumValue = tokens;
        }
        return this.m_sEnumValue;
    }

    public void addEnumValue(String value) {
        if (value != null) {
            int iSplit = value.indexOf(this.m_cEnumSplit);
            if (iSplit >= 0) {
                String sVal = value.substring(0, iSplit);
                String sDis = value.substring(iSplit + 1);
                this.addEnumValue(sVal, sDis);
            } else {
                this.addEnumValue(value, value);
            }
            this.m_sEnumValue = null;
        }
    }

    public void addEnumValue(String value, String display) {
        if (value == null) {
            return;
        }
        if (display == null) {
            display = value;
        }
        if (this.m_oEnumList == null) {
            this.m_oEnumList = new LinkedList();
        }
        this.m_oEnumList.add(new Token(value, display));
        this.setCanCustomDefault(false);
    }

    public String getEnumValueDisplay(String sEnumValue) {
        if (sEnumValue == null) {
            return null;
        }
        Token[] tokens = this.getEnumValue();
        if (tokens != null) {
            for (int i = tokens.length - 1; i >= 0; --i) {
                Token token = tokens[i];
                if (token == null || !sEnumValue.equals(token.m_sValue) && (!sEnumValue.equalsIgnoreCase(token.m_sValue) || !Type.BOOLEAN.getName().equals(this.m_sParameterType.getName()))) continue;
                return token.m_sDisplay;
            }
        }
        return sEnumValue;
    }

    public char getEnumSplit() {
        return this.m_cEnumSplit;
    }

    public void setEnumSplit(char enumSplit) {
        this.m_cEnumSplit = enumSplit;
    }

    public boolean getCanCustom() {
        return this.m_iCustomFlag != 0;
    }

    public void setCanCustom(boolean canCustom) {
        this.m_iCustomFlag = canCustom ? (this.m_iCustomFlag |= 2) : 0;
    }

    private final void setCanCustomDefault(boolean canCustom) {
        this.m_iCustomFlag = canCustom ? (this.m_iCustomFlag |= 1) : (this.m_iCustomFlag &= 0xFFFFFFFE);
    }

    public Template getTemplate() throws WCMException {
        return Template.findById(this.getTemplateId());
    }

    public int getTemplateId() {
        return this.m_iTemplateId;
    }

    public void setTemplateId(int templateId) {
        this.m_iTemplateId = templateId;
    }

    public String getTemplateName() {
        return this.m_sTemplateName;
    }

    public void setTemplateName(String templateName) {
        this.m_sTemplateName = templateName;
    }

    public static class Token
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_sValue;
        private String m_sDisplay;

        private Token(String value, String display) {
            this.m_sValue = value;
            this.m_sDisplay = display;
        }

        public String getValue() {
            return this.m_sValue;
        }

        public String getDisplay() {
            return this.m_sDisplay;
        }

        public String toString() {
            return "TemplateParameter.Token." + this.m_sValue;
        }
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Type BOOLEAN = new Type("BOOLEAN", "B");
        public static final Type INTEGER = new Type("INTEGER", "I");
        public static final Type NUMBER = new Type("NUMBER", "N");
        public static final Type STRING = new Type("STRING", "S");
        public static final Type MULTI = new Type("MULTI", "M");
        private String m_sName;
        private String m_sAlias;

        private Type(String name, String alias) {
            this.m_sName = name;
            this.m_sAlias = alias;
        }

        public String getName() {
            return this.m_sName;
        }

        public String getAlias() {
            return this.m_sAlias;
        }

        public String toString() {
            return "TemplateParameter.Type." + this.m_sName;
        }
    }
}

