/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.persistent.template.TagBean;
import com.trs.components.common.publish.persistent.template.TagBeans;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class TagParserFactory
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)TagParserFactory.class.getName());
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private boolean m_bLoaded = false;
    private static TagParserFactory s_instance = new TagParserFactory();

    private TagParserFactory() {
    }

    public synchronized void clear() {
        logger.debug((Object)"to clear tag parser factory ...");
        this.m_bLoaded = false;
    }

    public synchronized void refresh() throws WCMException {
        if (this.m_bLoaded) {
            this.clear();
        }
        logger.debug((Object)"to refresh tag parser factory ...");
        TagBeans beans = null;
        try {
            beans = new TagBeans(User.getSystem());
            beans.open(new WCMFilter("", "ENABLED=1", ""));
            for (int i = 0; i < beans.size(); ++i) {
                TagBean aBean = (TagBean)beans.getAt(i);
                if (aBean == null) continue;
                this.pushTagBeanIntoCache(aBean.getTagName(), aBean.getTagBean());
            }
            this.m_bLoaded = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to refresh the tag parser factory!", (Throwable)ex);
            throw new WCMException(1100, "Failed to refresh the tag parser factory!", ex);
        }
        finally {
            if (beans != null) {
                beans.clear();
            }
        }
    }

    private void pushTagBeanIntoCache(String _sTagName, String _sBeanClassName) throws Exception {
        try {
            cache.set(this.getKey(_sTagName.toUpperCase()), Class.forName(_sBeanClassName));
            logger.debug((Object)("TagBean <" + _sTagName + "> is pushed into cache."));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to push tag bean <" + _sTagName + "> into cache!"), (Throwable)ex);
        }
    }

    private String getKey() {
        return TagParserFactory.class.getName();
    }

    private String getKey(String key) {
        return this.getKey() + "." + key;
    }

    private void removeTagBeanFromCache(TagBean _bean) {
        String sTagName = _bean.getTagName();
        cache.clear(this.getKey(sTagName.toUpperCase()));
        logger.debug((Object)("TagBean <" + sTagName + "> is removed from cache."));
    }

    public Class getTagParserClass(String _sTagName) {
        return (Class)cache.get(this.getKey(_sTagName.toUpperCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TagParserFactory getInstance() throws WCMException {
        if (!TagParserFactory.s_instance.m_bLoaded) {
            TagParserFactory tagParserFactory = s_instance;
            synchronized (tagParserFactory) {
                if (!TagParserFactory.s_instance.m_bLoaded) {
                    s_instance.refresh();
                }
            }
        }
        return s_instance;
    }

    public static boolean isNestedTemplateTag(String _sName) {
        return "TRS_TEMPLATE".equalsIgnoreCase(_sName);
    }

    public static ITagParser createParserByName(String _sTagName) throws WCMException {
        TagParserFactory factory = TagParserFactory.getInstance();
        Class beanClass = factory.getTagParserClass(_sTagName);
        if (beanClass == null) {
            throw new WCMException(11, "Parser not found for tag <" + _sTagName + ">");
        }
        try {
            return (ITagParser)beanClass.newInstance();
        }
        catch (Exception ex) {
            throw new WCMException(11, "Failed to create new instance for parser class " + beanClass.getName(), ex);
        }
    }

    public static void notifyOnTagBeanAdded(TagBean _newBean) throws WCMException {
        try {
            TagParserFactory.getInstance().pushTagBeanIntoCache(_newBean.getTagName(), _newBean.getTagBean());
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed push new tag bean into cache!", ex);
        }
    }

    public static void notifyOnTagBeanDeleted(TagBean _bean) throws WCMException {
        TagParserFactory.getInstance().removeTagBeanFromCache(_bean);
    }

    public static void notifyOnTagBeanModified(TagBean _bean) throws WCMException {
        try {
            TagParserFactory factory = TagParserFactory.getInstance();
            if (_bean.isChangeProperty("TAGNAME")) {
                factory.removeTagBeanFromCache(_bean);
                if (_bean.isChangeProperty("TAGBEAN")) {
                    factory.pushTagBeanIntoCache((String)_bean.getNewProperty("TAGNAME"), (String)_bean.getNewProperty("TAGBEAN"));
                } else {
                    factory.pushTagBeanIntoCache((String)_bean.getNewProperty("TAGNAME"), _bean.getTagBean());
                }
                return;
            }
            if (_bean.isChangeProperty("TAGBEAN")) {
                factory.pushTagBeanIntoCache(_bean.getTagName(), (String)_bean.getNewProperty("TAGBEAN"));
                return;
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to update the cache when tag bean is modified!", ex);
        }
    }
}

