/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.List;
import org.aton.container.IClearable;

public class TagParseResults
implements IClearable {
    private List m_buffers = new ArrayList();

    public int size() {
        return this.m_buffers.size();
    }

    public String get(int _index) {
        if (_index >= this.m_buffers.size()) {
            return null;
        }
        return ((StringBuffer)this.m_buffers.get(_index)).toString();
    }

    public void clear() {
        int nTotal = this.m_buffers.size();
        if (nTotal == 0) {
            return;
        }
        for (int i = 0; i < this.m_buffers.size(); ++i) {
            ((StringBuffer)this.m_buffers.get(i)).setLength(0);
        }
        this.m_buffers.clear();
    }

    public String[] toStrArray() {
        int nTotal = this.m_buffers.size();
        if (nTotal == 0 || nTotal == 1 && ((StringBuffer)this.m_buffers.get(0)).length() == 0) {
            return new String[]{""};
        }
        String[] results = new String[nTotal];
        for (int i = 0; i < nTotal; ++i) {
            StringBuffer buff = (StringBuffer)this.m_buffers.get(i);
            results[i] = buff.toString();
        }
        return results;
    }

    public TagParseResults append(String _sResult) {
        if (_sResult == null || _sResult.length() == 0) {
            return this;
        }
        int nTotal = this.m_buffers.size();
        if (nTotal == 0) {
            StringBuffer buff = new StringBuffer(_sResult);
            this.m_buffers.add(buff);
        } else {
            for (int i = 0; i < nTotal; ++i) {
                StringBuffer buff = (StringBuffer)this.m_buffers.get(i);
                buff.append(_sResult);
            }
        }
        return this;
    }

    public TagParseResults append(String[] _results) throws WCMException {
        if (_results == null) {
            return this;
        }
        int nCurrNum = this.m_buffers.size();
        int nResultNum = _results.length;
        if (nCurrNum == 1 && nResultNum == 1) {
            String sResult = _results[0];
            if (sResult != null) {
                ((StringBuffer)this.m_buffers.get(0)).append(sResult);
            }
            return this;
        }
        if (nCurrNum > 1 && nResultNum > 1) {
            throw new WCMException(232, "Only one pagination tag is allowed in one page!");
        }
        if (nResultNum == 1) {
            this.append(_results[0]);
        } else {
            String sOldResult = null;
            if (nCurrNum > 0) {
                sOldResult = ((StringBuffer)this.m_buffers.get(0)).toString();
            }
            for (int i = 0; i < nResultNum; ++i) {
                StringBuffer buff;
                if (i < nCurrNum) {
                    buff = (StringBuffer)this.m_buffers.get(i);
                } else {
                    buff = new StringBuffer();
                    if (sOldResult != null) {
                        buff.append(sOldResult);
                    }
                    this.m_buffers.add(buff);
                }
                buff.append(_results[i]);
            }
        }
        return this;
    }
}

