/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishContentImplBase;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import org.aton.container.IClearable;

public class PublishPathCompass
implements IClearable {
    private HashMap m_hFolderInfoCache = new HashMap();
    private HashMap m_hRootDomainCache = new HashMap();
    private String m_sPublishLocalRoot = null;
    private String m_sPreviewLocalRoot = null;
    private String m_sPreviewHttpRoot = null;
    private String m_sPublishHttpRoot = null;
    private TemplateEmployMgr m_templateEmployMgr = null;
    private static final int FOLDERINFO_INDEX_FULLDATAPATH = 0;
    private static final int FOLDERINFO_INDEX_DETAILPAGEEXT = 1;
    private static final int FOLDERINFO_INDEX_HTTPDATAPATH = 2;

    public void clear() {
        this.m_hFolderInfoCache.clear();
        this.m_hRootDomainCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findFolderInfo(IPublishFolder _folder) throws WCMException {
        String key = _folder.getPathKey();
        String[] info = (String[])this.m_hFolderInfoCache.get(key);
        if (info == null) {
            HashMap hashMap = this.m_hFolderInfoCache;
            synchronized (hashMap) {
                String sFullDataPath = PublishPathCompass.calFullDataPath(_folder, false);
                String sDetailPageExt = this.findFolderDetailPageExt(_folder);
                String sRootPath = _folder.getRoot().getDataPath();
                sRootPath = CMyString.setStrEndWith(sRootPath, '/');
                info = new String[]{sFullDataPath, sDetailPageExt, sFullDataPath.replaceFirst(sRootPath, "")};
                this.m_hFolderInfoCache.put(key, info);
            }
        }
        return info;
    }

    private String findFolderDetailPageExt(IPublishFolder _folder) throws WCMException {
        Template template;
        String sDetailPageExt = null;
        if (this.m_templateEmployMgr == null) {
            this.m_templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        }
        if ((template = this.m_templateEmployMgr.getDetailTemplate(_folder)) != null) {
            sDetailPageExt = template.getOutputFileExt();
        }
        return sDetailPageExt == null ? "htm" : sDetailPageExt;
    }

    public static String calFullDataPath(IPublishElement _element, boolean _bLocalFileSystemFormat) throws WCMException {
        if (_element.isFolder()) {
            return PublishPathCompass.calFullDataPath((IPublishFolder)_element, _bLocalFileSystemFormat);
        }
        return PublishPathCompass.calFullDataPath((IPublishContent)_element, _bLocalFileSystemFormat);
    }

    public static String calFullDataPath(IPublishFolder _folder, boolean _bLocalFileSystemFormat) throws WCMException {
        String sPath;
        if (PublishServerConfigMapper.isPublishInRootPath()) {
            IPublishFolder root = _folder.getRoot();
            sPath = CMyString.setStrEndWith(root.getDataPath(), '/');
            if (sPath == null) {
                throw new WCMException("[" + root.getInfo() + I18NMessage.get(PublishPathCompass.class, "PublishPathCompass.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u5b58\u653e\u8def\u5f84\uff01"));
            }
            if (!_folder.isRoot()) {
                sPath = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("PublishInRootPathAppendChnlId", "true")) ? sPath + _folder.getDataPath() + "_" + _folder.getId() + "/" : sPath + _folder.getDataPath() + "/";
            }
        } else {
            sPath = CMyString.setStrEndWith(_folder.getDataPath(), '/');
            for (IPublishFolder parent = _folder.getParent(); parent != null; parent = parent.getParent()) {
                sPath = CMyString.setStrEndWith(parent.getDataPath(), '/') + sPath;
            }
        }
        if (_bLocalFileSystemFormat && File.separatorChar != '/') {
            sPath = sPath.replace('/', File.separatorChar);
        }
        return sPath;
    }

    public static String calFullDataPath(IPublishContent _content, boolean _bLocalFileSystemFormat) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        if (home == null) {
            throw new WCMException(1100, "Home folder of content not found!");
        }
        return PublishPathCompass.calFullDataPath(home, _bLocalFileSystemFormat) + PublishPathCompass.calSubDirectory(_content, _bLocalFileSystemFormat);
    }

    public static String calSubDirectory(IPublishContent _content, boolean _bLocalFileSystemFormat) throws WCMException {
        CMyDateTime dtCreated;
        FileNamedStyle oFileNamedStyle = _content.getFileNamedStyle();
        if (oFileNamedStyle.isDirByDate() && PublishServerConfigMapper.isDirDividedByDate() && (dtCreated = _content.getCreatedTime()) != null && !dtCreated.isNull()) {
            return dtCreated.toString(PublishServerConfigMapper.getDirDividedByDateFormat(_bLocalFileSystemFormat)) + (_bLocalFileSystemFormat ? File.separatorChar : (char)'/');
        }
        return "";
    }

    public static String makeDetailPageFileName(IPublishContent _content, String _sExt, int _nPageIndex) {
        String sFileName = "";
        FileNamedStyle aStyle = _content.getFileNamedStyle();
        sFileName = aStyle != null ? PublishPathCompass.getRuledFileNamedString(_content, aStyle) : PublishPathCompass.getOldFileNamedString(_content);
        return PublishPathCompass.makePageFileName(sFileName, _sExt, _nPageIndex);
    }

    public static String makeDetailPageFileName(IPublishContent _content) {
        String sFileName = "";
        FileNamedStyle aStyle = _content.getFileNamedStyle();
        sFileName = aStyle != null ? PublishPathCompass.getRuledFileNamedString(_content, aStyle) : PublishPathCompass.getOldFileNamedString(_content);
        return sFileName;
    }

    private static String getRuledFileNamedString(IPublishContent _content, FileNamedStyle _aStyle) {
        String sPattern = _aStyle.getPattern();
        if (sPattern != null) {
            Object[] args = new Object[]{new Integer(_content.getSubstance().getId()), _content.getCreatedTime().getDateTime(), new Integer(((PublishContentImplBase)_content).getDetailTemplateType())};
            return MessageFormat.format(sPattern, args);
        }
        String result = "";
        try {
            result = result + _aStyle.getPrefix();
            String sToken = _aStyle.getToken() == null ? "" : _aStyle.getToken();
            switch (_aStyle.getAdden()) {
                case 1: {
                    result = result + sToken + _content.getSubstance().getId();
                    break;
                }
                case 2: {
                    result = result + sToken + _content.getCreatedTime().getTimeInMillis();
                    break;
                }
                case 3: {
                    result = result + sToken + _content.getSubstance().getId() + ((PublishContentImplBase)_content).getDetailTemplateType();
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot read correctly with FileNamedStyle @[" + PublishServerConfigMapper.getPublishSrvId() + "]!", ex);
        }
        return result;
    }

    private static String getOldFileNamedString(IPublishContent _content) {
        return "t" + String.valueOf(_content.getId());
    }

    public static String makePageFileName(String _sFileName, String _sExt, int _nPageIndex) {
        if (_nPageIndex <= 0) {
            return _sFileName + '.' + _sExt;
        }
        return _sFileName + '_' + _nPageIndex + '.' + _sExt;
    }

    public String getFullDataPath(IPublishElement _element, boolean _bLocalFileSystemFormat) throws WCMException {
        if (_element.isFolder()) {
            return this.getFullDataPath((IPublishFolder)_element, _bLocalFileSystemFormat);
        }
        return this.getFullDataPath((IPublishContent)_element, _bLocalFileSystemFormat);
    }

    public String getFullDataPath(IPublishFolder _folder, boolean _bLocalFileSystemFormat) throws WCMException {
        return this.getFullDataPath(_folder, _bLocalFileSystemFormat, false);
    }

    private String getFullDataPath(IPublishFolder _folder, boolean _bLocalFileSystemFormat, boolean _bWEBHttpPath) throws WCMException {
        String[] info = this.findFolderInfo(_folder);
        String sPath = info[_bWEBHttpPath ? 2 : 0];
        if (_bLocalFileSystemFormat && File.separatorChar != '/') {
            sPath = sPath.replace('/', File.separatorChar);
        }
        return sPath;
    }

    private String getDomainDataPath(IPublishFolder _folder) throws WCMException {
        StringBuffer dataPath = new StringBuffer();
        if (PublishServerConfigMapper.isPublishInRootPath()) {
            IPublishFolder root = _folder.getRoot();
            String sPath = CMyString.setStrEndWith(root.getDataPath(), '/');
            if (sPath == null) {
                throw new WCMException("[" + root.getInfo() + I18NMessage.get(PublishPathCompass.class, "PublishPathCompass.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u5b58\u653e\u8def\u5f84\uff01"));
            }
            if (!_folder.isRoot()) {
                sPath = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("PublishInRootPathAppendChnlId", "true")) ? sPath + _folder.getDataPath() + "_" + _folder.getId() + "/" : sPath + _folder.getDataPath() + "/";
            }
            return sPath;
        }
        String domain = _folder.getRootDomain();
        while (CMyString.isEmpty(domain)) {
            dataPath.insert(0, CMyString.setStrEndWith(_folder.getDataPath(), '/'));
            _folder = _folder.getParent();
            domain = _folder.getRootDomain();
        }
        return dataPath.toString();
    }

    public String getFullDataPath(IPublishContent _content, boolean _bLocalFileSystemFormat) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        return this.getFullDataPath(home, _bLocalFileSystemFormat) + PublishPathCompass.calSubDirectory(_content, _bLocalFileSystemFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootDomain(IPublishFolder _folder) throws WCMException {
        IPublishFolder root = _folder.getRoot();
        String key = _folder.getPathKey();
        String sDomain = (String)this.m_hRootDomainCache.get(key);
        if (sDomain == null) {
            HashMap hashMap = this.m_hRootDomainCache;
            synchronized (hashMap) {
                sDomain = CMyString.setStrEndWith(root.getRootDomain(), '/');
                this.m_hRootDomainCache.put(key, sDomain);
            }
        }
        return sDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomain(IPublishFolder _folder) throws WCMException {
        String key = _folder.getPathKey();
        String sDomain = (String)this.m_hRootDomainCache.get(key);
        if (sDomain == null) {
            HashMap hashMap = this.m_hRootDomainCache;
            synchronized (hashMap) {
                String useDomain = _folder.getRootDomain();
                while (_folder != null && CMyString.isEmpty(useDomain)) {
                    _folder = _folder.getParent();
                    useDomain = _folder.getRootDomain();
                }
                sDomain = CMyString.setStrEndWith(useDomain, '/');
                this.m_hRootDomainCache.put(key, sDomain);
            }
        }
        return sDomain;
    }

    public String getAbsoluteHttpPath(IPublishElement _element) throws WCMException {
        if (_element.isFolder()) {
            return this.getAbsoluteHttpPath((IPublishFolder)_element);
        }
        return this.getAbsoluteHttpPath((IPublishContent)_element);
    }

    public String getAbsoluteHttpPath(IPublishFolder _folder) throws WCMException {
        block3: {
            boolean nSiteNum = false;
            try {
                if (!nSiteNum && _folder instanceof PublishFolderChannelImpl) {
                    return this.getDomain(_folder) + this.getDomainDataPath(_folder);
                }
            }
            catch (WCMException e) {
                if (e instanceof WCMDatainvalidException && e.getErrNo() == 1100) break block3;
                throw e;
            }
        }
        return this.getRootDomain(_folder) + this.getFullDataPath(_folder, false, true);
    }

    public String getAbsoluteHttpPath(IPublishContent _content) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        return this.getAbsoluteHttpPath(home) + PublishPathCompass.calSubDirectory(_content, false);
    }

    public String getHttpUrl(IPublishContent _content, int _nPageIndex) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        Template detail = null;
        try {
            detail = _content.getDetailTemplate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sExt = "html";
        if (detail != null) {
            sExt = detail.getOutputFileExt();
        } else {
            String[] info = this.findFolderInfo(home);
            sExt = info[1];
        }
        return this.getAbsoluteHttpPath(home) + PublishPathCompass.calSubDirectory(_content, false) + PublishPathCompass.makeDetailPageFileName(_content, sExt, _nPageIndex);
    }

    public String getPreviewHttpUrl(IPublishContent _content, int _nPageIndex) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        String[] info = this.findFolderInfo(home);
        String sExt = info[1];
        return this.getPreviewHttpPath(_content) + PublishPathCompass.makeDetailPageFileName(_content, sExt, _nPageIndex);
    }

    public String getPublishHttpUrl(IPublishContent _content, int _nPageIndex) throws WCMException {
        return this.getPublishHttpPath(_content) + PublishPathCompass.makeDetailPageFileName(_content, _content.getDetailTemplate().getOutputFileExt(), _nPageIndex);
    }

    public String getLocalPath(IPublishElement _element, boolean _bPreview) throws WCMException {
        return _bPreview ? this.getPreviewLocalPath(_element) : this.getPublishLocalPath(_element);
    }

    public String getPublishLocalPath(IPublishElement _element) throws WCMException {
        if (_element.isFolder()) {
            return this.getPublishLocalPath((IPublishFolder)_element);
        }
        return this.getPublishLocalPath((IPublishContent)_element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishLocalPath(IPublishFolder _folder) throws WCMException {
        if (this.m_sPublishLocalRoot == null) {
            PublishPathCompass publishPathCompass = this;
            synchronized (publishPathCompass) {
                String sPath = FilesMan.getFilesMan().getPathConfigValue("LP", 0);
                if (sPath == null) {
                    throw new WCMException(14, "Path config for LP required!");
                }
                this.m_sPublishLocalRoot = CMyString.setStrEndWith(sPath, File.separatorChar);
            }
        }
        return this.m_sPublishLocalRoot + this.getFullDataPath(_folder, true);
    }

    public String getPublishLocalPath(IPublishContent _content) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        return this.getPublishLocalPath(home) + PublishPathCompass.calSubDirectory(_content, true);
    }

    public String getPreviewLocalPath(IPublishElement _element) throws WCMException {
        if (_element.isFolder()) {
            return this.getPreviewLocalPath((IPublishFolder)_element);
        }
        return this.getPreviewLocalPath((IPublishContent)_element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviewLocalPath(IPublishFolder _folder) throws WCMException {
        if (this.m_sPreviewLocalRoot == null) {
            PublishPathCompass publishPathCompass = this;
            synchronized (publishPathCompass) {
                String sPath = FilesMan.getFilesMan().getPathConfigValue("LV", 0);
                if (sPath == null || (sPath = sPath.trim()).length() == 0) {
                    throw new WCMException(14, "Path config for LV required!");
                }
                this.m_sPreviewLocalRoot = CMyString.setStrEndWith(sPath, File.separatorChar);
            }
        }
        return this.m_sPreviewLocalRoot + this.getFullDataPath(_folder, true);
    }

    public String getPreviewLocalPath(IPublishContent _content) throws WCMException {
        IPublishFolder home = _content.getRealHome();
        return this.getPreviewLocalPath(home) + PublishPathCompass.calSubDirectory(_content, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviewHttpPath(IPublishElement _element) throws WCMException {
        if (_element.isFolder()) {
            IPublishFolder _folder = (IPublishFolder)_element;
            if (this.m_sPreviewHttpRoot == null) {
                PublishPathCompass publishPathCompass = this;
                synchronized (publishPathCompass) {
                    String sPath = FilesMan.getFilesMan().getPathConfigValue("LV", 1);
                    if (sPath == null || (sPath = sPath.trim()).length() == 0) {
                        throw new WCMException(14, "Path config for LV required!");
                    }
                    sPath = sPath.replace('\\', '/');
                    this.m_sPreviewHttpRoot = CMyString.setStrEndWith(sPath, '/');
                }
            }
            return this.m_sPreviewHttpRoot + this.getFullDataPath(_folder, false);
        }
        IPublishContent _content = (IPublishContent)_element;
        IPublishFolder home = _content.getRealHome();
        return this.getPreviewHttpPath(home) + PublishPathCompass.calSubDirectory(_content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishHttpPath(IPublishElement _element) throws WCMException {
        if (_element.isFolder()) {
            IPublishFolder _folder = (IPublishFolder)_element;
            if (this.m_sPublishHttpRoot == null) {
                PublishPathCompass publishPathCompass = this;
                synchronized (publishPathCompass) {
                    String sPath = FilesMan.getFilesMan().getPathConfigValue("LP", 1);
                    if (sPath == null || (sPath = sPath.trim()).length() == 0) {
                        throw new WCMException(14, "Path config for LV required!");
                    }
                    sPath = sPath.replace('\\', '/');
                    this.m_sPublishHttpRoot = CMyString.setStrEndWith(sPath, '/');
                }
            }
            return this.m_sPublishHttpRoot + this.getFullDataPath(_folder, false);
        }
        IPublishContent _content = (IPublishContent)_element;
        IPublishFolder home = _content.getRealHome();
        return this.getPublishHttpPath(home) + PublishPathCompass.calSubDirectory(_content, false);
    }

    public String getRootImageHttpPath(IPublishElement _element) throws WCMException {
        String sFullDataPath = this.getFullDataPath(_element, false);
        return HtmlUtil.calParentRelativePath(sFullDataPath) + "images/";
    }

    public String getRootHttpPathFrom(IPublishElement _element) throws WCMException {
        try {
            IPublishFolder root = _element.getFolder().getRoot();
            String sRootDataPath = this.getFullDataPath(root, false);
            String sEleDataPath = this.getFullDataPath(_element, false);
            return HtmlUtil.calRelativePath(sRootDataPath, sEleDataPath);
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to calculate the root http path from " + _element.getInfo(), ex);
        }
    }
}

