/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class PublishDistributionLCListener
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static final Logger logger = Logger.getLogger(PublishDistributionLCListener.class);

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        PublishDistribution distribution;
        if (955 == objAdded.getWCMType() && (distribution = (PublishDistribution)objAdded).isEnabled()) {
            this.redistributeAppendixes(distribution.getFolder());
        }
    }

    private void redistributeAppendixes(final IPublishFolder folder) throws WCMException {
        if (folder == null || !folder.isRoot()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                ContextHelper.initContext(User.getSystem());
                TemplateMgr manager = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
                try {
                    manager.redistributeAppendixes(folder, true);
                }
                catch (WCMException ex) {
                    logger.warn((Object)"redistribute faile", (Throwable)ex);
                }
            }
        }.start();
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        PublishDistribution distribution;
        if (955 == objModified.getWCMType() && ((distribution = (PublishDistribution)objModified).isEnabled() && (distribution.isChangeProperty("TARGETSERVER") || distribution.isChangeProperty("DATAPATH")) || distribution.getNewPropertyAsInt("ENABLED", 0) == 1)) {
            this.redistributeAppendixes(distribution.getFolder());
        }
    }
}

