/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;
import org.apache.log4j.Logger;

public class FileDistributorLocalImpl
implements IFileDistristributor {
    private static final Logger logger = Logger.getLogger((String)FileDistributorLocalImpl.class.getName());
    private String m_sRootDir;
    private static Object s_locker = new Object();

    @Override
    public int getConfigID() {
        return 0;
    }

    @Override
    public void setTargetRoot(PublishDistribution _distribution) throws Exception {
        this.m_sRootDir = CMyString.setStrEndWith(_distribution.getDataPath(), File.separatorChar);
        if (this.m_sRootDir == null) {
            throw new Exception("Root directory of local distribution target [ID=" + _distribution.getId() + "] not set!");
        }
    }

    @Override
    public void distributeFile(String _sLocalFilePathName, String _sPathToSave, boolean _bCheckDstFileExits) throws Exception {
        String sDestPathName = this.calFullPath(_sPathToSave);
        this.insurePathExists(sDestPathName);
        sDestPathName = sDestPathName + CMyFile.extractFileName(_sLocalFilePathName);
        if (_bCheckDstFileExits) {
            if (!CMyFile.fileExists(sDestPathName)) {
                boolean isSuccess = false;
                isSuccess = CMyFile.copyFile(_sLocalFilePathName, sDestPathName);
                if (isSuccess) {
                    SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(_sLocalFilePathName), sDestPathName));
                }
            }
        } else {
            boolean isSuccess = false;
            isSuccess = CMyFile.copyFile(_sLocalFilePathName, sDestPathName);
            if (isSuccess) {
                SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(_sLocalFilePathName), sDestPathName));
            }
        }
    }

    @Override
    public boolean withdrawFile(String _sFileName, String _sPath) {
        String sFilePathName = this.calFullPath(_sPath) + _sFileName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to delete file [" + sFilePathName + "]"));
        }
        boolean isSuccess = false;
        isSuccess = CMyFile.deleteFile(sFilePathName);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", _sFileName, sFilePathName));
        }
        return isSuccess;
    }

    @Override
    public boolean withdrawPath(String _sPath) {
        String sPathName = this.calFullPath(_sPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to delete path [" + sPathName + "]"));
        }
        boolean isSuccess = false;
        isSuccess = CMyFile.deleteDir(sPathName);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6\u8def\u5f84[%s]", sPathName));
        }
        return isSuccess;
    }

    private String calFullPath(String _sSubPath) {
        if (File.separatorChar != '/') {
            _sSubPath = _sSubPath.replace('/', File.separatorChar);
        }
        return this.m_sRootDir + CMyString.setStrEndWith(_sSubPath, File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStore insurePathExists(String _sPath) throws WCMException {
        FileService file = new FileService(_sPath);
        if (!file.exists()) {
            try {
                Object object = s_locker;
                synchronized (object) {
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                }
            }
            catch (Exception ex) {
                throw new WCMException(50, "Failed to create directroy [" + _sPath + "] on disk!", ex);
            }
            if (!file.exists()) {
                throw new WCMException(50, "Failed to create directroy [" + _sPath + "] on disk!");
            }
        }
        return file;
    }

    @Override
    public boolean renameFile(String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws Exception {
        throw new RuntimeException("Not supported method");
    }
}

