/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.FileDistributorFtpCacheMgr;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.ftp.FtpMgr;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import org.apache.log4j.Logger;

public class FileDistributorFtpImpl
implements IFileDistristributor {
    private static final Logger logger = Logger.getLogger((String)FileDistributorFtpImpl.class.getName());
    private String m_sRootDir;
    private FtpMgr m_oFtpMgr = null;
    private FileDistributorFtpCacheMgr m_oFtpCacheMgr = (FileDistributorFtpCacheMgr)DreamFactory.createObjectById("FileDistributorFtpCacheMgr");
    private static Logger s_logger = Logger.getLogger(FileDistributorFtpImpl.class);

    @Override
    public int getConfigID() {
        return 0;
    }

    @Override
    public void setTargetRoot(PublishDistribution _distribution) {
        this.m_oFtpMgr = this.m_oFtpCacheMgr.lookupFtpMgr(_distribution);
        this.m_sRootDir = _distribution.getDataPath();
    }

    @Override
    public void distributeFile(String _sLocalFilePathName, String _sPathToSave, boolean _bCheckDstFileExits) throws Exception {
        this.checkFtpReady();
        String sRemoteFile = this.calFullPath(_sPathToSave) + CMyFile.extractFileName(_sLocalFilePathName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to upload file [" + _sLocalFilePathName + "] to [" + sRemoteFile + "] in ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        if (!_bCheckDstFileExits) {
            boolean isSuccess = false;
            isSuccess = this.m_oFtpMgr.upload(_sLocalFilePathName, sRemoteFile);
            if (isSuccess) {
                SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(_sLocalFilePathName), sRemoteFile));
            }
        }
    }

    @Override
    public boolean withdrawFile(String _sFileName, String _sPath) throws Exception {
        if (!this.checkFtpReady()) {
            return false;
        }
        String sRemoteFile = this.calFullPath(_sPath) + _sFileName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to remove file [" + sRemoteFile + "] from ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        boolean isSuccess = false;
        isSuccess = this.m_oFtpMgr.removeFile(sRemoteFile);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", _sFileName, sRemoteFile));
        }
        return isSuccess;
    }

    @Override
    public boolean withdrawPath(String _sPath) throws Exception {
        if (!this.checkFtpReady()) {
            return false;
        }
        String sRemotePath = this.calFullPath(_sPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to remove path [" + sRemotePath + "] from ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        boolean isSuccess = false;
        isSuccess = this.m_oFtpMgr.removePath(sRemotePath);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6\u8def\u5f84[%s]", sRemotePath));
        }
        return isSuccess;
    }

    private boolean checkFtpReady() throws WCMException {
        if (this.m_oFtpMgr != null) {
            return true;
        }
        s_logger.error((Object)I18NMessage.get(FileDistributorFtpImpl.class, "FileDistributorFtpImpl.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
        throw new WCMException(I18NMessage.get(FileDistributorFtpImpl.class, "FileDistributorFtpImpl.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
    }

    private String calFullPath(String _sSubPath) {
        _sSubPath = _sSubPath.replace('\\', '/');
        return this.m_sRootDir + CMyString.setStrEndWith(_sSubPath, '/');
    }

    @Override
    public boolean renameFile(String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws Exception {
        throw new RuntimeException("Not supported method");
    }
}

