/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.auth;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ICMSObjSubstanceContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;

public class TemplateRightObjImpl
implements IRightObj {
    private Template m_oCurrTemplate = null;

    public TemplateRightObjImpl() {
    }

    public TemplateRightObjImpl(int _nId) throws WCMException {
        this.loadById(_nId);
    }

    public TemplateRightObjImpl(CMSObj _cmsObj) {
        this.makeFrom(_cmsObj);
    }

    @Override
    public boolean hasRight(User _currUser, int _nRightIndex) throws WCMException {
        if (AuthServer.hasSuperRight(_currUser, this.getSubstance())) {
            return true;
        }
        int nRightIndex = _nRightIndex;
        if (nRightIndex == 68) {
            nRightIndex = this.getSubstance().isAddMode() ? 21 : 23;
        }
        boolean bThrowExceptionDirectly = false;
        try {
            IPublishFolder folder = this.m_oCurrTemplate.getFolder();
            if (folder == null) {
                bThrowExceptionDirectly = true;
                throw new WCMException(200006, "The located folder [Type=" + this.m_oCurrTemplate.getFolderType() + ",Id=" + this.m_oCurrTemplate.getFolderId() + "] of this template[" + this.getSubstance() + "] is not found!");
            }
            CMSObj obj = folder.getSubstance();
            return AuthServer.hasRight(_currUser, obj, nRightIndex);
        }
        catch (Exception ex) {
            if (bThrowExceptionDirectly) {
                throw (WCMException)ex;
            }
            throw new WCMException(1100, "Failed to check the user right!", ex);
        }
    }

    public boolean equals(Object _another) {
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof ICMSObjSubstanceContent)) {
            return false;
        }
        ICMSObjSubstanceContent anotherCMS = (ICMSObjSubstanceContent)_another;
        return this.getType() == anotherCMS.getType() && this.getId() == anotherCMS.getId();
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public int getId() {
        if (this.m_oCurrTemplate == null) {
            return 0;
        }
        return this.m_oCurrTemplate.getId();
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oCurrTemplate;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_oCurrTemplate = (Template)_cmsObj;
    }

    @Override
    public String getInfo() {
        if (this.m_oCurrTemplate == null) {
            return null;
        }
        return this.m_oCurrTemplate.toString();
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_oCurrTemplate = Template.findById(_nId);
        return this.m_oCurrTemplate != null;
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) {
        this.m_oCurrTemplate = (Template)_cmsObj;
    }
}

