/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.Messages;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class MsgQueue
extends CMSObj {
    public static final int OBJ_TYPE = 310;
    public static final String DB_TABLE_NAME = "WCMMSGQUEUE";
    public static final String DB_ID_NAME = "QUEUEID";
    public static final int TYPE_NORMAL_MSG = 1;
    public static final int TYPE_FLOW_MSG = 2;
    public static final int TYPE_WARNING = 3;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 310;
    }

    public int getMessageId() {
        return this.getPropertyAsInt("MSGID", 0);
    }

    public Message getMessage(User _currUser) throws WCMException {
        int nMsgId = this.getMessageId();
        if (nMsgId == 0) {
            return null;
        }
        try {
            WCMFilter filter = new WCMFilter("", "MsgId=" + nMsgId, "");
            Messages messages = new Messages(_currUser, 1, 1);
            messages.open(filter);
            return messages.isEmpty() ? null : (Message)messages.getAt(0);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MsgQueue.class, "MsgQueue.label1", "\u53d6\u6d88\u606f\u961f\u5217\u4e2d\u6700\u65b0\u6d88\u606f\u96c6\u5408\u65f6\u51fa\u9519(MsgQueue.getNewMsg)"), ex);
        }
    }

    public boolean setMessage(int _messageId) throws WCMException {
        if (_messageId < 0) {
            throw new WCMException(1104, I18NMessage.get(MsgQueue.class, "MsgQueue.label2", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61ID(MsgQueue.messageId)"));
        }
        return this.setProperty("MSGID", _messageId);
    }

    public boolean setMessage(Message _message) throws WCMException {
        if (_message == null || !_message.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label3", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61(MsgQueue.setMessage)"));
        }
        return this.setMessage(_message.getId());
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _objType) throws WCMException {
        if (_objType != 204 && _objType != 201 && _objType != 203) {
            throw new WCMException(1100, I18NMessage.get(MsgQueue.class, "MsgQueue.label4", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MsgQueue.setObjType\uff09"));
        }
        return this.setProperty("OBJTYPE", _objType);
    }

    public boolean setObj(CMSObj _obj) throws WCMException {
        if (_obj == null || !_obj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label5", "\u65e0\u6548\u5bf9\u8c61\uff08MsgQueue.setObj\uff09"));
        }
        if (!this.setObjType(_obj.getWCMType())) {
            return false;
        }
        return this.setObjId(_obj.getId());
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _objId) throws WCMException {
        if (_objId < 0) {
            throw new WCMException(1104, I18NMessage.get(MsgQueue.class, "MsgQueue.label6", "ObjId\u503c\u65e0\u6548(MsgQueue.setObjId)"));
        }
        return this.setProperty("OBJID", _objId);
    }

    public boolean isReaded() {
        return this.getPropertyAsBoolean("READED", false);
    }

    public boolean setReaded(boolean _bReaded) throws WCMException {
        return this.setProperty("READED", _bReaded);
    }

    public int getMsgType() {
        return this.getPropertyAsInt("MSGTYPE", 1);
    }

    public boolean setMsgType(int _type) throws WCMException {
        if (_type != 1 && _type != 2 && _type != 3) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label7", "MsgType\u503c\u65e0\u6548(Message.setMsgType)"));
        }
        return this.setProperty("MSGTYPE", _type);
    }

    @Override
    public boolean isValid() throws WCMException {
        Number iMsgId = null;
        Number iObjType = null;
        Number iObjId = null;
        if (this.isAddMode()) {
            iMsgId = (Number)this.getAllProperty().get("MSGID");
            iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            iObjId = (Number)this.getAllProperty().get("OBJID");
            if (iMsgId == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label8", "\u5c5e\u6027MessageId\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
            if (iObjType == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
            if (iObjId == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MsgQueue.class, "MsgQueue.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MsgQueue.isValid)"));
            }
            iMsgId = (Number)this.getNewProperty("MSGID");
            iObjType = (Number)this.getNewProperty("OBJTYPE");
            iObjId = (Number)this.getNewProperty("OBJID");
            if (iMsgId == null) {
                iMsgId = (Number)this.getAllProperty().get("MSGID");
            }
            if (iObjType == null) {
                iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            }
            if (iObjId == null) {
                iObjId = (Number)this.getAllProperty().get("OBJID");
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public static final MsgQueue findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MsgQueue)BaseObj.findById(MsgQueue.class, _nId);
    }

    public static final MsgQueue createNewInstance() throws WCMException {
        return (MsgQueue)BaseObj.createNewInstance(MsgQueue.class);
    }

    public static final MsgQueue findByKey(Object _oKey) throws WCMException {
        return (MsgQueue)BaseObj.findByKey(MsgQueue.class, _oKey);
    }
}

