/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.message.Message;
import com.trs.components.common.reminder.Reminder;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.job.JobScheduler;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.calendar.DailyCalendar;

public class JobScheduleServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(JobScheduleServer.class);
    private boolean m_bSlaveNode = true;
    private JobScheduler m_oJobScheduler = (JobScheduler)DreamFactory.createObjectById("JobScheduler");

    @Override
    protected void doShutdown() {
        this.m_oJobScheduler.shutDown();
    }

    @Override
    protected boolean doStart() {
        ClusterConfig config = ClusterConfigHelper.getConfig();
        boolean bl = this.m_bSlaveNode = config.isEnabled() && !config.isMaster();
        if (this.m_bSlaveNode) {
            return true;
        }
        try {
            Schedules allSchedules = new Schedules(User.getSystem());
            WCMFilter filter = new WCMFilter();
            allSchedules.open(filter);
            long now = System.currentTimeMillis();
            int size = allSchedules.size();
            for (int i = 0; i < size; ++i) {
                Schedule schedule = null;
                try {
                    schedule = (Schedule)allSchedules.getAt(i);
                    if (schedule == null) continue;
                    if (schedule.getMode() == 3) {
                        if (schedule.getStatus() >= 7) continue;
                        CMyDateTime dtExec = schedule.getExeTime();
                        if (dtExec == null || dtExec.isNull()) {
                            logger.warn((Object)("Invalid job: " + schedule));
                            continue;
                        }
                        if (dtExec.getTimeInMillis() < now) {
                            logger.info((Object)("Reschedule a one time only job: " + schedule));
                        }
                    }
                    this.scheduleJob(schedule);
                    continue;
                }
                catch (Exception ex) {
                    logger.warn((Object)(schedule + "schedule faild."), (Throwable)ex);
                    this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label2", "\u5c06Job\u52a0\u5165\u961f\u5217\u5931\u8d25!"), ex);
                }
            }
        }
        catch (WCMException ex) {
            this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label1", "\u83b7\u53d6\u7cfb\u7edf\u7684Schedule\u5931\u8d25!"), ex);
        }
        try {
            this.m_oJobScheduler.start();
        }
        catch (WCMException e) {
            this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label3", "\u542f\u52a8Scheduler\u5931\u8d25!"), e);
            return false;
        }
        return true;
    }

    void deleteJob(Schedule _currSchedule) throws WCMException {
        if (this.m_bSlaveNode) {
            return;
        }
        this.m_oJobScheduler.deleteJob(this.getJobName(_currSchedule));
    }

    void scheduleJob(Schedule _currSchedule) throws WCMException {
        if (this.m_bSlaveNode || _currSchedule == null) {
            return;
        }
        AttributesString attr = new AttributesString(_currSchedule.getOperArgs());
        try {
            attr.putAttributeValue("SenderType", String.valueOf(_currSchedule.getSenderType()));
            attr.putAttributeValue("SenderId", String.valueOf(_currSchedule.getSenderId()));
            attr.putAttributeValue("ScheduleId", "" + _currSchedule.getId());
            String userName = _currSchedule.getCrUserName();
            if (!CMyString.isEmpty(userName)) {
                attr.putAttributeValue("CrUser", userName);
            }
        }
        catch (Exception userName) {
            // empty catch block
        }
        if (_currSchedule.getMode() == 3) {
            this.m_oJobScheduler.addJob(this.getJobName(_currSchedule), _currSchedule.getWorkerType().getWorkerClass(), attr.toString(), _currSchedule.getExeTime());
            return;
        }
        JobWorkerType jobWorkerType = _currSchedule.getWorkerType();
        if (jobWorkerType == null) {
            logger.error((Object)(_currSchedule + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label4", "\u6307\u5b9a\u7684WorkerType[") + _currSchedule.getWorkerTypeId() + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label5", "]\u65e0\u6548\uff01")));
            return;
        }
        Trigger trigger = this.getTrigger(_currSchedule);
        this.m_oJobScheduler.addJob(this.getJobName(_currSchedule), jobWorkerType.getWorkerClass(), attr.toString(), trigger);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Schedule To Start AT:" + trigger.getStartTime()));
            logger.debug((Object)("Schedule jod:" + this.getJobName(_currSchedule) + " next fire at:" + trigger.getNextFireTime()));
        }
    }

    private String getJobName(Schedule _schedule) {
        return "SCHEDULE[" + _schedule.getId() + "]" + _schedule.getName();
    }

    private Trigger getTrigger(Schedule _schdedule) throws WCMException {
        if (1 == _schdedule.getMode()) {
            return this.getCronTrigger(_schdedule, this.getTriggerName(_schdedule));
        }
        try {
            return this.getSimpleTrigger2(_schdedule, this.getTriggerName(_schdedule));
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label6", "\u83b7\u53d6\u8ba1\u5212\u4efb\u52a1\u7684\u89e6\u53d1\u5668\u5931\u8d25!"), e);
        }
    }

    private String getTriggerName(Schedule _schdedule) {
        return this.getJobName(_schdedule) + "[Trigger]";
    }

    protected SimpleTrigger getSimpleTrigger2(Schedule _schdedule, String _sName) throws CMyException {
        CMyDateTime dtStart = _schdedule.getStartTime();
        CMyDateTime dtEnd = _schdedule.getEndTime();
        int nStartHour = dtStart.getHour();
        int nStartMinute = dtStart.getMinute();
        int nEndHour = dtEnd.getHour();
        int nEndMinute = dtEnd.getMinute();
        long lInteral = _schdedule.getParam() * 60 * 1000;
        java.util.Calendar start = java.util.Calendar.getInstance();
        start.set(11, nStartHour);
        start.set(12, nStartMinute);
        start.set(13, 0);
        start.set(14, 0);
        java.util.Calendar end = java.util.Calendar.getInstance();
        end.set(11, nEndHour);
        end.set(12, nEndMinute);
        end.set(13, 0);
        end.set(14, 0);
        String dailyCal = _sName + "_dailyCalendar";
        DailyCalendar dailyCalendar = new DailyCalendar(dailyCal, start, end);
        dailyCalendar.setInvertTimeRange(true);
        this.m_oJobScheduler.registerCalendar(dailyCal, (Calendar)dailyCalendar);
        SimpleTrigger trigger = new SimpleTrigger(_sName, "DEFAULT");
        trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        trigger.setRepeatInterval(lInteral);
        trigger.setCalendarName(dailyCal);
        trigger.setStartTime(start.getTime());
        return trigger;
    }

    protected SimpleTrigger getSimpleTrigger(Schedule _schdedule, String sName) throws CMyException {
        CMyDateTime dtStartDate = this.computeStartDate(_schdedule);
        CMyDateTime dtStart = _schdedule.getStartTime();
        CMyDateTime dtEnd = _schdedule.getEndTime();
        int nStartMoth = dtStartDate.getMonth() - 1;
        int nStartDay = dtStartDate.getDay();
        int nStartHour = dtStart.getHour();
        int nStartMinute = dtStart.getMinute();
        int nEndHour = dtEnd.getHour();
        int nEndMinute = dtEnd.getMinute();
        long lInteral = _schdedule.getParam() * 60 * 1000;
        SimpleTrigger trigger = new SimpleTrigger(sName, "DEFAULT");
        java.util.Calendar startTime = java.util.Calendar.getInstance();
        startTime.set(2, nStartMoth);
        startTime.set(5, nStartDay);
        startTime.set(11, nStartHour);
        startTime.set(12, nStartMinute);
        startTime.set(13, 0);
        startTime.set(14, 0);
        java.util.Calendar endTime = java.util.Calendar.getInstance();
        endTime.set(2, nStartMoth);
        endTime.set(5, nStartDay);
        endTime.set(11, nEndHour);
        endTime.set(12, nEndMinute);
        endTime.set(13, 0);
        endTime.set(14, 0);
        trigger.setStartTime(startTime.getTime());
        trigger.setEndTime(endTime.getTime());
        trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        trigger.setRepeatInterval(lInteral);
        return trigger;
    }

    private CMyDateTime computeStartDate(Schedule _schedule) throws CMyException {
        CMyDateTime dtLastExec = _schedule.getLastExeTime();
        CMyDateTime dtNow = CMyDateTime.now();
        if (dtLastExec == null || dtLastExec.isNull()) {
            return dtNow;
        }
        if (dtNow.dateDiff(3, dtLastExec) == 0L && dtNow.getDay() == dtLastExec.getDay()) {
            dtNow.dateAdd(3, 1);
        }
        return dtNow;
    }

    private Trigger getCronTrigger(Schedule _schdedule, String sName) throws WCMException {
        CronTrigger trigger = new CronTrigger(sName, "DEFAULT");
        try {
            int nExecMin = _schdedule.getExeTime().getMinute();
            int nExecHour = _schdedule.getExeTime().getHour();
            String sCron = "0 " + nExecMin + " " + nExecHour + " * * ?";
            trigger.setCronExpression(sCron);
            return trigger;
        }
        catch (Exception e) {
            throw new WCMException(10, I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label7", "\u8ba1\u5212[") + _schdedule.getName() + "][" + _schdedule.getId() + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label8", "]\u8bbe\u5b9a\u7684\u65f6\u95f4\u6709\u8bef\uff01"), e);
        }
    }

    public static Schedule saveSchedule(JobWorkerType _currWorkerType, Schedule _currSchedule, CMSObj _currObj) throws WCMException {
        String sDesc = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label9", "\u4fdd\u5b58") + _currObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label10", "\u4e0a\u6307\u5b9a\u7684\u8ba1\u5212");
        if (_currObj == null || _currSchedule == null) {
            throw new WCMException(sDesc + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label11", "\u6ca1\u6709\u6307\u5b9a\u8ba1\u5212\u6216\u8005\u5bf9\u8c61\uff01"));
        }
        if (_currSchedule.isAddMode()) {
            _currSchedule.setSender(_currObj);
            _currSchedule.setWorkerType(_currWorkerType.getId());
        }
        _currSchedule.save(ContextHelper.getLoginUser());
        return _currSchedule;
    }

    public static Schedule deleteSchedule(JobWorkerType _currWorkerType, CMSObj _currObj) throws WCMException {
        String sDesc = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label12", "\u5220\u9664") + _currObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label10", "\u4e0a\u6307\u5b9a\u7684\u8ba1\u5212");
        if (_currObj == null) {
            throw new WCMException(sDesc + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label13", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5bf9\u8c61\uff01"));
        }
        Schedule aSchedule = Schedule.findBySender(_currWorkerType.getId(), _currObj);
        if (aSchedule == null) {
            throw new WCMException(sDesc + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label14", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u627e\u5230") + _currObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label15", "\u4e0a\u8bbe\u5b9a\u7684\u8ba1\u5212\uff01"));
        }
        aSchedule.delete(ContextHelper.getLoginUser());
        return aSchedule;
    }

    public static Schedule findSchedule(JobWorkerType _currWorkerType, CMSObj _currObj) throws WCMException {
        String sDesc = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label16", "\u83b7\u53d6") + _currObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label17", "\u4e0a\u7684\u8ba1\u5212");
        if (_currObj == null) {
            throw new WCMException(sDesc + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label13", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5bf9\u8c61\uff01"));
        }
        return Schedule.findBySender(_currWorkerType.getId(), _currObj);
    }

    public static void main(String[] args) {
        try {
            JobScheduleServer aServer = new JobScheduleServer();
            aServer.startup();
            Message newMessage = new Message();
            newMessage.setTitle("test");
            newMessage.setBody("dfasfadsf");
            newMessage.setReceivers(204, String.valueOf(User.findByName("admin").getId()));
            newMessage.setValidTime(CMyDateTime.now().dateAdd(3, 1));
            newMessage.save(User.findByName("admin"));
            Reminder.createSchedule(newMessage, CMyDateTime.now());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

