/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.conjection.service;

import com.trs.components.common.conjection.persistent.EntryConfig;
import com.trs.components.common.conjection.persistent.EntryConfigs;
import com.trs.components.common.conjection.service.IComponentEntryConfigService;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class ComponentEntryConfigServiceImpl
implements IComponentEntryConfigService {
    @Override
    public EntryConfig getEntryConfig(int _nEntryId) throws WCMException {
        EntryConfig result = null;
        try {
            result = EntryConfig.findById(_nEntryId);
        }
        catch (Exception ex) {
            throw new WCMException("Failed to get entry config with [ID=" + _nEntryId + "]", ex);
        }
        return result;
    }

    @Override
    public void saveComponentConfigInfo(EntryConfig _oEntry) throws WCMException {
        if (_oEntry == null) {
            throw new WCMException("The entry you wanna save is dimmy!");
        }
        _oEntry.save();
    }

    @Override
    public EntryConfig getTypedEntryConfig(int _nEntryType) throws WCMException {
        EntryConfig result = null;
        try {
            EntryConfigs configs = EntryConfigs.openWCMObjs(null, new WCMFilter(null, "TYPE=" + _nEntryType, null));
            if (configs.size() == 0 || configs.getAt(0) == null) {
                return null;
            }
            result = (EntryConfig)configs.getAt(0);
        }
        catch (Exception ex) {
            throw new WCMException("Failed to get entry config with [Type=" + _nEntryType + "]", ex);
        }
        return result;
    }

    @Override
    public EntryConfigs getAllEntryConfigs() throws WCMException {
        EntryConfigs results = null;
        results = EntryConfigs.openWCMObjs(null, new WCMFilter());
        if (results == null || results.size() == 0) {
            return null;
        }
        return results;
    }
}

