/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.collector;

import com.trs.cms.content.CMSObj;
import com.trs.components.collector.IInformation;
import com.trs.components.collector.InfoProperties;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.util.HashMap;

public class WCMSiteInfo
implements IInformation {
    private static final String FIELDNAME = "SITEINFO";
    private static final String FIELDNAME2 = "SITENUMBER";
    private static final int MAX_SITE_COUNT = Integer.parseInt(InfoProperties.getInstance().getProperity("maxSiteCount"));

    @Override
    public HashMap<String, String> getInfo() {
        HashMap<String, String> infoMap = new HashMap<String, String>(2);
        try {
            WebSites sites = null;
            WCMFilter filter = new WCMFilter("", "", "CRTIME desc", "CRTIME,SITEDESC,SITEID");
            sites = WebSites.openWCMObjs(null, filter);
            int siteN = sites == null ? 0 : sites.size();
            infoMap.put(FIELDNAME2, siteN + "");
            int maxSiteCount = MAX_SITE_COUNT > siteN ? siteN : MAX_SITE_COUNT;
            StringBuffer strBuffer = new StringBuffer();
            String sSQL = "SELECT COUNT(*) FROM wcmchannel";
            int nGroupCount = DBManager.getDBManager().sqlExecuteIntQuery(sSQL);
            for (int i = 0; i < maxSiteCount; ++i) {
                WebSite site = (WebSite)sites.getAt(i);
                String _sSQL = "SELECT COUNT(*) FROM wcmchannel WHERE SITEID=" + site.getId();
                int _nGroupCount = DBManager.getDBManager().sqlExecuteIntQuery(_sSQL);
                WCMFolderPublishConfig siteConfig = this.getPublishConfig(site);
                String key = site.getDesc();
                String value = siteConfig.getRootDomain();
                strBuffer.append(key);
                strBuffer.append(":");
                strBuffer.append(value);
                strBuffer.append("-\u680f\u76ee\u603b\u6570\uff1a");
                strBuffer.append("" + _nGroupCount);
                strBuffer.append(";");
            }
            strBuffer.append("\u7cfb\u7edf\u4e2d\u7684\u680f\u76ee\u603b\u6570\uff1a");
            strBuffer.append("" + nGroupCount);
            infoMap.put(FIELDNAME, strBuffer.toString());
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return infoMap;
    }

    private WCMFolderPublishConfig getPublishConfig(CMSObj obj) throws WCMException {
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(obj);
        WCMFolderPublishConfig folderConfig = new WCMFolderPublishConfig(publishFolder);
        return folderConfig;
    }
}

