/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.handlers;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.RuleExecuteHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.job.BaseStatefulJob;
import org.apache.log4j.Logger;

public class DoingRuleHandler
extends BaseStatefulJob {
    private static Logger logger = Logger.getLogger(DoingRuleHandler.class);
    private IFlowRuleCacheServer m_oRuleCacheServer = null;

    public DoingRuleHandler() {
        try {
            this.m_oRuleCacheServer = (IFlowRuleCacheServer)DreamFactory.createObjectById("IFlowRuleCacheServer");
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(DoingRuleHandler.class, "DoingRuleHandler.label1", "\u521b\u5efa\u89c4\u5219\u7f13\u51b2\u5668\u5931\u8d25\uff01"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws WCMException {
        try {
            ContextHelper.setLoginUser(User.getSystem());
            long lStartTime = 0L;
            long lEndTime = 0L;
            if (logger.isDebugEnabled()) {
                lStartTime = System.currentTimeMillis();
                logger.debug((Object)I18NMessage.get(DoingRuleHandler.class, "DoingRuleHandler.label2", "\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u8fd0\u884c..."));
            }
            String sWhere = "Worked=0 and exists( select XWCMFlowRule.HostId from XWCMFlowRule where XWCMFlowRule.HostType=? and XWCMFlowRule.RuleType=? and WCMFlowDoc.NodeId=XWCMFlowRule.HostId)";
            WCMFilter filter = new WCMFilter("", sWhere, "");
            filter.addSearchValues(403);
            filter.addSearchValues(2);
            FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
            int nSize = flowDocs.size();
            for (int i = 0; i < nSize; ++i) {
                FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
                if (flowDoc == null) continue;
                ExecuteContext executeContext = new ExecuteContext(flowDoc);
                FlowRule[] pRules = this.m_oRuleCacheServer.getRules(403, flowDoc.getNodeId(), 2);
                RuleExecuteHelper.executeRules(executeContext, pRules);
            }
            if (logger.isDebugEnabled()) {
                lEndTime = System.currentTimeMillis();
                logger.debug((Object)(I18NMessage.get(DoingRuleHandler.class, "DoingRuleHandler.label3", "\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u8fd0\u884c\u7ed3\u675f\uff01\u8017\u65f6[") + (lEndTime - lStartTime) + "]ms"));
            }
        }
        finally {
            ContextHelper.clear();
        }
    }
}

