/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.creators;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.engine.AbstractToUsersCreator;
import com.trs.cms.process.engine.FlowContext;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.AttributesString;
import org.apache.log4j.Logger;

public class GroupRoleAsToUsersCreator
extends AbstractToUsersCreator {
    private static Logger logger = Logger.getLogger(GroupRoleAsToUsersCreator.class);

    @Override
    public Users createToUsers(FlowContext flowContext, ToUsersCreatorConfig creatorConfig) throws WCMException {
        String sRoleIds = "";
        String sParams = flowContext.getNextNode().getPropertyAsString("ToUsersCreatorParams");
        if (sParams != null) {
            AttributesString paramters = new AttributesString();
            paramters.setDelim(";");
            paramters.setAttributes(sParams);
            sRoleIds = paramters.getAttributeValue("RoleIds");
        }
        if (sRoleIds == null || (sRoleIds = sRoleIds.trim()).length() == 0) {
            return new Users(null, 1, 1);
        }
        WCMFilter filter = new WCMFilter("", "", "UserName");
        String[] nRoleIds = sRoleIds.split(",");
        StringBuffer sRoleFilter = new StringBuffer(sRoleIds.length() * 2 + 300);
        sRoleFilter.append("ROLEID IN(");
        int nSize = nRoleIds.length;
        for (int i = 0; i < nSize; ++i) {
            int iId = Integer.parseInt(nRoleIds[i]);
            if (iId == 0) continue;
            sRoleFilter.append("?,");
            filter.addSearchValues(iId);
        }
        sRoleFilter.setLength(sRoleFilter.length() - 1);
        sRoleFilter.append(")");
        String sRoleWhere = "USERID IN (SELECT RU.USERID FROM WCMROLEUSER RU WHERE " + sRoleFilter + ")";
        logger.debug((Object)("ROLEWHERE:" + sRoleWhere));
        IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        User postUser = flowContext.getPostUser();
        logger.debug((Object)("postUser:" + postUser));
        Groups groups = departmentMgr.getDeptGroups(postUser);
        logger.debug((Object)("groupsDept:" + groups));
        if (groups == null || groups.isEmpty()) {
            return new Users(null, 1, 1);
        }
        StringBuffer sbGroupWhere = new StringBuffer(20 + groups.size() * 2);
        sbGroupWhere.append("GROUPID in(");
        int nSize2 = groups.size();
        for (int nGroupIndex = 0; nGroupIndex < nSize2; ++nGroupIndex) {
            Group group = (Group)groups.getAt(nGroupIndex);
            if (group == null) continue;
            filter.addSearchValues(group.getId());
            sbGroupWhere.append("?,");
        }
        sbGroupWhere.setLength(sbGroupWhere.length() - 1);
        sbGroupWhere.append(")");
        String sGroupWhere = "USERID in(select GU.USERID from WCMGRPUSER GU where " + sbGroupWhere + ")";
        String sWhere = sRoleWhere + " AND " + sGroupWhere + " AND ISDELETED=0";
        logger.debug((Object)("Where of query users:" + sWhere));
        filter.setWhere(sWhere.toString());
        logger.debug((Object)("sql:" + filter.toSQL()));
        return Users.openWCMObjs(null, filter);
    }
}

