/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.creators;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.engine.AbstractToUsersCreator;
import com.trs.cms.process.engine.FlowContext;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class GroupMembersAsToUsersCreator
extends AbstractToUsersCreator {
    protected static Logger logger = Logger.getLogger(GroupMembersAsToUsersCreator.class);

    @Override
    public Users createToUsers(FlowContext _oFlowContext, ToUsersCreatorConfig _oCreatorConfig) {
        try {
            IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
            User postUser = _oFlowContext.getPostUser();
            logger.debug((Object)("postUser:" + postUser));
            Groups groupsDept = departmentMgr.getDeptGroups(postUser);
            logger.debug((Object)("groupsDept:" + groupsDept));
            if (groupsDept == null || groupsDept.isEmpty()) {
                return null;
            }
            WCMFilter filterQueryUsers = new WCMFilter("", "", "UserName");
            StringBuffer sbGroupWhere = new StringBuffer(20 + groupsDept.size() * 2);
            sbGroupWhere.append("GroupId in(");
            int nSize = groupsDept.size();
            for (int nGroupIndex = 0; nGroupIndex < nSize; ++nGroupIndex) {
                Group group = (Group)groupsDept.getAt(nGroupIndex);
                if (group == null) continue;
                filterQueryUsers.addSearchValues(group.getId());
                sbGroupWhere.append("?,");
            }
            sbGroupWhere.setLength(sbGroupWhere.length() - 1);
            sbGroupWhere.append(")");
            String sWhere = "UserId in(select UserId from WCMGrpUser where " + sbGroupWhere + ") and isdeleted = 0";
            filterQueryUsers.setWhere(sWhere);
            logger.debug((Object)("Where of query dept users:" + sWhere));
            return Users.openWCMObjs(null, filterQueryUsers);
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(GroupMembersAsToUsersCreator.class, "GroupMembersAsToUsersCreator.label1", "\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7684\u90e8\u95e8\u5931\u8d25\uff01"), e);
            return null;
        }
    }

    @Override
    public boolean isRangedFromGroup() {
        return false;
    }

    @Override
    public Group getGroupRange(FlowContext _context, ToUsersCreatorConfig _creatorConfig) throws WCMException {
        return null;
    }
}

