/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FlowContext {
    private boolean m_bFromRule = false;
    private long m_nSerialNum = -1L;
    private long m_nBranchSerialNum = -1L;
    private FlowDoc m_oCurrFlowDoc = null;
    private User m_oPostUser = null;
    private Users m_oToUsers = null;
    private String m_sPostDesc = null;
    private FlowNode m_oNextNode = null;
    private User m_oCurrUser = null;
    private Flow m_oCurrFlow = null;
    private boolean m_bIsStarting = false;
    private IFlowContent m_oFlowContent = null;
    private FlowNodeBranch m_oBranch = null;
    private FlowNode m_oCurrNode = null;
    private String m_sNotifyTypes = null;
    private Map m_hProperties = new HashMap();

    public FlowContext() {
    }

    public FlowContext(User _currUser, IFlowContent _oFlowContent, String _sPostDesc, Users _toUsers, Flow _flow) throws WCMException {
        this.initFlowStartContext(_currUser, _oFlowContent, _sPostDesc, _toUsers, _flow);
    }

    public FlowContext(User _currUser, IFlowContent _oFlowContent) throws WCMException {
        this.initFlowStartContext(_currUser, _oFlowContent, null, null, null);
    }

    private void initFlowStartContext(User _currUser, IFlowContent _oFlowContent, String _sPostDesc, Users _toUsers, Flow _flow) throws WCMException {
        if (_oFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label1", "\u6ca1\u6709\u6307\u5b9a\u5f85\u6d41\u8f6c\u7684\u5185\u5bb9"));
        }
        this.m_oFlowContent = _oFlowContent;
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label2", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237"));
        }
        this.m_oCurrUser = _currUser;
        this.m_oPostUser = _currUser;
        this.m_bIsStarting = true;
        this.m_sPostDesc = _sPostDesc;
        if (_flow == null) {
            this.m_oCurrFlow = _oFlowContent.getOwnerFlow();
            if (this.m_oCurrFlow == null) {
                throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label3", "\u6307\u5b9a\u7684\u5185\u5bb9[") + this.m_oFlowContent.getInfo() + I18NMessage.get(FlowContext.class, "FlowContext.label4", "]\u6ca1\u6709\u5de5\u4f5c\u6d41\u5c5e\u6027"));
            }
        } else {
            this.m_oCurrFlow = _flow;
        }
        this.m_oCurrNode = this.m_oCurrFlow.getStartNode();
        FlowNodeBranchs branchs = this.m_oCurrNode.getBranchs(null);
        if (branchs == null || branchs.isEmpty()) {
            throw new WCMException(I18NMessage.get(FlowContext.class, "FlowContext.label5", "\u5de5\u4f5c\u6d41\u8bbe\u8ba1\u5f97\u6709\u95ee\u9898\uff0c\u5f00\u59cb\u8282\u70b9\u6ca1\u6709\u5206\u652f\uff01"));
        }
        this.m_oNextNode = ((FlowNodeBranch)branchs.getAt(0)).getNextNode(null);
        if (_toUsers != null && !_toUsers.isEmpty()) {
            this.m_oToUsers = _toUsers;
        }
    }

    public FlowDoc getCurrFlowDoc() {
        return this.m_oCurrFlowDoc;
    }

    public void setCurrFlowDoc(FlowDoc currFlowDoc) {
        this.m_oCurrFlowDoc = currFlowDoc;
    }

    public User getPostUser() {
        return this.m_oPostUser;
    }

    public void setPostUser(User postUser) {
        this.m_oPostUser = postUser;
    }

    public Users getToUsers() {
        return this.m_oToUsers;
    }

    public void setToUsers(Users toUsers) {
        this.m_oToUsers = toUsers;
    }

    public String getPostDesc() {
        return this.m_sPostDesc;
    }

    public void setPostDesc(String postDesc) {
        this.m_sPostDesc = postDesc;
    }

    public void validate() throws WCMException {
        if (this.m_oCurrUser == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label6", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u64cd\u4f5c\u7528\u6237"));
        }
        if (this.m_oPostUser == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label7", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u5904\u7406\u4eba"));
        }
        if (this.m_oCurrFlowDoc == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label8", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u5904\u7406\u7684\u8f68\u8ff9"));
        }
    }

    public FlowNode getNextNode() {
        return this.m_oNextNode;
    }

    public void setNextNode(FlowNode nextNode) {
        this.m_oNextNode = nextNode;
    }

    public User getCurrUser() {
        return this.m_oCurrUser;
    }

    public void setCurrUser(User currUser) {
        this.m_oCurrUser = currUser;
    }

    public boolean isStarting() {
        return this.m_bIsStarting;
    }

    public int getWorkModal() {
        if (this.isStarting()) {
            return 0;
        }
        return this.m_oCurrFlowDoc.getWorkModal();
    }

    public IFlowContent getFlowContent() throws WCMException {
        if (this.m_oFlowContent == null) {
            this.m_oFlowContent = this.m_oCurrFlowDoc.getFlowContent();
        }
        return this.m_oFlowContent;
    }

    public void setFlowContent(IFlowContent flowContent) {
        this.m_oFlowContent = flowContent;
    }

    public String getNotifyTypes() throws WCMException {
        if (CMyString.isEmpty(this.m_sNotifyTypes)) {
            FlowNode currNode = this.getCurrNode();
            if (currNode == null) {
                return null;
            }
            if (this.m_oNextNode == null) {
                return null;
            }
            if (this.getBranch() != null) {
                this.m_sNotifyTypes = this.m_oBranch.getNotifyTypes();
            }
        }
        return this.m_sNotifyTypes;
    }

    public FlowNode getCurrNode() throws WCMException {
        if (this.m_oCurrNode == null) {
            this.m_oCurrNode = this.m_oCurrFlowDoc == null ? this.m_oCurrFlow.getStartNode() : this.m_oCurrFlowDoc.getNode();
        }
        return this.m_oCurrNode;
    }

    public void setCurrNode(FlowNode _currNode) {
        this.m_oCurrNode = _currNode;
    }

    public void setNotifyTypes(String notifyTypes) {
        this.m_sNotifyTypes = notifyTypes;
    }

    public FlowNodeBranch getBranch() throws WCMException {
        FlowNode currNode = this.getCurrNode();
        if (currNode == null) {
            return null;
        }
        if (this.m_oBranch == null) {
            this.m_oBranch = currNode.getBranchTo(null, this.m_oNextNode);
        }
        return this.m_oBranch;
    }

    public long getSerialNum() throws WCMException {
        if (this.m_nSerialNum == -1L) {
            if (this.m_oCurrFlowDoc == null) {
                if (this.isStarting()) {
                    this.m_nSerialNum = System.currentTimeMillis();
                } else {
                    String SQL_QUERY_MAX_SERIAL = "select max(SerialNum) from WCMFlowDoc where ObjType=? and ObjId=?";
                    ArrayList<Long> listParameters = new ArrayList<Long>(2);
                    listParameters.add(new Long(this.getFlowContent().getType()));
                    listParameters.add(new Long(this.getFlowContent().getId()));
                    this.m_nSerialNum = DBManager.getDBManager().sqlExecuteQuery("select max(SerialNum) from WCMFlowDoc where ObjType=? and ObjId=?", listParameters, System.currentTimeMillis());
                }
            } else {
                this.m_nSerialNum = this.m_oCurrFlowDoc.getSerialNum();
            }
        }
        return this.m_nSerialNum;
    }

    public void setSerialNum(long serialNum) {
        this.m_nSerialNum = serialNum;
    }

    public long getBranchSerialNum() throws WCMException {
        if (this.m_nBranchSerialNum == -1L) {
            if (this.m_oCurrFlowDoc == null) {
                if (this.isStarting()) {
                    this.m_nBranchSerialNum = System.currentTimeMillis();
                } else {
                    String SQL_QUERY_MAX_SERIAL = "select max(BranchSerialNum) from WCMFlowDoc where ObjType=? and ObjId=?";
                    ArrayList<Long> listParameters = new ArrayList<Long>(2);
                    listParameters.add(new Long(this.getFlowContent().getType()));
                    listParameters.add(new Long(this.getFlowContent().getId()));
                    this.m_nBranchSerialNum = DBManager.getDBManager().sqlExecuteQuery("select max(BranchSerialNum) from WCMFlowDoc where ObjType=? and ObjId=?", listParameters, System.currentTimeMillis());
                }
            } else {
                this.m_nBranchSerialNum = this.m_oCurrFlowDoc.getBranchSerialNum();
            }
        }
        return this.m_nBranchSerialNum;
    }

    public Flow getCurrFlow() {
        return this.m_oCurrFlow;
    }

    public boolean isFromRule() {
        return this.m_bFromRule;
    }

    public void setFromRule(boolean fromRule) {
        this.m_bFromRule = fromRule;
    }

    public void setProperty(String _sName, Object _oValue) {
        this.m_hProperties.put(_sName.toUpperCase(), _oValue);
    }

    public Object getProperty(String _sName) {
        return this.m_hProperties.get(_sName.toUpperCase());
    }
}

