/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.FlowRules;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;

public class FlowRuleCacheServerImpl
extends BaseServer
implements IFlowRuleCacheServer {
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    public FlowRuleCacheServerImpl() {
        this.m_sAppName = I18NMessage.get(FlowRuleCacheServerImpl.class, "FlowRuleCacheServerImpl.label1", "\u5de5\u4f5c\u6d41\u89c4\u5219\u7f13\u5b58\u670d\u52a1\u5668");
    }

    @Override
    protected void doShutdown() {
        if (!cache.exists(this.getKey()).booleanValue()) {
            return;
        }
    }

    @Override
    protected boolean doStart() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        FlowRules rules = FlowRules.openWCMObjs(null, new WCMFilter("", "", "RuleOrder Desc"));
        cache.set(this.getKey(), "true");
        int nSize = rules.size();
        for (int i = 0; i < nSize; ++i) {
            FlowRule rule = (FlowRule)rules.getAt(i);
            if (rule == null) continue;
            rule.getConditions(null);
            rule.getActions(null);
            this.putRuleInCache(rule);
        }
        return true;
    }

    private String getKey() {
        return FlowRuleCacheServerImpl.class.getName();
    }

    private void putRuleInCache(FlowRule _rule) {
        this.putRuleInHostCache(_rule);
    }

    @Override
    public FlowRule[] getRules(FlowNode _currNode, int _nRuleType) {
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.startup();
        }
        if (_currNode == null) {
            return null;
        }
        String sKey = _currNode.getWCMType() + "." + _currNode.getId() + "." + _nRuleType;
        ArrayList arRules = (ArrayList)cache.get(this.getKey(sKey));
        if (arRules == null) {
            return null;
        }
        FlowRule[] pResult = new FlowRule[arRules.size()];
        return arRules.toArray(pResult);
    }

    private String getKey(String sKey) {
        return this.getKey() + "." + sKey;
    }

    private void putRuleInHostCache(FlowRule _rule) {
        String sKey;
        ArrayList<FlowRule> arRules;
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.startup();
        }
        if ((arRules = (ArrayList<FlowRule>)cache.get(this.getKey(sKey = _rule.getHostType() + "." + _rule.getHostId() + "." + _rule.getType()))) == null) {
            arRules = new ArrayList<FlowRule>();
        }
        arRules.add(_rule);
        cache.set(this.getKey(sKey), arRules);
    }

    private void removeRuleCacheOfHost(BaseObj _host) {
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.startup();
        }
        for (int i = 0; i < ProcessConstants.RULE_TRIGGERS.length; ++i) {
            int nRuleType = ProcessConstants.RULE_TRIGGERS[i];
            String sKey = _host.getWCMType() + "." + _host.getId() + "." + nRuleType;
            ArrayList arRules = (ArrayList)cache.get(this.getKey(sKey));
            if (arRules == null) continue;
            cache.clear(this.getKey(sKey));
            int nSize = arRules.size();
            for (int j = 0; j < nSize; ++j) {
                FlowRule rule = (FlowRule)arRules.get(j);
                if (rule == null) continue;
                rule.clearCache();
            }
            arRules.clear();
        }
    }

    @Override
    public void reloadRuleCache(BaseObj _host) throws WCMException {
        this.removeRuleCache(_host);
        WCMFilter filter = new WCMFilter("", "HostType=? and HostId=?", "RuleOrder Desc");
        filter.addSearchValues(403);
        filter.addSearchValues(_host.getId());
        FlowRules rules = FlowRules.openWCMObjs(null, filter);
        int nSize = rules.size();
        for (int i = 0; i < nSize; ++i) {
            FlowRule rule = (FlowRule)rules.getAt(i);
            if (rule == null) continue;
            rule.getConditions(null);
            rule.getActions(null);
            this.putRuleInCache(rule);
        }
    }

    @Override
    public void removeRuleCache(BaseObj _host) {
        this.removeRuleCacheOfHost(_host);
    }

    @Override
    public FlowRule[] getRules(int _nHostType, int _nHostId, int _nRuleType) throws WCMException {
        String sKey;
        ArrayList arRules;
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.startup();
        }
        if ((arRules = (ArrayList)cache.get(this.getKey(sKey = _nHostType + "." + _nHostId + "." + _nRuleType))) == null) {
            return null;
        }
        FlowRule[] pResult = new FlowRule[arRules.size()];
        return arRules.toArray(pResult);
    }
}

