/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.Flows;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.log4j.Logger;

public class FlowEmployMgr {
    private static final Logger logger = Logger.getLogger((String)FlowEmployMgr.class.getName());
    public static final String SQL_QUERY_FLOW_USED = "EXISTS(SELECT employ.FLOWID FROM WCMFLOWEMPLOY employ WHERE employ.EMPLOYERTYPE=? And employ.EMPLOYERID=? AND employ.FLOWID=WCMFLOW.FLOWID)";
    public static final String SQL_QUERY_USEING_FLOW = "EXISTS(SELECT employ.EMPLOYERID FROM WCMFLOWEMPLOY employ WHERE employ.FLOWID=?  AND employ.EMPLOYERTYPE=?  AND employ.EMPLOYERID=";

    public FlowEmploys getEmploysOf(BaseObj _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getEmploysOfEmployer(_employer.getWCMType(), _employer.getId());
    }

    public FlowEmploys getEmploysOfEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("EMPLOYERID=").append(_nEmployerId);
            buff.append(" AND EMPLOYERTYPE=").append(_nEmployerType);
            WCMFilter filter = new WCMFilter("", buff.toString(), "FLOWEMPLOYID desc");
            buff.setLength(0);
            FlowEmploys employs = new FlowEmploys(ContextHelper.getLoginUser());
            employs.open(filter);
            return employs;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query flow employs of the specified employer!", ex);
        }
    }

    public void setFlow(BaseObj _employer, int _nFlowId) throws WCMException {
        this.setFlow(_employer.getWCMType(), _employer.getId(), _nFlowId);
    }

    public void setFlow(int _nEmployType, int _nEmployId, int _nFlowId) throws WCMException {
        User user = ContextHelper.getLoginUser();
        FlowEmploys employs = new FlowEmploys(user, 1, 1);
        try {
            WCMFilter filter = new WCMFilter("", "EMPLOYERID=? AND EMPLOYERTYPE=?", "");
            filter.addSearchValues(_nEmployId);
            filter.addSearchValues(_nEmployType);
            filter.setMaxRowNumber(1);
            employs.open(filter);
            FlowEmploy employ = null;
            if (employs.isEmpty()) {
                employ = new FlowEmploy();
                employ.setEmployer(_nEmployType, _nEmployId);
                employ.setFlow(_nFlowId);
                employ.insert(user);
            } else {
                employ = (FlowEmploy)employs.getAt(0);
                if (employ.getFlowId() == _nFlowId) {
                    return;
                }
                if (employ.canEdit(user)) {
                    employ.setFlow(_nFlowId);
                    employ.update(user);
                }
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to set the employer flow!", ex);
        }
        finally {
            employs.clear();
        }
    }

    public Flows getEmployedFlows(BaseObj _employer) throws WCMException {
        try {
            WCMFilter filter = new WCMFilter("", SQL_QUERY_FLOW_USED, "");
            filter.addSearchValues(_employer.getWCMType());
            filter.addSearchValues(_employer.getId());
            filter.setMaxRowNumber(1);
            Flows flows = new Flows(ContextHelper.getLoginUser());
            flows.open(filter);
            return flows;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the employed flows of the specified employer.", ex);
        }
    }

    public Flow getFlow(BaseObj _employer) throws WCMException {
        return this.getEmployedFlow(_employer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Flow getEmployedFlow(BaseObj _employer) throws WCMException {
        if (_employer == null) {
            return null;
        }
        Flows flows = null;
        try {
            flows = this.getEmployedFlows(_employer);
            Flow flow = flows.isEmpty() ? null : (Flow)flows.getAt(0);
            return flow;
        }
        finally {
            if (flows != null) {
                flows.clear();
            }
        }
    }

    public FlowEmploys getEmployers(Flow _flow, WCMFilter _filter) throws WCMException {
        if (_flow == null) {
            throw new WCMException(10, "Valid flow required!");
        }
        try {
            WCMFilter filter = new WCMFilter("", "FLOWID=" + _flow.getId(), "");
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            return FlowEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the folders who use the specified flow.", ex);
        }
    }

    public int clearEmploysOfEmployer(BaseObj _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid publish element required!");
        }
        return this.clearEmploysOfEmployer(_employer.getWCMType(), _employer.getId());
    }

    public int clearEmploysOfEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        User user = ContextHelper.getLoginUser();
        FlowEmploys employs = new FlowEmploys(user, 1, 1);
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setWhere("EMPLOYERID=? AND EMPLOYERTYPE=?");
        filter.setMaxRowNumber(1);
        filter.addSearchValues(_nEmployerId);
        filter.addSearchValues(_nEmployerType);
        employs.open(filter);
        if (employs.isEmpty()) {
            return 0;
        }
        FlowEmploy employ = (FlowEmploy)employs.getAt(0);
        if (employ != null) {
            return employ.delete(user);
        }
        return 0;
    }

    public int clearEmploysOfFlow(Flow _flow) throws WCMException {
        if (_flow == null) {
            throw new WCMException(10, "Valid flow required!");
        }
        return this.clearEmploysOfFlow(_flow.getId());
    }

    public int clearEmploysOfFlow(int _nFlowId) throws WCMException {
        String SQL = "DELETE FROM WCMFLOWEMPLOY WHERE FLOWID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMFLOWEMPLOY WHERE FLOWID=?");
            oPreStmt.setInt(1, _nFlowId);
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear flow employs records!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public BaseObjs getChannelsUseingFlow(Flow _flow, BaseObjs _baseObjects, int _nEmployerType, String _sTableName, WCMFilter _extraFilter) throws WCMException {
        String sTableName = _sTableName;
        String sIdFieldName = _baseObjects.getIdFieldName();
        StringBuffer sbWhere = new StringBuffer(SQL_QUERY_USEING_FLOW.length() + sTableName.length() + sIdFieldName.length() + 3);
        sbWhere.append(SQL_QUERY_USEING_FLOW + sTableName + "." + sIdFieldName + ")");
        WCMFilter filter = new WCMFilter(null, sbWhere.toString(), null);
        filter.addSearchValues(_flow.getId());
        filter.addSearchValues(_nEmployerType);
        filter.mergeWith(_extraFilter);
        _baseObjects.open(filter);
        return _baseObjects;
    }

    public void setEmployersOfFlow(User _loginUser, int _nFlowId, int _nEmployerType, int[] _pEmployerIds) throws WCMException {
        int i;
        WCMFilter filter = new WCMFilter("", "FlowId=? and EmployerType=?", "");
        filter.addSearchValues(_nFlowId);
        filter.addSearchValues(_nEmployerType);
        FlowEmploys flowEmploys = FlowEmploys.openWCMObjs(_loginUser, filter);
        flowEmploys.setPageSize(flowEmploys.size());
        for (i = flowEmploys.size() - 1; i >= 0; --i) {
            FlowEmploy flowEmploy = (FlowEmploy)flowEmploys.getAt(i);
            if (flowEmploy == null) continue;
            boolean bFound = false;
            for (int j = 0; j < _pEmployerIds.length; ++j) {
                if (flowEmploy.getEmployerId() != _pEmployerIds[j]) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            flowEmploys.remove(flowEmploy);
        }
        for (i = 0; i < _pEmployerIds.length; ++i) {
            this.setFlow(_nEmployerType, _pEmployerIds[i], _nFlowId);
        }
    }
}

