/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.DefaultFlowNotify;
import com.trs.cms.process.IFlowContent;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class InfoViewFlowNotify
extends DefaultFlowNotify {
    private static Logger logger = Logger.getLogger(InfoViewFlowNotify.class);

    public InfoViewFlowNotify(IFlowContent flowContent, int flowDocId) {
        super(flowContent, flowDocId);
    }

    @Override
    public boolean accept() {
        if (this.m_oFlowContent.getContentType() != 605) {
            return false;
        }
        Document doc = (Document)this.m_oFlowContent.getSubstance();
        return doc.getFlag() != 0;
    }

    @Override
    protected synchronized Properties getTemplate() {
        if (this.bLoadedTemplate) {
            return this.properties;
        }
        String sTemplatPath = null;
        sTemplatPath = "/flowservertemplate/infoview/" + ((Document)this.m_oFlowContent.getSubstance()).getFlag() + ".properties";
        this.properties = this.loadTemplate(sTemplatPath);
        if (this.properties == null) {
            this.properties = super.getTemplate();
        }
        this.bLoadedTemplate = true;
        return this.properties;
    }

    @Override
    protected synchronized Map getProperties() throws WCMException {
        super.getProperties();
        this.propertiesMap.putAll(InfoViewData.findByDocument((Document)this.m_oFlowContent.getSubstance()).getAllProperty());
        return this.propertiesMap;
    }

    @Override
    protected String getDoWithUrl() {
        try {
            String sAppDomain = ConfigServer.getServer().getSysConfigValue("WCM_URL", "htttp://localhost/wcm/");
            sAppDomain = CMyString.setStrEndWith(sAppDomain, '/');
            String doWithUrl = sAppDomain + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "app") + "/infoview/" + this.m_oFlowContent.getContentAddEditPage() + "&FlowDocId=" + this.m_nFlowDocId + "&WorklistViewType=1";
            return doWithUrl;
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(InfoViewFlowNotify.class, "InfoViewFlowNotify.label1", "\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
            return null;
        }
    }
}

