/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RoleUserCacheMgr
implements ICacheMgr {
    public static long LRU_CACHE_EXPIRES = 3600000L;
    public static int MAX_CACHE_SIZE = 5000;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");

    public RoleUserCacheMgr() {
        cache.setMaxSize(MAX_CACHE_SIZE);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (this.isListening(_oObjAdded)) {
            RoleUser roleUser = (RoleUser)_oObjAdded;
            this.addToCache(roleUser.getUserId(), roleUser.getRoleId(), roleUser.getSiteId());
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (this.isListening(_oObjDeleted)) {
            RoleUser roleUser = (RoleUser)_oObjDeleted;
            this.removeFromCache(roleUser.getUserId(), roleUser.getRoleId(), roleUser.getSiteId());
        }
    }

    @Override
    public boolean init() throws WCMException {
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
    }

    final Roles getRoles(User _currUser) throws WCMException {
        return this.getRoles(_currUser.getId());
    }

    public final Roles getRoles(User _currUser, WebSite _currSite) throws WCMException {
        int nUserId = _currUser.getId();
        Roles roles = Roles.createNewInstance(null);
        roles.addElements(this.initCache(nUserId, -1));
        if (_currSite != null) {
            int nSiteId = _currSite.getId();
            roles.addElements(this.initCache(nUserId, nSiteId));
            roles.addElements(this.initCache(nUserId, 0));
        }
        roles.addElement(Role.findById(2));
        return roles;
    }

    private void addToCache(int _nUserId, int _nRoleId, int _nSiteId) throws WCMException {
        Roles roles = this.initCache(_nUserId, _nSiteId);
        if (roles.indexOf(_nRoleId) == -1) {
            String sKey = this.makeKey(_nUserId, _nSiteId);
            cache.rpush(this.getKey(sKey), _nRoleId);
        }
    }

    private void removeFromCache(int _nUserId, int _nRoleId, int _nSiteId) throws WCMException {
        this.initCache(_nUserId, _nSiteId);
        String sKey = this.makeKey(_nUserId, _nSiteId);
        cache.lrem(this.getKey(sKey), 0L, new Integer(_nRoleId));
    }

    private Roles getRoles(int _nUserId) throws WCMException {
        Roles roles;
        String specialKey = this.makeKey(_nUserId, -1);
        List<Object> specialIds = cache.lrange(this.getKey(specialKey), 0L, -1L);
        Roles roles_ = this.ids2BaseObjs(specialIds);
        String allKey = this.makeKey(_nUserId, 0);
        List<Object> allIds = cache.lrange(this.getKey(allKey), 0L, -1L);
        Roles _roles = this.ids2BaseObjs(allIds);
        Roles roles2 = roles_ != null && _roles != null ? Roles.createNewInstance(null) : (roles_ != null ? roles_ : (roles = _roles != null ? _roles : null));
        if (roles == null || roles.size() == 0) {
            roles = this.initCache(_nUserId);
        }
        if (roles.size() == 0) {
            roles.addElements(_roles);
            roles.addElements(roles_);
        }
        return roles;
    }

    private Roles ids2BaseObjs(List<Object> ids) throws WCMException {
        if (ids == null) {
            return null;
        }
        String idStr = StringUtils.join(ids, (String)",");
        return Roles.findByIds(null, idStr);
    }

    private synchronized Roles initCache(int _nUserId) throws WCMException {
        Roles specialRoles = this.initCache(_nUserId, -1);
        Roles allSiteRoles = this.initCache(_nUserId, 0);
        Roles roles = Roles.createNewInstance(null);
        roles.addElements(specialRoles);
        roles.addElements(allSiteRoles);
        return roles;
    }

    private synchronized Roles initCache(int _nUserId, int _nSiteId) throws WCMException {
        String sKey = this.makeKey(_nUserId, _nSiteId);
        cache.set(this.getKey(), "true");
        Roles roles = Roles.createNewInstance(null);
        List<Object> roleIds = cache.lrange(this.getKey(sKey), 0L, -1L);
        if (roleIds != null && roleIds.size() > 0) {
            String roleIdStr = StringUtils.join(roleIds, (String)",");
            return Roles.findByIds(null, roleIdStr);
        }
        String sWhere = "exists(select 1 from WCMRoleUser where UserId=? and SiteId=? and WCMRoleUser.RoleId=WCMRole.RoleId)";
        WCMFilter aFilter = new WCMFilter("WCMROLE", sWhere, "RoleId");
        aFilter.addSearchValues(_nUserId);
        aFilter.addSearchValues(_nSiteId);
        roles = Roles.openWCMObjs(User.getSystem(), aFilter);
        if (roles != null) {
            int size = roles.size();
            for (int i = 0; i < size; ++i) {
                Integer id = ((Role)roles.getAt(i)).getId();
                cache.rpush(this.getKey(sKey), id);
            }
        }
        cache.pexpire(this.getKey(sKey), LRU_CACHE_EXPIRES);
        return roles;
    }

    private String makeKey(int _nUserId, int _nSiteId) {
        return _nUserId + "_" + _nSiteId;
    }

    private boolean isListening(BaseObj _obejct) {
        return _obejct != null && _obejct instanceof RoleUser;
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(String sRolerUser) {
        return this.getKey() + "." + sRolerUser;
    }

    private String getKey(Integer sRolerUser) {
        return this.getKey() + "." + sRolerUser;
    }
}

