/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;

public class GroupAuthServer {
    public static boolean hasRight(User _loginUser, Group group, int _nRightIndex) throws WCMException {
        if (_loginUser == null) {
            return false;
        }
        boolean isAdmin = _loginUser.isSecurityAdmin();
        boolean isGroupAdmin = group.isAdministrator(_loginUser);
        boolean isSuperGroupAdmin = false;
        for (Group tmpGroup = group.getParent(); tmpGroup != null; tmpGroup = tmpGroup.getParent()) {
            if (!tmpGroup.isAdministrator(_loginUser)) continue;
            isSuperGroupAdmin = true;
            break;
        }
        int nRightIndex = _nRightIndex;
        boolean bCanEdit = isAdmin || isSuperGroupAdmin || isGroupAdmin;
        boolean bCanDelete = isAdmin || isSuperGroupAdmin || isGroupAdmin;
        boolean bCanManageUser = isAdmin || isSuperGroupAdmin || isGroupAdmin;
        switch (nRightIndex) {
            case 11: {
                if (!bCanEdit) break;
                return true;
            }
            case 12: {
                if (!bCanDelete) break;
                return true;
            }
            case 13: 
            case 14: {
                if (!bCanManageUser) break;
                return true;
            }
        }
        return isAdmin || isSuperGroupAdmin || isGroupAdmin;
    }
}

