/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm.servlet;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cluster.ext.wcm.ClusterWatchDog;
import com.trs.infra.support.config.ConfigServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AutoRestartServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(AutoRestartServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TRSWCMClusterServer server = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        if (server == null || server.getContext() == null || !server.getContext().getConfig().isEnabled()) {
            resp.setStatus(401);
            return;
        }
        String reqIP = req.getRemoteAddr();
        LOG.info((Object)("A cluster restart request come in. From: " + reqIP));
        ServletInputStream ins = req.getInputStream();
        int BUFF_LEN = 128;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        byte[] buff = new byte[128];
        int len = -1;
        while ((len = ins.read(buff)) != -1) {
            baos.write(buff, 0, len);
        }
        ins.close();
        String msg = baos.toString();
        if (this.unauthorized(msg, reqIP)) {
            resp.setStatus(401);
        } else {
            new Thread(){

                @Override
                public void run() {
                    ClusterWatchDog dog = new ClusterWatchDog();
                    dog.barkOnRestart();
                }
            }.start();
        }
    }

    private boolean unauthorized(String msg, String reqIP) {
        if (msg.indexOf(reqIP) == -1) {
            return true;
        }
        ConfigServer confServer = ConfigServer.getServer();
        String nodeips = null;
        try {
            nodeips = confServer.getSysConfigValue("cluster.nodeips", "");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to get conf: nodeips", (Throwable)ex);
        }
        if (nodeips == null || nodeips.trim().length() == 0) {
            return true;
        }
        return nodeips.indexOf(reqIP) == -1;
    }
}

