/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.Configs;
import com.trs.infra.util.CMyString;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterConfigHelper {
    private static Logger logger = Logger.getLogger(ClusterConfigHelper.class);
    private static ClusterConfig CONF = null;
    private static final byte[] INIT_LOCK = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ClusterConfig getConfig() {
        if (CONF != null) return CONF;
        byte[] byArray = INIT_LOCK;
        synchronized (INIT_LOCK) {
            if (CONF != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return CONF;
            }
            URL url = ClusterConfigHelper.class.getResource("/trswcmcluster.properties");
            ClusterConfig config = new ClusterConfig();
            config.load(url);
            if (!config.isEnabled()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return config;
            }
            Configs configs = new Configs();
            WCMFilter filter = new WCMFilter("", "", "", "CKEY,CVALUE");
            filter.setWhere("CTYPE=13");
            try {
                configs.open(filter);
            }
            catch (WCMException ex) {
                config.setEnabled(false);
                logger.fatal((Object)"Load cluster config failed.", (Throwable)ex);
                // ** MonitorExit[var0] (shouldn't be in output)
                return config;
            }
            Properties props = new Properties();
            int size = configs.size();
            for (int i = 0; i < size; ++i) {
                Config conf = (Config)configs.getAt(i);
                if (conf == null || CMyString.isEmpty(conf.getValue())) continue;
                props.put(conf.getConfigKey(), conf.getValue());
            }
            config.load(props);
            config.setMaster(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)props);
            }
            props.clear();
            CONF = config;
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONF;
        }
    }
}

