/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class TemplateEmployerToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(TemplateEmployerToXML.class);
    private static final int EMPLOYER_ID = 1;

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) {
        return null;
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        TemplateEmploy employ = (TemplateEmploy)_currObj;
        try {
            IPublishElement employer = employ.getEmployer();
            switch (_nPropertyId) {
                case 1: {
                    if (employer != null) {
                        return new String[][]{{"Name", employer.getInfo()}, {"Id", String.valueOf(employer.getId())}, {"Type", String.valueOf(employer.getType())}, {"Path", this.getAdaptedPath(employer)}};
                    }
                    return new String[][]{{"Name", I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label1", "\u672a\u77e5\u5bf9\u8c61")}, {"Id", String.valueOf(employ.getEmployerId())}, {"Type", String.valueOf(employ.getEmployerType())}};
                }
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label2", "\u8f6c\u6362\u5c5e\u6027[") + _nPropertyId + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label3", "]\u5931\u8d25\uff01"), e);
        }
        return null;
    }

    private String getAdaptedPath(IPublishElement employer) {
        String result = employer.getInfo();
        try {
            CMSObj obj = employer.getSubstance();
            if (obj != null && obj instanceof Channel) {
                Channel chnl = (Channel)obj;
                StringBuffer sbChannelNav = new StringBuffer(chnl.getDesc() + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label4", "[\u680f\u76ee-") + chnl.getId() + "]");
                for (Channel parent = chnl.getParent(); parent != null && parent != null; parent = parent.getParent()) {
                    sbChannelNav.insert(0, " > ");
                    sbChannelNav.insert(0, parent.getDesc() + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label4", "[\u680f\u76ee-") + parent.getId() + "]");
                }
                result = sbChannelNav.toString();
                sbChannelNav.setLength(0);
            }
        }
        catch (WCMException ex) {
            logger.warn((Object)"failed to get the path of channel!", (Throwable)ex);
        }
        return result;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("EmployerId", 1, "EMPLOYER");
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{TemplateEmploys.class.getName(), TemplateEmploy.class.getName()};
    }
}

