/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.jsonconvertors;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.TableInfo;
import com.trs.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONToCMSObj {
    private static Logger logger = Logger.getLogger(JSONToCMSObj.class);
    private User m_oCurrUser = null;
    private StringBuffer m_sbObjectIds = new StringBuffer("0");
    private CMSObj[] m_pCMSObjs = null;
    private List<CMSObj> m_lCMSObjs;
    private CMSObj m_oSrcInstance = null;

    private JSONToCMSObj(User _currUser, CMSObj _oSrcInstance) throws WCMException {
        this.m_oCurrUser = _currUser;
        this.m_oSrcInstance = _oSrcInstance;
        this.m_lCMSObjs = new ArrayList<CMSObj>();
    }

    public static CMSObj[] makeCMSOjbs(String _JSONText, CMSObj _Instanse) throws WCMException {
        JSONToCMSObj jsonToCMSObj = new JSONToCMSObj(ContextHelper.getLoginUser(), _Instanse);
        jsonToCMSObj.parse(_JSONText);
        CMSObj[] cmsObjs = jsonToCMSObj.getCMSObjs();
        return cmsObjs;
    }

    public static List<CMSObj> makeCMSOjbsList(String _JSONText, CMSObj _Instanse) throws WCMException {
        JSONToCMSObj jsonToCMSObj = new JSONToCMSObj(ContextHelper.getLoginUser(), _Instanse);
        jsonToCMSObj.parse(_JSONText);
        List<CMSObj> cmsObjList = jsonToCMSObj.getLCMSOjbs();
        return cmsObjList;
    }

    private void parse(String _sJSONText) throws WCMException {
        this.clear();
        if (CMyString.isEmpty((String)_sJSONText)) {
            return;
        }
        try {
            switch (JSONToCMSObj.getJSONType(_sJSONText)) {
                case JSON_TYPE_ARRAY: {
                    this.parseArray(new JSONArray(_sJSONText));
                    break;
                }
                case JSON_TYPE_OBJECT: {
                    this.parseObject(new JSONObject(_sJSONText));
                    break;
                }
                case JSON_TYPE_ERROR: {
                    break;
                }
            }
        }
        catch (WCMException e) {
            logger.error((Object)("\u5904\u7406JSON\u5931\u8d25\uff01" + _sJSONText));
            throw e;
        }
    }

    private void parseArray(JSONArray _ObjArray) throws WCMException {
        TableInfo currTableInfo = DBManager.getDBManager().getTableInfo(this.m_oSrcInstance.getDbTableName());
        this.m_pCMSObjs = new CMSObj[_ObjArray.length()];
        this.m_sbObjectIds = new StringBuffer(5 * (_ObjArray.length() + 1));
        this.m_sbObjectIds.append("0");
        for (int i = 0; i < _ObjArray.length(); ++i) {
            JSONObject jObject = _ObjArray.getJSONObject(i);
            if (jObject == null) continue;
            try {
                CMSObj cmsObj;
                this.m_pCMSObjs[i] = cmsObj = this.toCMSObj(jObject, currTableInfo);
                this.m_lCMSObjs.add(cmsObj);
                continue;
            }
            catch (WCMException e) {
                throw new WCMException(I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label3", "\u5904\u7406\u7b2c[") + (i + 1) + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label4", "]\u4e2a\u8282\u70b9\u53d1\u751f\u5f02\u5e38\uff01"), e);
            }
        }
    }

    private void parseObject(JSONObject _obj) throws WCMException {
        TableInfo currTableInfo = DBManager.getDBManager().getTableInfo(this.m_oSrcInstance.getDbTableName());
        this.m_pCMSObjs = new CMSObj[1];
        this.m_sbObjectIds = new StringBuffer(10);
        this.m_sbObjectIds.append("0");
        if (_obj == null) {
            return;
        }
        try {
            CMSObj cmsObj;
            this.m_pCMSObjs[0] = cmsObj = this.toCMSObj(_obj, currTableInfo);
            this.m_lCMSObjs.add(cmsObj);
        }
        catch (WCMException e) {
            throw new WCMException(I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label3", "\u5904\u7406\u7b2c[") + 1 + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label4", "]\u4e2a\u8282\u70b9\u53d1\u751f\u5f02\u5e38\uff01"), e);
        }
    }

    private boolean isIgnoreProperty(String paramName) {
        return (paramName = paramName.toUpperCase()).equals("ID");
    }

    private void clear() {
        this.m_sbObjectIds = new StringBuffer("0");
        this.m_pCMSObjs = null;
    }

    private void cancelUpdate() {
        if (this.m_pCMSObjs == null) {
            return;
        }
        for (int i = 0; i < this.m_pCMSObjs.length; ++i) {
            if (this.m_pCMSObjs[i] == null) continue;
            this.m_pCMSObjs[i].cancelUpdate(this.m_oCurrUser);
        }
    }

    private CMSObj toCMSObj(JSONObject _jsonObject, TableInfo currTableInfo) throws WCMException {
        CMSObj currObject = null;
        try {
            currObject = (CMSObj)this.m_oSrcInstance.getClass().newInstance();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label6", "\u5bf9\u8c61\u521d\u59cb\u5316\u5931\u8d25\uff01"), e);
        }
        String sIdPropertyName = null;
        String[] lPropertyNames = JSONObject.getNames((JSONObject)_jsonObject);
        int nPropertySize = lPropertyNames.length;
        for (int j = 0; j < nPropertySize; ++j) {
            String sTemp = lPropertyNames[j];
            if (sTemp.equalsIgnoreCase("ID")) {
                sIdPropertyName = sTemp;
                break;
            }
            if (!sTemp.equalsIgnoreCase(currObject.getIdFieldName())) continue;
            sIdPropertyName = sTemp;
            break;
        }
        int nId = 0;
        try {
            String sId;
            if (!CMyString.isEmpty(sIdPropertyName) && !CMyString.isEmpty((String)(sId = String.valueOf(_jsonObject.get(sIdPropertyName))))) {
                nId = Integer.parseInt(sId);
            }
        }
        catch (NumberFormatException e) {
            throw new WCMException("ID[" + nId + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label5", "]\u4e0d\u662f\u6574\u578b\u6570\uff01"), e);
        }
        catch (JSONException ex) {
            logger.info((Object)"\u5c5e\u6027ID\u4e0d\u5b58\u5728\uff01");
        }
        if (nId > 0) {
            currObject = (CMSObj)BaseObj.findById(this.m_oSrcInstance.getClass(), nId);
            if (currObject == null) {
                throw new WCMException("\u6307\u5b9a\u3010Id=" + nId + "\u3011\u65e0\u6548\uff0cInstance=" + this.m_oSrcInstance.getClassName(true));
            }
            currObject.validCanEditAndLock(this.m_oCurrUser);
            this.m_sbObjectIds.append(",");
            this.m_sbObjectIds.append(nId);
        }
        for (String sPropertyName : lPropertyNames) {
            if (CMyString.isEmpty((String)sPropertyName) || this.isIgnoreProperty(sPropertyName)) continue;
            if (currTableInfo.getFieldInfo(sPropertyName) == null) {
                logger.warn((Object)(I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label7", "\u66f4\u65b0\u5bf9\u8c61[") + this.m_oSrcInstance + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label8", "]\u65f6\u5019\uff0c\u7531\u4e8e\u5b57\u6bb5[") + sPropertyName + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label9", "]\u5728\u8868[") + this.m_oSrcInstance.getDbTableName() + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label10", "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6570\u636e\uff01")));
                continue;
            }
            try {
                Object objValue = _jsonObject.get(sPropertyName);
                if (objValue instanceof JSONArray) {
                    objValue = objValue.toString();
                }
                currObject.setProperty(sPropertyName, objValue, false);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label11", "\u5904\u7406\u5c5e\u6027[Name=") + sPropertyName + I18NMessage.get(JSONToCMSObj.class, "JSONToCMSObj.label12", "]\u53d1\u751f\u5f02\u5e38\uff01[Value=") + _jsonObject.getString(sPropertyName) + "]", e);
            }
        }
        return currObject;
    }

    private static JSON_TYPE getJSONType(String str) {
        if (CMyString.isEmpty((String)str)) {
            return JSON_TYPE.JSON_TYPE_ERROR;
        }
        char[] strChar = str.substring(0, 1).toCharArray();
        char firstChar = strChar[0];
        if (firstChar == '{') {
            return JSON_TYPE.JSON_TYPE_OBJECT;
        }
        if (firstChar == '[') {
            return JSON_TYPE.JSON_TYPE_ARRAY;
        }
        return JSON_TYPE.JSON_TYPE_ERROR;
    }

    private CMSObj[] getCMSObjs() {
        return this.m_pCMSObjs;
    }

    private List<CMSObj> getLCMSOjbs() {
        return this.m_lCMSObjs;
    }

    private String getObjectIds() {
        return this.m_sbObjectIds.toString();
    }

    private static enum JSON_TYPE {
        JSON_TYPE_OBJECT,
        JSON_TYPE_ARRAY,
        JSON_TYPE_ERROR;

    }
}

