/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class ReplaceContentServiceProvider
implements IGlueServiceProvider {
    private ReplaceMgr m_oReplaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Replaces replaces = Replaces.findByIds(loginUser, _methodContext.getObjectIds());
        this.validateRight(loginUser, replaces, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label1", "\u5220\u9664"), 13);
        int nSize = replaces.size();
        for (int i = 0; i < nSize; ++i) {
            Replace replace = (Replace)replaces.getAt(i);
            if (replace == null) continue;
            this.m_oReplaceMgr.delete(replace);
        }
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel channel = this.findChannelById(nChannelId);
        this.validateRight(loginUser, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label2", "\u8fdb\u5165\u66ff\u6362\u5185\u5bb9\u5217\u8868"), 13);
        WCMFilter filter = _methodContext.getExtraWCMFilter();
        return this.m_oReplaceMgr.getReplaces(channel, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        int nChannelId;
        User loginUser = this.getLoginUser();
        Replace replace = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId > 0) {
            replace = this.findReplaceById(nObjectId);
            nChannelId = replace.getChnlId();
        } else {
            replace = new Replace();
            nChannelId = _methodContext.getValue("ChannelId", 0);
            replace.setChnlId(nChannelId);
        }
        Channel channel = this.findChannelById(nChannelId);
        this.validateRight(loginUser, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label3", "\u8bbe\u7f6e\u66ff\u6362\u5185\u5bb9"), 13);
        try {
            if (nObjectId > 0) {
                replace.validCanEditAndLock(loginUser);
            }
            String[] pLogicFields = new String[]{"ChannelId", "ObjectId"};
            WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, replace, pLogicFields);
            this.m_oReplaceMgr.save(replace);
            int n = replace.getId();
            return n;
        }
        finally {
            if (nObjectId > 0) {
                replace.cancelUpdate(loginUser);
            }
        }
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        int nChannelId;
        User loginUser = this.getLoginUser();
        Replace replace = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId > 0) {
            replace = this.findReplaceById(nObjectId);
            nChannelId = replace.getChnlId();
        } else {
            replace = new Replace();
            nChannelId = _methodContext.getValue("ChannelId", 0);
            replace.setChnlId(nChannelId);
        }
        Channel channel = this.findChannelById(nChannelId);
        this.validateRight(loginUser, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label4", "\u83b7\u53d6\u6307\u5b9a\u7684\u66ff\u6362\u5185\u5bb9\u4fe1\u606f"), 13);
        return replace;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Replaces replaces = Replaces.findByIds(loginUser, _methodContext.getObjectIds());
        this.validateRight(loginUser, replaces, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label4", "\u83b7\u53d6\u6307\u5b9a\u7684\u66ff\u6362\u5185\u5bb9\u4fe1\u606f"), 13);
        return replaces;
    }

    public boolean existsSimilarName(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel channel = this.findChannelById(nChannelId);
        this.validateRight(loginUser, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label5", "\u67e5\u8be2\u76f8\u4f3c\u66ff\u6362\u5185\u5bb9\u540d\u79f0"), 13);
        WCMFilter existFilter = new WCMFilter("WCMREPLACE", "ChnlId=? and ReplaceName=? and ReplaceId<>?", "", "ReplaceId");
        existFilter.addSearchValues(0, nChannelId);
        existFilter.addSearchValues(1, _methodContext.getValue("ReplaceName"));
        existFilter.addSearchValues(2, _methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User _loginUser, Replaces _replaces, String _sOprDesc, int rightIndex) throws WCMException {
        for (int i = _replaces.size() - 1; i >= 0; --i) {
            Replace replace = (Replace)_replaces.getAt(i);
            if (replace == null) {
                _replaces.removeAt(i, false);
                continue;
            }
            this.validateRight(_loginUser, replace, _sOprDesc, rightIndex);
        }
    }

    private void validateRight(User _loginUser, Replace _replace, String _sOprDesc, int rightIndex) throws WCMException {
        Channel channel = _replace.getChannel();
        if (!AuthServer.hasRight(_loginUser, (CMSObj)channel, rightIndex)) {
            throw new WCMException(I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u5bf9\u4e8e[") + channel + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label7", "]\u6ca1\u6709\u4fee\u6539\u6743\u9650,\u6240\u4ee5\u4e0d\u80fd") + _sOprDesc + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label8", "\u66ff\u6362\u5185\u5bb9![Id=") + _replace.getId() + "]");
        }
    }

    private void validateRight(User _loginUser, Channel channel, String _sOprDesc, int rightIndex) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)channel, rightIndex)) {
            throw new WCMException(I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u5bf9\u4e8e[") + channel + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label7", "]\u6ca1\u6709\u4fee\u6539\u6743\u9650,\u6240\u4ee5\u4e0d\u80fd") + _sOprDesc + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label9", "\u66ff\u6362\u5185\u5bb9!"));
        }
    }

    private Replace findReplaceById(int _nObjectId) throws WCMException {
        Replace replace = Replace.findById(_nObjectId);
        if (replace == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nObjectId), WCMTypes.getLowerObjName(105)}));
        }
        return replace;
    }

    private Channel findChannelById(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        if (channel == null) {
            throw new WCMException(1100, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label12", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nChannelId + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label11", "]\u4e0d\u5b58\u5728!"));
        }
        return channel;
    }
}

