/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.db.InfoViewDBStoreServer;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewEmploy;
import com.trs.components.infoview.persistent.InfoViewEmploys;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewService;
import com.trs.service.ServiceHelper;
import com.trs.service.impl.InfoViewService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import org.apache.log4j.Logger;

public class InfoviewDataToolService
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(InfoviewDataToolService.class);
    IInfoViewService m_oInfoviewService = new InfoViewService();
    private InfoViewDBStoreServer m_oInfoViewDBStoreServer = null;

    public void adapterHistory(MethodContext _context) throws WCMException {
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label1", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e00\u6b65\u5f00\u59cb."));
        this.rebuildAllInfoViews(_context);
        this.renderAllInfoViewSearchOutlineFields(_context);
        this.renderAllChannelOutlineFields(_context);
        this.syncChnlDocFlag(_context);
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label2", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e00\u6b65\u6210\u529f."));
    }

    public void syncChnlDocFlag(MethodContext _context) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label3", "\u540c\u6b65\u6587\u6863\u7684DocFlag\u5230ChnlDoc\u8868\u4e2d."));
        String sExecSql = "update WCMChnlDoc set DocFlag=(select DocFlag from WCMDocument where DocFlag>0  and DocId=WCMChnlDoc.DocId)";
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sExecSql});
    }

    public void autoCreateHistoryDocs(MethodContext _context) throws WCMException {
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label4", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e8c\u6b65\u5f00\u59cb."));
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label5", "\u904d\u5386docflag>0\u7684\u6587\u6863\u5217\u8868\uff0c\u4fdd\u5b58\u76f8\u5173\u7684\u5b57\u6bb5\uff0c\u751f\u6210\u65b0\u7684\u8868\u5355\u6570\u636e."));
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter();
        String sChannelIds = CMyString.showNull(_context.getValue("ChannelIds"), _context.getValue("ChannelId"));
        String sSiteIds = CMyString.showNull(_context.getValue("SiteIds"), _context.getValue("SiteId"));
        if (sChannelIds == null || sChannelIds.length() <= 0) {
            if (sSiteIds != null && sSiteIds.length() > 0) {
                Channels oChannels = new Channels(loginUser);
                oChannels.open(new WCMFilter("", "siteid in(" + sSiteIds + ")", "", "CHANNELID"));
                sChannelIds = oChannels.getIdListAsString();
            } else {
                int nInfoViewId = _context.getValue("InfoViewId", 0);
                if (nInfoViewId != 0) {
                    InfoViewEmploys oInfoViewEmploys = new InfoViewEmploys(loginUser);
                    oInfoViewEmploys.open(new WCMFilter("", "InfoViewID=" + nInfoViewId + " and EmployerType=101", "", "EmployerID"));
                    sChannelIds = oInfoViewEmploys.getIdListAsString();
                }
            }
        }
        if (!CMyString.isEmpty(sChannelIds)) {
            filter.setWhere("docchannel in(" + sChannelIds + ")");
        }
        filter.mergeWith(new WCMFilter("", "docflag>0", ""));
        Documents oDocuments = new Documents(loginUser);
        oDocuments.open(filter);
        for (int i = 0; i < oDocuments.size(); ++i) {
            int nDocumentId = 0;
            try {
                Document oDocument = (Document)oDocuments.getAt(i);
                if (oDocument == null) continue;
                nDocumentId = oDocument.getId();
                this.getInfoViewDBStoreServer().saveInfoViewData(oDocument.getFlag(), oDocument);
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label6", "\u6210\u529f\u4e3a\u6587\u6863[") + oDocument + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label7", "]\u521b\u5efa/\u66f4\u65b0\u5143\u6570\u636e.")));
                continue;
            }
            catch (WCMException ex) {
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label8", "\u4e3a\u6587\u6863[") + nDocumentId + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label9", "]\u521b\u5efa/\u66f4\u65b0\u5143\u6570\u636e\u51fa\u9519.")), (Throwable)ex);
            }
        }
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label10", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e8c\u6b65\u6210\u529f."));
    }

    private InfoViewDBStoreServer getInfoViewDBStoreServer() throws WCMException {
        if (this.m_oInfoViewDBStoreServer == null) {
            this.m_oInfoViewDBStoreServer = (InfoViewDBStoreServer)DreamFactory.createObjectById("InfoViewDBStoreServer");
        }
        if (this.m_oInfoViewDBStoreServer == null) {
            throw new WCMException(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label11", "\u5bf9\u4e0d\u8d77\uff0c\u65e0\u6cd5\u627e\u5230\u7a00\u758f\u6570\u636e\u5e94\u7528\uff01\u8bf7\u68c0\u67e5\u60a8\u7684WCM\uff01"));
        }
        return this.m_oInfoViewDBStoreServer;
    }

    public void renderAllChannelOutlineFields(MethodContext _context) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label12", "\u66ff\u6362\u680f\u76ee\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u81ea\u52a8\u751f\u6210\u76f8\u5e94\u7684DB\u5b57\u6bb5."));
        InfoViewEmploys oInfoViewEmploys = new InfoViewEmploys(this.getLoginUser());
        oInfoViewEmploys.open(null);
        for (int i = 0; i < oInfoViewEmploys.size(); ++i) {
            int nChannelId = 0;
            try {
                InfoViewEmploy oInfoViewEmploy = (InfoViewEmploy)oInfoViewEmploys.getAt(i);
                CMSObj oCMsObj = oInfoViewEmploy.getEmployer();
                InfoView oInfoView = oInfoViewEmploy.getInfoView();
                if (oInfoView == null || !(oCMsObj instanceof Channel)) continue;
                Channel oChannel = (Channel)oCMsObj;
                nChannelId = oChannel.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label13", "\u66ff\u6362\u680f\u76ee\u7684\u6982\u89c8\u5b57\u6bb5[channelid=") + nChannelId + "]."));
                String sOutlineFields = oChannel.getOutlineFields();
                if (CMyString.isEmpty(sOutlineFields)) continue;
                Object[] arrOutlineFields = sOutlineFields.split(",");
                for (int j = 0; j < arrOutlineFields.length; ++j) {
                    if (arrOutlineFields[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                        arrOutlineFields[j] = "DOCNO";
                    }
                    if (!((String)arrOutlineFields[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                    arrOutlineFields[j] = "RANDOMSERIAL";
                }
                sOutlineFields = CMyString.join(arrOutlineFields, ",");
                oChannel.setOutlineFields(sOutlineFields);
                oChannel.setProperty("OutlineDBFields", InfoViewHelper.getDBFieldsByFields(oInfoView, sOutlineFields, true));
                ServiceHelper.createChannelService().save(oChannel);
                continue;
            }
            catch (WCMException ex) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label13", "\u66ff\u6362\u680f\u76ee\u7684\u6982\u89c8\u5b57\u6bb5[channelid=") + nChannelId + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label14", "]\u65f6\u51fa\u9519")), (Throwable)ex);
            }
        }
    }

    public void renderAllInfoViewSearchOutlineFields(MethodContext _context) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label15", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5\uff0c\u81ea\u52a8\u751f\u6210\u76f8\u5e94\u7684DB\u5b57\u6bb5."));
        InfoViews oInfoViews = new InfoViews(this.getLoginUser());
        oInfoViews.open(null);
        for (int i = 0; i < oInfoViews.size(); ++i) {
            int nInfoViewId = 0;
            try {
                String sSearchFields;
                InfoView oInfoView = (InfoView)oInfoViews.getAt(i);
                if (oInfoView == null) continue;
                nInfoViewId = oInfoView.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label16", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5[infoviewid=") + nInfoViewId + "]."));
                boolean bNeedSave = false;
                String sOutlineFields = oInfoView.getOutlineFields();
                if (!CMyString.isEmpty(sOutlineFields)) {
                    bNeedSave = true;
                    Object[] arrOutlineFields = sOutlineFields.split(",");
                    for (int j = 0; j < arrOutlineFields.length; ++j) {
                        if (arrOutlineFields[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                            arrOutlineFields[j] = "DOCNO";
                        }
                        if (!((String)arrOutlineFields[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                        arrOutlineFields[j] = "RANDOMSERIAL";
                    }
                    sOutlineFields = CMyString.join(arrOutlineFields, ",");
                    oInfoView.setOutlineFields(sOutlineFields);
                }
                if (!CMyString.isEmpty(sSearchFields = oInfoView.getSearchFields())) {
                    bNeedSave = true;
                    Object[] arrSearchFields = sSearchFields.split(",");
                    for (int j = 0; j < arrSearchFields.length; ++j) {
                        if (arrSearchFields[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                            arrSearchFields[j] = "DOCNO";
                        }
                        if (!((String)arrSearchFields[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                        arrSearchFields[j] = "RANDOMSERIAL";
                    }
                    sSearchFields = CMyString.join(arrSearchFields, ",");
                    oInfoView.setSearchFields(sSearchFields);
                }
                if (!bNeedSave) continue;
                oInfoView.save();
                continue;
            }
            catch (WCMException ex) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label16", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5[infoviewid=") + nInfoViewId + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label14", "]\u65f6\u51fa\u9519")), (Throwable)ex);
            }
        }
    }

    public void rebuildAllInfoViews(MethodContext _context) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label17", "\u51c6\u5907\u4e3a\u7cfb\u7edf\u6240\u6709\u89c6\u56fe\u521b\u5efa\u8868\u7ed3\u6784."));
        InfoViews oInfoViews = new InfoViews(this.getLoginUser());
        oInfoViews.open(null);
        for (int i = 0; i < oInfoViews.size(); ++i) {
            int nInfoViewId = 0;
            try {
                InfoView oInfoView = (InfoView)oInfoViews.getAt(i);
                nInfoViewId = oInfoView.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label18", "\u91cd\u65b0\u6574\u7406\u8868\u5355[infoviewid=") + nInfoViewId + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label19", "]\u6587\u4ef6\u4ee5\u751f\u6210DB\u7ed3\u6784.")));
                this.m_oInfoviewService.save(oInfoView);
                continue;
            }
            catch (WCMException ex) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label18", "\u91cd\u65b0\u6574\u7406\u8868\u5355[infoviewid=") + nInfoViewId + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label20", "]\u6587\u4ef6\u4ee5\u751f\u6210DB\u7ed3\u6784\u65f6\u51fa\u9519")), (Throwable)ex);
            }
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

