/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ProcessService;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.infoview.mad.InfoViewQueryHelper;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DiscoveryFactoryBuddy;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowingDocQueryService
implements ISelfDefinedServiceProvider {
    protected static Logger logger = Logger.getLogger(ProcessService.class);
    private ProcessService m_oProcessService = new ProcessService();

    public String getFlowingDocBySNO(MethodContext _context) throws Throwable {
        int nCurrDocId = this.getInfoViewQueryHelper().findCurrDocIdBySNO(_context);
        if (nCurrDocId == 0) {
            return null;
        }
        String sPositionCode = _context.getValue("SNO");
        _context.setValue("ContentType", 605);
        _context.setValue("ContentId", nCurrDocId);
        FlowDocs flowdocs = this.m_oProcessService.getFlowDocsOfContent(_context);
        FlowDoc flowdoc = null;
        if (flowdocs == null || flowdocs.size() <= 0 || (flowdoc = (FlowDoc)flowdocs.getAt(0)) == null) {
            return null;
        }
        Document doc = (Document)flowdoc.getFlowContent().getSubstance();
        StringBuffer sb = new StringBuffer();
        sb.append(WCMProcessServiceHelper.makeXMLNode("SNO", sPositionCode));
        sb.append(WCMProcessServiceHelper.makeXMLNode("FlowDocId", String.valueOf(flowdoc.getId())));
        sb.append(WCMProcessServiceHelper.makeXMLNode("DocTitle", doc.getTitle() + "[ID=" + doc.getId() + "]"));
        sb.append(WCMProcessServiceHelper.makeXMLNode("DocId", String.valueOf(doc.getId())));
        sb.append(WCMProcessServiceHelper.makeXMLNode("Channel", doc.getChannel().getDesc() + "[ID=" + doc.getChannelId() + "]"));
        sb.append(WCMProcessServiceHelper.makeXMLNode("PostUser", doc.getPropertyAsString("PostUser")));
        CMyDateTime dtStart = doc.getCrTime();
        sb.append(WCMProcessServiceHelper.makeXMLNode("PostTime", dtStart.toString()));
        CMyDateTime dtLastly = flowdoc.getCrTime();
        sb.append(WCMProcessServiceHelper.makeXMLNode("LastProcessTime", dtLastly.toString()));
        long nDateFiff = dtLastly.dateDiff(3, dtStart);
        if (nDateFiff == 0L) {
            nDateFiff = dtLastly.dateDiff(4, dtStart);
            sb.append(WCMProcessServiceHelper.makeXMLNode("TotleTime", nDateFiff + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label1", "\u5c0f\u65f6")));
        } else {
            sb.append(WCMProcessServiceHelper.makeXMLNode("TotleTime", nDateFiff + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label2", "\u5929")));
        }
        String status = doc.getPropertyAsString("FLOWOPERATIONMARK");
        sb.append(WCMProcessServiceHelper.makeXMLNode("ProcessStatus", status));
        String stages = doc.getPropertyAsString("FLOWOPERATIONMASKENUM");
        sb.append(WCMProcessServiceHelper.makeXMLNode("ProcessStages", stages));
        String result = WCMProcessServiceHelper.makeXMLNode("FlowingDocInfo", sb.toString(), false);
        sb.setLength(0);
        return result;
    }

    public String getFlowingStatByChnl(MethodContext _context) throws Throwable {
        try {
            int nChnlId = _context.getValue("ChannelId", 0);
            Channel currChannel = Channel.findById(nChnlId);
            if (currChannel == null) {
                throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label3", "ID\u4e3a[") + nChnlId + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label4", "]\u7684\u9891\u9053\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
            }
            FlowEmployMgr m_oFlowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
            Flow currFlow = m_oFlowEmployMgr.getFlow(currChannel);
            if (currFlow == null) {
                throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label3", "ID\u4e3a[") + nChnlId + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label5", "]\u7684\u9891\u9053\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff01\uff01"));
            }
            Map hFlowingPath = this.parseFlowingPath(currFlow.getPropertyAsString("OperationMarkEnum"));
            if (hFlowingPath == null || hFlowingPath.isEmpty()) {
                return null;
            }
            this.fillFromRecords(hFlowingPath, currChannel, _context);
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : hFlowingPath.entrySet()) {
                Object key = entry.getKey();
                Integer value = (Integer)entry.getValue();
                if (key == null || value == null) continue;
                String sContent = WCMProcessServiceHelper.makeXMLNode("StageName", key.toString());
                sContent = sContent + WCMProcessServiceHelper.makeXMLNode("StageCounter", String.valueOf(value));
                sb.append(WCMProcessServiceHelper.makeXMLNode("Stage", sContent, false));
            }
            String result = WCMProcessServiceHelper.makeXMLNode("Stages", sb.toString(), false);
            sb.setLength(0);
            return result;
        }
        catch (WCMException ex) {
            return WCMProcessServiceHelper.makeXMLNode("errmsg", ex.getMessage());
        }
    }

    private Map fillFromRecords(Map hRaw, Channel _channel, MethodContext _context) throws Throwable {
        Documents docs = null;
        docs = _channel.getType() == 13 ? this.getInfoViewQueryHelper().getDocuments(_channel, _context) : this.getDocuments(_channel, _context);
        if (docs == null || docs.size() <= 0) {
            return null;
        }
        Document doc = null;
        CPager currPager = new CPager(-1);
        int nDataSize = docs.size();
        currPager.setItemCount(nDataSize);
        for (int i = currPager.getFirstItemIndex() - 1; i < currPager.getLastItemIndex(); ++i) {
            String opt;
            doc = (Document)docs.getAt(i);
            if (doc == null || CMyString.isEmpty(opt = doc.getPropertyAsString("FLOWOPERATIONMARK"))) continue;
            Integer counter = (Integer)hRaw.get(opt);
            if (counter == null) {
                counter = new Integer(0);
            }
            hRaw.put(opt, new Integer(counter + 1));
        }
        return hRaw;
    }

    private Documents getDocuments(Channel _channel, MethodContext _context) throws WCMException {
        DocumentMgr docMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Documents docs = docMgr.getAllDocuments(_channel, null);
        return docs;
    }

    public Map parseFlowingPath(String _sPath) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String sPath = _sPath;
        if (CMyString.isEmpty(sPath)) {
            return result;
        }
        String[] parts = (sPath = sPath.replaceAll("(\\{|\\}|\\[|\\])", "")).split(",");
        if (parts.length <= 2) {
            return result;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            String sName = parts[i];
            if (CMyString.isEmpty(sName)) continue;
            result.put(sName, null);
        }
        return result;
    }

    private InfoViewQueryHelper getInfoViewQueryHelper() throws WCMException {
        InfoViewQueryHelper helper = (InfoViewQueryHelper)DiscoveryFactoryBuddy.getImplementor(InfoViewQueryHelper.class);
        if (helper == null) {
            throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label6", "\u6ca1\u6709\u5b89\u88c5\u8868\u5355\u9009\u4ef6\uff01\u8bf7\u6b63\u786e\u5b89\u88c5\u540e\u518d\u4f7f\u7528\u8be5\u9009\u9879\u529f\u80fd\uff01"));
        }
        return helper;
    }
}

