/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.WCMDocumentHelper;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitor;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitorFactory;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.trsserver.DatasFromTRSServer;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.config.PageOperator;
import com.trs.wcm.config.PageOperators;
import com.trs.wcm.customize.ICustomizeMgr;
import com.trs.wcm.photo.IImageLibService;
import com.trs.wcm.publish.PreviewURLSign;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DocumentServiceProvider
implements IGlueServiceProvider {
    private static Logger logger = Logger.getLogger(DocumentServiceProvider.class);
    private ContentExtFieldMgr m_oExtFieldMgr = null;
    public static boolean SUPPORT_DEFINE_DOCUMENT_RIGHT = true;
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;
    private static final String DEFAULT_DELCHANNELIDS = "-1";
    public static final String KEY_PRIVATE_PREVIEW_ACCESS = ConfigConstants.DIR_APPROOT + "private_platform_log.key";
    private IDocumentTransmitorFactory m_oDocumentTransmitorFactory = null;
    private static String[][] DEFAULT_FIELDS = new String[][]{{"DocTitle", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label1", "\u6807\u9898"), "true"}, {"CrTime", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label2", "\u521b\u5efa\u65f6\u95f4"), "true"}, {"DocChannel", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label3", "\u6240\u5c5e\u680f\u76ee"), "true"}, {"CrUser", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label4", "\u53d1\u7a3f\u4eba"), "true"}, {"DocStatus", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label5", "\u72b6\u6001"), "true"}, {"DocType", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label6", "\u7c7b\u578b"), "true"}};
    private static StringBuffer DEFAULT_SELECT_FIELDS = new StringBuffer(10 + DEFAULT_FIELDS.length * 20);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private ICustomizeMgr m_oCustomizeMgr = (ICustomizeMgr)DreamFactory.createObjectById("ICustomizeMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    private DocReplyMgr m_oDocReplyMgr = null;

    public DocumentServiceProvider() {
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
        this.m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
        this.m_oDocumentTransmitorFactory = (IDocumentTransmitorFactory)DreamFactory.createObjectById("IDocumentTransmitorFactory");
    }

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methContext);
        boolean bDrop = _methContext.getValue("Drop", false);
        Documents documents = Documents.findByIds(loginUser, _methContext.getObjectIds());
        this.validateRight(loginUser, channelOrSite, documents, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label7", "\u5220\u9664"));
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            Channel channel = null;
            channel = !channelOrSite.isSite() ? (Channel)channelOrSite : document.getChannel();
            this.m_oDocumentMgr.delete(document, channel, bDrop);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        WCMFilter tempFilter;
        int nFilterType;
        DebugTimer timer = new DebugTimer();
        timer.start();
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methContext);
        this.validateRight(loginUser, channelOrSite, 30, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label8", "\u83b7\u53d6\u6587\u6863\u5217\u8868"));
        WCMFilter extraFilter = new WCMFilter(_methContext.getQueryFilter());
        int nMaxNum = _methContext.getValue("ItemCount", 0);
        if (nMaxNum > 0) {
            extraFilter.setMaxRowNumber(nMaxNum);
        }
        if ((nFilterType = _methContext.getValue("FilterType", 0)) != 0 && (tempFilter = this.makeFilterByType(loginUser, channelOrSite.getSite(), nFilterType)) != null && tempFilter.getWhere() != null && tempFilter.getWhere().length() > 0) {
            extraFilter.setWhere(tempFilter.getWhere());
            extraFilter.setSearchValues(tempFilter.getSearchValues());
        }
        Documents documents = this.m_oDocumentMgr.getDocuments(channelOrSite, extraFilter);
        if (SUPPORT_DEFINE_DOCUMENT_RIGHT) {
            this.removeDocumentNotHasRight(loginUser, channelOrSite, documents, 30, _methContext);
        }
        timer.stop();
        logger.info((Object)("use[" + timer.getTime() + "]ms"));
        return documents;
    }

    private BaseChannel makeCurrChannelOrSite(MethodContext _methContext) throws WCMException {
        int nSiteId = _methContext.getValue("SiteID", 0);
        int nChannelId = _methContext.getValue("ChannelId", 0);
        if (nSiteId <= 0 && nChannelId <= 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label9", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u65e0\u6548\u7684\u7ad9\u70b9ID[") + nSiteId + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label10", "]\u6216\u680f\u76eeID[") + nChannelId + "]!");
        }
        if (nSiteId > 0 && nChannelId > 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label11", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u540c\u65f6\u6307\u5b9a\u4e86\u7ad9\u70b9ID[") + nSiteId + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label12", "]\u548c\u680f\u76eeID[") + nChannelId + "]!");
        }
        BaseChannel channelOrSite = null;
        if (nSiteId > 0 && ((channelOrSite = WebSite.findById(nSiteId)) == null || channelOrSite.getStatus() < 0)) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nSiteId), WCMTypes.getLowerObjName(103)}));
        }
        if (nChannelId > 0) {
            channelOrSite = Channel.findById(nChannelId);
            if (channelOrSite == null || channelOrSite.getStatus() < 0) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelId), WCMTypes.getLowerObjName(101)}));
            }
            _methContext.putContextCacheData("CurrChannel", channelOrSite);
        }
        return channelOrSite;
    }

    public String preview(MethodContext _methodContext) throws Throwable {
        int nId4Preview;
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        Document document = null;
        document = new Document();
        String[] pLogicFields = new String[]{"ChannelId", "SiteId", "ObjectId"};
        document = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, document, pLogicFields);
        document.setPubHtmlContent(document.getHtmlContent());
        document.setProperty("CRTIME", CMyDateTime.now());
        document.setProperty("CRUSER", loginUser.getName());
        if (document.getType() != 20) {
            document.setProperty("DOCPUBHTMLCON", document.getProperty("DocContent"));
        }
        String[] warningHolder = new String[1];
        String sPreviewUrl = null;
        String[] urls = new String[1];
        if (channelOrSite instanceof Channel) {
            document.setChannel((Channel)channelOrSite);
            int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
            if (nFlowDocId > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label15", "\u9884\u89c8"));
            } else {
                Document oSrcDocument = Document.findById(_methodContext.getObjectId());
                if (!(DocumentAuthServer.hasRight(loginUser, channelOrSite, oSrcDocument, 38) || document.isAddMode() && DocumentAuthServer.isRightIndexOwnerHas(38))) {
                    throw new WCMException(1002, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label16", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + channelOrSite + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label17", "\u4e2d\u7684\u6587\u6863"));
                }
            }
            nId4Preview = _methodContext.getObjectId();
            if (nId4Preview == 0) {
                nId4Preview = -loginUser.getId();
            }
        } else {
            throw new WCMException(200006, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label18", "\u6ca1\u6709\u4f20\u5165\u680f\u76eeID!"));
        }
        document.setId(nId4Preview);
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channelOrSite);
        content.setFolder(folder);
        Template detailTemplate = Template.findById(_methodContext.getValue("TemplateId", 0));
        urls[0] = sPreviewUrl = PublishServer.getInstance().previewContent(content, warningHolder, detailTemplate);
        PreviewURLSign.getUniqueSignedStrs(urls, KEY_PRIVATE_PREVIEW_ACCESS);
        return "<result><![CDATA[" + urls[0] + "]]></result>";
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        String dochtmlcon;
        if (ConfigServer.getServer().getSysConfigValue("EncodeHTMLContent", "true").equalsIgnoreCase("true") && (dochtmlcon = _methodContext.getValue("DOCHTMLCON")) != null) {
            String str = new String(dochtmlcon.getBytes("gbk"), "gbk");
            _methodContext.setValue("DOCHTMLCON", str);
        }
        DebugTimer timer = new DebugTimer();
        DebugTimer tempTimer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            timer.start();
            tempTimer.start();
            logger.info((Object)"Document.save...");
        }
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        Document document = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            document = new Document();
        } else {
            document = Document.findById(nObjectId);
            if (document == null) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label19", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
        }
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nObjectId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else {
            int nRightIndex = 80;
            if (!this.hasRight(loginUser, channelOrSite, document, nRightIndex)) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label21", "\u60a8\u6ca1\u6709\u6743\u9650\u4fdd\u5b58\u6587\u6863![ObjectId=") + _methodContext.getObjectId() + "]");
            }
        }
        String[] pLogicFields = new String[]{"ChannelId", "SiteId", "ObjectId", "FLOWDOCID", "FieldNamesNotTrim"};
        document = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, document, pLogicFields);
        if (document.isAddMode()) {
            document.setChannel(_methodContext.getValue("ChannelId", 0));
        }
        if (logger.isDebugEnabled()) {
            tempTimer.stop();
            logger.info((Object)("init[" + document + "] use [" + tempTimer.getTime() + "]ms!"));
        }
        if (!document.isAddMode() && document.isChangeProperty("DocStatus")) {
            this.m_oDocumentMgr.changeStatus(document, channelOrSite.isSite() ? document.getChannel() : (Channel)channelOrSite, document.getNewPropertyAsInt("DocStatus", 1));
            document.unlock();
            int nOldStatus = document.getPropertyAsInt("DocStatus", 0);
            int oNewStatus = document.getNewPropertyAsInt("DocStatus", 0);
            if (nOldStatus == 1028 && oNewStatus == 1) {
                this.m_oDocumentMgr.save(document);
            }
        } else {
            tempTimer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                tempTimer.start();
                logger.info((Object)"DocumentMgr.save...");
            }
            this.m_oDocumentMgr.save(document);
            if (logger.isDebugEnabled()) {
                tempTimer.stop();
                logger.info((Object)("DocumentMgr.save[" + document + "] use [" + tempTimer.getTime() + "]ms!"));
            }
        }
        if (logger.isDebugEnabled()) {
            timer.stop();
            logger.info((Object)("save[" + document + "] use [" + timer.getTime() + "]ms!"));
        }
        try {
            String directlyPublish = _methodContext.getValue("DirectlyPublish");
            if ("0".equals(directlyPublish) || "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("PUBLISHED_NEED_FLOW", "true"))) {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, _methodContext);
            }
        }
        catch (Throwable ex) {
            ServiceInvocationException exp = new ServiceInvocationException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label22", "\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label23", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), ex);
            exp.setErrorCode("17080");
            throw exp;
        }
        this.processQutedPhotoIfNeed(document);
        return document.getId();
    }

    private void processQutedPhotoIfNeed(Document document) {
        if (document.getType() != 20) {
            return;
        }
        final Document doc = document;
        final Logger myLogger = logger;
        final User currUser = ContextHelper.getLoginUser();
        new Thread(){

            @Override
            public void run() {
                ContextHelper.initContext(currUser);
                String sHtml = doc.getHtmlContent();
                HtmlElementFinder finder = new HtmlElementFinder(sHtml);
                HtmlElement photo = null;
                HashSet<String> photodocids = new HashSet<String>(5, 0.2f);
                String photodocid = null;
                while ((photo = finder.findNextElement("img")) != null) {
                    if (!"1".equals(photo.getAttributeValue("fromphoto"))) continue;
                    photodocid = photo.getAttributeValue("photodocid");
                    photodocids.add(photodocid);
                }
                IImageLibService libService = (IImageLibService)DreamFactory.createObjectById("IImageLibService");
                if (!photodocids.isEmpty()) {
                    try {
                        StringBuffer buff = new StringBuffer(64);
                        Iterator itr = photodocids.iterator();
                        while (itr.hasNext()) {
                            buff.append(",");
                            buff.append(itr.next());
                        }
                        libService.quoteImages(doc.getId(), buff.substring(1));
                    }
                    catch (Exception e) {
                        myLogger.error((Object)"fail to record photolib quoted!", (Throwable)e);
                    }
                } else {
                    try {
                        libService.clearQuotedImages(doc.getId());
                    }
                    catch (WCMException wCMException) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nDocId = _methodContext.getObjectId();
        String sSelectFields = _methodContext.getValue("SelectFields");
        Document document = Document.findById(nDocId, sSelectFields);
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(loginUser, channelOrSite, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label109", "\u67e5\u770b"));
        }
        return document;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        boolean bFromOutline = _methodContext.getValue("FromOutline", false);
        String sDocIds = _methodContext.getObjectIds();
        String sSelectFields = _methodContext.getValue("SelectFields");
        Documents documents = Documents.findByIds(null, sDocIds);
        documents.setFilter(new WCMFilter("", "", "", sSelectFields));
        this.removeDocumentNotHasRight(loginUser, channelOrSite, documents, bFromOutline ? 30 : 34, _methodContext);
        return documents;
    }

    public String getPageInfo(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methContext);
        if (channelOrSite == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label25", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + _methContext.getValue("SITEID") + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label14", "]\u6216\u680f\u76ee[ID=") + _methContext.getValue("CHANNELID") + "].");
        }
        int nRightIndex = 30;
        if (!AuthServer.hasRight(loginUser, (CMSObj)channelOrSite, nRightIndex)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label26", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8[") + channelOrSite + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label27", "]\u7684\u6587\u6863\u5217\u8868\uff01"));
        }
        Element root = DocumentHelper.createElement((String)"PageInfo");
        if (channelOrSite.isSite()) {
            root.addAttribute("SiteId", String.valueOf(channelOrSite.getId()));
        } else {
            root.addAttribute("ChannelId", String.valueOf(channelOrSite.getId()));
        }
        root.addElement("DisplayName").addCDATA(channelOrSite.getDesc());
        root.addElement("DisplayDesc").addCDATA(this.getFolderPath(channelOrSite));
        Element personal = root.addElement("Personal");
        this.addFilters(personal);
        this.addFileds(personal);
        return root.asXML();
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methContext);
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            return this.makeDocumentOpertators(loginUser, channelOrSite, nObjectId);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            return this.makeDocumentsOpertators(loginUser, channelOrSite, sObjectIds);
        }
        throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label28", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public Channels getQuotedChannels(MethodContext _MethodContext2) throws Throwable {
        int nDocId = _MethodContext2.getValue("ObjectId", 0);
        if (nDocId <= 0) {
            return new Channels(null);
        }
        Document document = this.findDocumentById(nDocId);
        int nModal = _MethodContext2.getValue("Modal", 0);
        return this.m_oDocumentMgr.getQutoedChannels(document, nModal, null);
    }

    public Reports move(MethodContext _methodContext) throws Throwable {
        int i;
        User loginUser = this.getLoginUser();
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        Channel fromChannel = Channel.findById(nFromChannelId);
        if (fromChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label103", "\u6e90\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        Documents documents = this.getDocuments(_methodContext);
        Channel toChannel = this.findChannelById(_methodContext.getValue("ToChannelId", 0));
        if (toChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label104", "\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        if (toChannel.getStatus() < 0) {
            return null;
        }
        String sDesc = fromChannel == null ? "" : CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label30", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863\u5230\u680f\u76ee[{1}]."), new String[]{fromChannel.getDispDesc(), toChannel.getDispDesc()});
        Reports reports = new Reports(sDesc);
        if (!this.hasRight(loginUser, toChannel, null, 31)) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label31", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[{0}]\u4e2d\u6dfb\u52a0\u6587\u6863!"), new String[]{toChannel.getDispDesc()}), null);
            return reports;
        }
        int nSize = documents.size();
        for (i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label33", "\u79fb\u52a8\u5931\u8d25:\u6587\u6863[ID={0}]\u6ca1\u6709\u627e\u5230!"), new int[]{documents.getIdAt(i)}), null);
                documents.removeAt(i, false);
                continue;
            }
            if (this.hasRight(loginUser, fromChannel, document, 33)) continue;
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label35", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u79fb\u52a8\u6587\u6863[") + document.getTitle() + "]!", null);
            documents.removeAt(i, false);
        }
        for (i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(document, fromChannel, toChannel));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label102", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25."), new String[]{fromChannel.getDispDesc(), document.getTitle(), toChannel.getDispDesc()}), e);
            }
        }
        return reports;
    }

    public Reports copy(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        Channel fromChannel = Channel.findById(nFromChannelId);
        Documents documents = this.getDocuments(_methodContext);
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        int nTransmitType = _methodContext.getValue("TransmitType", 1);
        return this.transmit(loginUser, fromChannel, documents, toChannels, nTransmitType);
    }

    public void startDocumentInFlow(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document document = Document.findById(_methodContext.getObjectId());
        if (document == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label19", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
        }
        if (!DocumentAuthServer.hasRight(loginUser, null, document, 32)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label39", "\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u6587\u6863[Title=") + document.getTitle() + "][DocId=" + _methodContext.getObjectId() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label40", "]\u6d41\u8f6c\uff01"));
        }
        _methodContext.setValue("force2start", "true");
        document.setPropertyWithString("FLOWPREOPERATIONMARK", "");
        this.m_oDocumentMgr.save(document);
        WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, _methodContext);
    }

    private Documents getDocuments(MethodContext _context) throws WCMException {
        Channel fromChannel = null;
        Documents documents = null;
        String docIds = _context.getObjectIds();
        if (CMyString.isEmpty(docIds)) {
            throw new WCMException(10, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label41", "\u6ca1\u6709\u6307\u5b9a\u8981\u5f15\u7528\u7684\u6587\u6863\uff01"));
        }
        int nFromChannelId = _context.getValue("FromChannelId", 0);
        if (nFromChannelId == 0 || nFromChannelId == -2 || nFromChannelId == -1) {
            documents = Documents.findByIds(this.getLoginUser(), docIds);
        } else {
            fromChannel = this.findChannelById(nFromChannelId);
            WCMFilter filter = new WCMFilter("", "DocId IN(" + docIds + ")", "");
            documents = this.m_oDocumentMgr.getDocuments(fromChannel, filter);
        }
        return documents;
    }

    public Reports transmit(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Documents documents = Documents.findByIds(loginUser, _methodContext.getObjectIds());
        Channel fromChannel = null;
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        if (nFromChannelId > 0) {
            fromChannel = this.findChannelById(nFromChannelId);
        }
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        int nTransmitType = _methodContext.getValue("TransmitType", 1);
        return this.transmit(loginUser, fromChannel, documents, toChannels, nTransmitType);
    }

    public ContentExtendValues queryExtendFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document document = this.findDocumentById(_methodContext.getValue("DocumentId", 0));
        Channel channel = document.getChannel();
        if (channel == null) {
            return new ContentExtendValues(loginUser);
        }
        this.validateRight(loginUser, (BaseChannel)channel, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label42", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        ContentExtFields extFields = this.m_oExtFieldMgr.getExtFields(channel, filter, false);
        ContentExtendValues extendValues = new ContentExtendValues(loginUser, extFields.size(), 1);
        int nSize = extFields.size();
        for (int i = 0; i < nSize; ++i) {
            ContentExtField extend = (ContentExtField)extFields.getAt(i);
            if (extend == null) continue;
            extendValues.addElement(i + 1, extend.getDesc(), extend.getName(), document.getPropertyAsString(extend.getName()));
        }
        return extendValues;
    }

    public void setTopDocument(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        CMyDateTime dtValid = null;
        int nPosition = _methodContext.getValue("Position", 0);
        int nTopFlag = _methodContext.getValue("TopFlag", 0);
        String sDocumentIds = _methodContext.getValue("DocumentId");
        Documents docs = Documents.findByIds(loginUser, sDocumentIds);
        String strTargetDocumentIds = _methodContext.getValue("TargetDocumentId");
        strTargetDocumentIds = strTargetDocumentIds == null ? "0" : strTargetDocumentIds;
        String[] targetDocumentIds = strTargetDocumentIds.split(",");
        ArrayList<Document> targetDocumentList = new ArrayList<Document>();
        for (int i = 0; i < docs.size(); ++i) {
            int nTargetDocumentId;
            Document targetDocument = null;
            if (i < targetDocumentIds.length && (nTargetDocumentId = Integer.parseInt(targetDocumentIds[i])) > 0) {
                targetDocument = this.findDocumentById(nTargetDocumentId);
            }
            targetDocumentList.add(targetDocument);
        }
        for (int index = 0; index < docs.size(); ++index) {
            Document document = (Document)docs.getAt(index);
            if (!document.getCrUser().equals(loginUser)) {
                this.validateRight(loginUser, channel, 62, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label43", "\u7f6e\u9876"));
            }
            if (nTopFlag > 0) {
                if (nTopFlag == 1) {
                    dtValid = _methodContext.getValue("InvalidTime", new CMyDateTime());
                } else if (nTopFlag == 2) {
                    dtValid = null;
                } else if (nTopFlag == 3) {
                    dtValid = new CMyDateTime();
                }
                this.m_oDocumentMgr.setTopDocument(channel, document, (Document)targetDocumentList.get(index), nPosition, dtValid);
                continue;
            }
            this.m_oDocumentMgr.removeToppedDocument(channel, document);
        }
    }

    private Reports copy(User _loginUser, Documents _documents, Channel _fromChannel, Channels _toChannels) throws WCMException {
        int i;
        String sDesc = "";
        if (_fromChannel != null) {
            sDesc = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label44", "\u4ece\u680f\u76ee[{0}]\u590d\u5236\u6587\u6863"), new String[]{CMyString.filterForHTMLValue(_fromChannel.getDispDesc())});
        }
        Reports reports = new Reports(sDesc);
        _documents.setMaxBufferSize(_documents.size());
        for (i = _documents.size() - 1; i >= 0; --i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label45", "\u590d\u5236\u5931\u8d25:\u6587\u6863[ID=") + _documents.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                _documents.removeAt(i, false);
                continue;
            }
            if (this.hasRight(_loginUser, _fromChannel, document, 34)) continue;
        }
        if (_documents.size() <= 0) {
            reports.addSucessedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label110", "\u6ca1\u6709\u9700\u8981\u590d\u5236\u7684\u6587\u6863\u3002"));
            return reports;
        }
        int nSize = _toChannels.size();
        for (i = 0; i < nSize; ++i) {
            Channel toChannel = (Channel)_toChannels.getAt(i);
            if (toChannel == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label47", "\u590d\u5236\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            reports.add(this.copy(_loginUser, _documents, _fromChannel, toChannel));
        }
        return reports;
    }

    private Reports copy(User _loginUser, Documents _documents, Channel _fromChannel, Channel toChannel) throws WCMException {
        String sDesc = null;
        sDesc = _fromChannel != null ? CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label48", "\u4ece\u680f\u76ee[{0}]\u5411\u680f\u76ee[{1}]\u590d\u5236\u6587\u6863"), new String[]{_fromChannel.getDispDesc(), toChannel.getDispDesc()}) : CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label49", "\u5411\u680f\u76ee[{0}]\u590d\u5236\u6587\u6863"), new String[]{toChannel.getDispDesc()});
        Reports reports = new Reports(sDesc);
        if (!this.hasRight(_loginUser, toChannel, null, 31)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label105", "\u590d\u5236\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + _loginUser.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + toChannel.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
            return reports;
        }
        for (int i = _documents.size() - 1; i >= 0; --i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) continue;
            try {
                Document newDoc = this.m_oDocumentMgr.copyDocument(document, _fromChannel, toChannel);
                if (newDoc == null) {
                    reports.addFailedReport(document + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label55", "\u5728") + toChannel + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label56", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
                    continue;
                }
                if (newDoc.getId() != document.getId()) {
                    this.m_oAppendixMgr.copyAppendixes(document, newDoc);
                    this.m_oRelationMgr.copyRelations(document, newDoc);
                    this.m_oDocReplyMgr.copyDocReplys(document, newDoc);
                }
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label57", "\u590d\u5236\u6587\u6863[{0}]\u6210\u529f!"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label36", "\u590d\u5236\u6587\u6863[{0}]\u5931\u8d25!"), new String[]{document.getTitle()}), e);
            }
        }
        return reports;
    }

    public Reports copyAll(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel fromChannel = this.findChannelById(_methodContext.getValue("FromChannelId", 0));
        this.validateRight(loginUser, fromChannel, 57, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label58", "\u62f7\u8d1d"));
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        _methodContext.setValue("ChannelId", fromChannel.getId());
        Documents documents = (Documents)this.query(_methodContext);
        return this.copy(loginUser, documents, fromChannel, toChannels);
    }

    public Reports setQuote(MethodContext _methodContext) throws Throwable {
        Channel toChannel;
        int i;
        User loginUser = this.getLoginUser();
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        Channel fromChannel = Channel.findById(nFromChannelId);
        int nDocumentId = _methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(nDocumentId);
        String sQuoteType = _methodContext.getValue("QuoteType");
        String sDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label59", "\u5f15\u7528\u6587\u6863");
        Reports reports = new Reports(sDesc);
        if (document == null) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label60", "\u5f15\u7528\u5931\u8d25:\u6587\u6863[ID=") + nDocumentId + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
            return reports;
        }
        if (!this.hasRight(loginUser, fromChannel, document, 34)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label61", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[") + document.getTitle() + "]!", null);
            return reports;
        }
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        String sDelChannelIds = _methodContext.getValue("DelChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        String sOldToChannelIds = null;
        int nSize = toChannels.size();
        for (i = 0; i < nSize; ++i) {
            toChannel = (Channel)toChannels.getAt(i);
            ChnlDoc oldChnlDoc = this.m_oDocumentMgr.findChnlDoc(document, toChannel);
            if (oldChnlDoc == null) continue;
            if (sQuoteType.equals("mirror")) {
                if (oldChnlDoc.getModal() != 2) continue;
                if (sOldToChannelIds == null) {
                    sOldToChannelIds = CMyString.numberToStr(toChannel.getId());
                    continue;
                }
                sOldToChannelIds = sOldToChannelIds + "," + CMyString.numberToStr(toChannel.getId());
                continue;
            }
            if (oldChnlDoc.getModal() != 3) continue;
            sOldToChannelIds = sOldToChannelIds == null ? CMyString.numberToStr(toChannel.getId()) : sOldToChannelIds + "," + CMyString.numberToStr(toChannel.getId());
        }
        if (sOldToChannelIds != null) {
            sDelChannelIds = sDelChannelIds.equals(DEFAULT_DELCHANNELIDS) ? sOldToChannelIds : sDelChannelIds + "," + sOldToChannelIds;
        }
        try {
            if (sDelChannelIds == null) {
                if (sQuoteType.equals("mirror")) {
                    this.m_oDocumentMgr.deleteDocMirrors(document, sToChannelIds);
                } else {
                    this.m_oDocumentMgr.deleteDocQuotes(document, sToChannelIds);
                }
            } else if (!sDelChannelIds.equals(DEFAULT_DELCHANNELIDS) || !CMyString.isEmpty(sDelChannelIds)) {
                this.m_oDocumentMgr.deleteDocQuotesInDelChnlIds(document, sDelChannelIds);
            }
        }
        catch (WCMException ex) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label62", "\u5220\u9664\u4e0d\u518d\u4f7f\u7528\u7684\u5f15\u7528\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01"), ex);
            return reports;
        }
        toChannels = Channels.findByIds(loginUser, sToChannelIds);
        nSize = toChannels.size();
        for (i = 0; i < nSize; ++i) {
            toChannel = (Channel)toChannels.getAt(i);
            if (toChannel == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label63", "\u5f15\u7528\u5931\u8d25:\u680f\u76ee[ID=") + toChannels.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            sDesc = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label64", "\u5728\u680f\u76ee[{0}]\u5f15\u7528\u6587\u6863"), new String[]{toChannel.getDispDesc()});
            if (!toChannel.isCluster() && !this.hasRight(loginUser, toChannel, null, 31)) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label106", "\u5f15\u7528\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + loginUser.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + toChannel.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
                continue;
            }
            try {
                if (sQuoteType.equals("mirror")) {
                    this.m_oDocumentMgr.mirrorTo(document, fromChannel, toChannel);
                } else {
                    this.m_oDocumentMgr.quoteTo(document, toChannel);
                }
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label107", "\u5f15\u7528\u6587\u6863[{0}]\u6210\u529f\uff01"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label108", "\u5f15\u7528\u6587\u6863[{0}]\u5931\u8d25\uff01"), new String[]{document.getTitle()}), e);
            }
        }
        return reports;
    }

    public Reports quote(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        Channel fromChannel = Channel.findById(nFromChannelId);
        Documents documents = this.getDocuments(_methodContext);
        String sDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label59", "\u5f15\u7528\u6587\u6863");
        Reports reports = new Reports(sDesc);
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label60", "\u5f15\u7528\u5931\u8d25:\u6587\u6863[ID=") + documents.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                documents.removeAt(i, false);
                continue;
            }
            if (this.hasRight(loginUser, fromChannel, document, 34)) continue;
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label61", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[") + document.getTitle() + "]!", null);
            documents.removeAt(i, false);
        }
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        int nSize = toChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel toChannel = (Channel)toChannels.getAt(i);
            if (toChannel == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label63", "\u5f15\u7528\u5931\u8d25:\u680f\u76ee[ID=") + toChannels.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            reports.add(this.quote(loginUser, documents, fromChannel, toChannel));
        }
        return reports;
    }

    private Reports quote(User loginUser, Documents documents, Channel fromChannel, Channel toChannel) throws WCMException {
        String sDesc = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label64", "\u5728\u680f\u76ee[{0}]\u5f15\u7528\u6587\u6863"), new String[]{toChannel.getDispDesc()});
        Reports reports = new Reports(sDesc);
        if (!this.hasRight(loginUser, toChannel, null, 31)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label106", "\u5f15\u7528\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + loginUser.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + toChannel.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
            return reports;
        }
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            try {
                this.m_oDocumentMgr.quoteTo(document, fromChannel, toChannel);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label107", "\u5f15\u7528\u6587\u6863[{0}]\u6210\u529f\uff01"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label108", "\u5f15\u7528\u6587\u6863[{0}]\u5931\u8d25\uff01"), new String[]{document.getTitle()}), e);
            }
        }
        return reports;
    }

    public void changeOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document fromDocument = this.findDocumentById(_methodContext.getValue("FromDocId", 0));
        Document toDocument = this.findDocumentById(_methodContext.getValue("ToDocId", 0));
        Channel channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        int nPosition = _methodContext.getValue("Position", 1);
        if (!DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, fromDocument, 62)) {
            throw new WCMException(1002, CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label111", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[{0}][ID=[{1}]\u4e0b\u6539\u53d8\u8bb0\u5f55\u987a\u5e8f\uff01"), new Object[]{channel.toString(), new Integer(channel.getId())}));
        }
        this.validateRight(loginUser, channel, 62, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label68", "\u6539\u53d8\u6587\u6863\u987a\u5e8f"));
        this.m_oDocumentMgr.moveDocumentInChannel(fromDocument, toDocument, channel, nPosition);
    }

    public String export(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Documents documents = Documents.findByIds(loginUser, _methodContext.getObjectIds());
        String sExportFields = _methodContext.getValue("ExportFields");
        boolean bExportAppendix = _methodContext.getValue("ExportAppendix", false);
        this.validateRight(loginUser, null, documents, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label69", "\u5bfc\u51fa\u6587\u6863"));
        DocumentExporter exporter = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        String sExportFile = exporter.export(documents, sExportFields, bExportAppendix);
        _methodContext.setContentTypeIsHTML();
        return sExportFile;
    }

    public String importDocuments(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        String sImportXMLFile = _methodContext.getValue("ImportFile");
        String sImportXSLFile = _methodContext.getValue("ImportXSLFile");
        boolean bImportByChnlName = _methodContext.getValue("ImportByChnlName", true);
        boolean bImportToCurrChannel = _methodContext.getValue("ImportToCurrChannel", true);
        boolean bIgnoreTitleSim = _methodContext.getValue("IgnoreTitleSim", true);
        boolean zTrsFile = _methodContext.getValue("IsTrsServerFile", false);
        this.validateRight(loginUser, channelOrSite, 31, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label70", "\u5bfc\u5165\u6587\u6863"));
        DocumentImporter importer = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        if (zTrsFile) {
            return importer.importFromTRSFile(sImportXMLFile, channelOrSite.isSite() ? null : (Channel)channelOrSite, sImportXSLFile, bIgnoreTitleSim, bImportToCurrChannel).toJSONXML();
        }
        return importer.importFromFile(sImportXMLFile, channelOrSite.isSite() ? null : (Channel)channelOrSite, sImportXSLFile, bIgnoreTitleSim, bImportToCurrChannel, bImportByChnlName).toJSONXML();
    }

    public Relations queryRelations(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(nDocId);
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(loginUser, null, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label71", "\u83b7\u53d6\u76f8\u5173\u6587\u6863\u4fe1\u606f"));
        }
        return this.m_oRelationMgr.getRelations(document, extraFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRelation(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(nDocId);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!loginUser.isAdministrator() && !loginUser.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(loginUser, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label72", "\u8bbe\u7f6e\u76f8\u5173\u6587\u6863"));
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new Relation());
        xmlToCMSObj.parse(_methodContext.getValue("RelationsXML"));
        this.m_oRelationMgr.deleteUnuseRelations(xmlToCMSObj.getObjectIds(), document);
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                Relation relation = (Relation)xmlToCMSObj.getCMSObjs()[i];
                if (relation == null) continue;
                if (relation.isAddMode()) {
                    relation.setDocId(nDocId);
                } else if (i + 1 == relation.getSerialNo()) {
                    relation.cancelUpdate(loginUser);
                    continue;
                }
                relation.setProperty("SERN", i + 1);
                relation.save(loginUser);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
    }

    public Documents queryRecycle(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methContext);
        this.validateRight(loginUser, channelOrSite, 30, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label8", "\u83b7\u53d6\u6587\u6863\u5217\u8868"));
        WCMFilter extraFilter = new WCMFilter(_methContext.getQueryFilter());
        return this.m_oDocumentMgr.getRecycleDocuments(channelOrSite, extraFilter);
    }

    public void restore(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        this.validateRight(loginUser, channelOrSite, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label73", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        boolean bRestoreAll = _methodContext.getValue("RestoreAll", false);
        Documents documents = null;
        documents = bRestoreAll ? this.m_oDocumentMgr.getRecycleDocuments(channelOrSite, null) : Documents.findByIds(loginUser, _methodContext.getObjectIds());
        Channel currChannel = channelOrSite.isSite() ? null : (Channel)channelOrSite;
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.m_oDocumentMgr.restore(document, currChannel);
        }
    }

    public void clearRecycle(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        this.validateRight(loginUser, channelOrSite, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label74", "\u6e05\u7a7a\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        this.m_oDocumentMgr.clearAll(loginUser, channelOrSite);
    }

    public Appendixes queryAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        int nDocId = _methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(nDocId);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(loginUser, null, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label75", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f"));
        }
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(document, nAppendixType, extraFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        int nDocId = _methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(nDocId);
        FilesMan filesMan = FilesMan.getFilesMan();
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!loginUser.isAdministrator() && !loginUser.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(loginUser, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label76", "\u8bbe\u7f6e\u9644\u4ef6"));
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new Appendix());
        xmlToCMSObj.parse(_methodContext.getValue("AppendixesXML"));
        this.m_oAppendixMgr.deleteUnuseAppendixes(document, xmlToCMSObj.getObjectIds(), nAppendixType);
        boolean bException = true;
        boolean bAttachPic = false;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                boolean bValid;
                Appendix appendix = (Appendix)xmlToCMSObj.getCMSObjs()[i];
                if (appendix == null) continue;
                appendix.setSerialNo(i + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(nAppendixType);
                    appendix.setDocId(nDocId);
                    this.m_oAppendixMgr.addAppendix(document, appendix);
                } else {
                    this.m_oAppendixMgr.editAppendix(document, appendix);
                }
                if (bAttachPic || appendix.getFlag() != 20) continue;
                String sMinLimit = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
                int[] nMinLimit = CMyString.splitToInt(sMinLimit, ",");
                String sFileName = appendix.getFile();
                String sFilePath = filesMan.mapFilePath(sFileName, 0) + sFileName;
                bAttachPic = bValid = FileHelper.validImageFile(sFilePath, nMinLimit[0], nMinLimit[1]);
            }
            bException = false;
            if (nAppendixType == 60 || nAppendixType == 20) {
                WCMDocumentHelper.setAttachPicOfDocument(document, bAttachPic);
            }
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        int nDocId = _methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(nDocId);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && nDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!loginUser.isAdministrator() && !loginUser.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(loginUser, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label76", "\u8bbe\u7f6e\u9644\u4ef6"));
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new Appendix());
        xmlToCMSObj.parse(_methodContext.getValue("AppendixesXML"));
        boolean bException = true;
        boolean bAttachPic = false;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                Appendix appendix = (Appendix)xmlToCMSObj.getCMSObjs()[i];
                if (appendix == null) continue;
                appendix.setSerialNo(i + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(nAppendixType);
                    appendix.setDocId(nDocId);
                    this.m_oAppendixMgr.addAppendix(document, appendix);
                } else {
                    this.m_oAppendixMgr.editAppendix(document, appendix);
                }
                if (appendix.getFlag() != 20) continue;
                bAttachPic = true;
            }
            bException = false;
            if (nAppendixType == 60 || nAppendixType == 20) {
                document.validCanEditAndLock(loginUser);
                document.setProperty("AttachPic", bAttachPic ? 1L : 0L);
                document.save(loginUser);
            }
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
    }

    public void changeStatus(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel channelOrSite = this.makeCurrChannelOrSite(_methodContext);
        Documents documents = Documents.findByIds(loginUser, _methodContext.getObjectIds());
        Status status = Status.findById(_methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label77", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(loginUser, channelOrSite, status.getRightIndex(), I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label78", "\u6539\u53d8\u6587\u6863\u72b6\u6001"));
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.m_oDocumentMgr.changeStatus(document, channelOrSite.isSite() ? document.getChannel() : (Channel)channelOrSite, status.getId());
        }
    }

    private PageOperators makeDocumentOpertators(User _loginUser, BaseChannel _channelOrSite, int _nObjectId) throws WCMException {
        Document document = Document.findById(_nObjectId);
        if (document == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label79", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ID=") + _nObjectId + "]\uff01");
        }
        PageOperators operators = this.m_oCustomizeMgr.getPageOpertators(_loginUser, "document", new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
        if (_loginUser.isAdministrator()) {
            return operators;
        }
        for (int i = operators.size() - 1; i >= 0; --i) {
            PageOperator operator = (PageOperator)operators.getAt(i);
            if (operator == null || operator.getRightIndex() >= 0 || DocumentAuthServer.hasRight(_loginUser, _channelOrSite, document, operator.getRightIndex())) continue;
            operators.removeAt(i, false);
        }
        return operators;
    }

    private PageOperators makeDocumentsOpertators(User _loginUser, BaseChannel _channelOrSite, String _sObjectIds) throws WCMException {
        Documents documents = Documents.findByIds(_loginUser, _sObjectIds);
        if (documents.isEmpty()) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label80", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ObjectIds=") + _sObjectIds + "]\uff01");
        }
        if (documents.size() == 1) {
            return this.makeDocumentOpertators(_loginUser, _channelOrSite, documents.getIdAt(0));
        }
        PageOperators operators = this.m_oCustomizeMgr.getPageOpertators(_loginUser, "documents", new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
        if (_loginUser.isAdministrator()) {
            return operators;
        }
        for (int i = operators.size() - 1; i >= 0; --i) {
            PageOperator operator = (PageOperator)operators.getAt(i);
            if (operator == null || operator.getRightIndex() >= 0 || DocumentAuthServer.hasRight(_loginUser, _channelOrSite, documents, operator.getRightIndex())) continue;
            operators.removeAt(i, false);
        }
        return operators;
    }

    private void addFilters(Element _parent) {
        Element filters = _parent.addElement("Filters");
        for (int i = 0; i < ServiceConstants.FILTERS_DOCUMENTS_DEFAULT.length; ++i) {
            filters.addElement("Filter").addAttribute("Name", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][0]).addAttribute("Type", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][1]).addAttribute("IsDefault", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][2]);
        }
    }

    private void addFileds(Element _parent) {
        Element filters = _parent.addElement("DisplayFields");
        for (int i = 0; i < DEFAULT_FIELDS.length; ++i) {
            filters.addElement("Field").addAttribute("Name", DEFAULT_FIELDS[i][0]).addAttribute("Desc", DEFAULT_FIELDS[i][1]).addAttribute("IsOrder", DEFAULT_FIELDS[i][2]);
        }
    }

    private String getFolderPath(BaseChannel _channelOrSite) throws WCMException {
        if (_channelOrSite.isSite()) {
            return _channelOrSite.getDesc();
        }
        return this.getFolderPath(_channelOrSite.getHost()) + ">>" + _channelOrSite.getDesc();
    }

    private WCMFilter makeFilterByType(User _loginUser, WebSite _currSite, int _nFilterType) throws Exception {
        WCMFilter filter = new WCMFilter();
        String sWhere = null;
        switch (_nFilterType) {
            case 1: {
                sWhere = "DocStatus=?";
                filter.addSearchValues(0, 1);
                break;
            }
            case 3: {
                sWhere = "DocStatus=?";
                filter.addSearchValues(0, 10);
                break;
            }
            case 2: {
                IFolderPubStatusCacheMgr oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                int[] pStatus = oCacheMgr.findStatusesCanDoIncreasePub(_currSite.getWCMType(), _currSite.getId());
                if (pStatus == null) {
                    pStatus = new int[]{-1};
                }
                for (int i = 0; i < pStatus.length; ++i) {
                    sWhere = sWhere == null ? "DocStatus in(?" : sWhere + ",?";
                    filter.addSearchValues(i, pStatus[i]);
                }
                if (sWhere == null) break;
                sWhere = sWhere + ")";
                break;
            }
            case 4: {
                sWhere = "CrUser=?";
                filter.addSearchValues(0, _loginUser.getName());
                break;
            }
            case 5: {
                sWhere = "CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                break;
            }
            case 6: {
                sWhere = "CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                break;
            }
            case 7: {
                sWhere = "CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                break;
            }
        }
        filter.setWhere(sWhere);
        return filter;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Document findDocumentById(int _nDocId) throws WCMException {
        Document document = Document.findById(_nDocId);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nDocId), WCMTypes.getLowerObjName(605)}));
        }
        return document;
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nObjectId), WCMTypes.getLowerObjName(101)}));
        }
        return channel;
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, Documents _documents, int _nRightIndex, String _sOperDesc) throws WCMException {
        int nSize = _documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) continue;
            this.validateRight(_loginUser, _channelOrSite, document, _nRightIndex, _sOperDesc);
        }
    }

    private void removeDocumentNotHasRight(User _loginUser, BaseChannel _channelOrSite, Documents _documents, int _nRightIndex, MethodContext _methodContext) throws WCMException {
        int nPageSize = -1;
        int nPageIndex = 1;
        nPageSize = _methodContext.getPageSize();
        nPageIndex = _methodContext.getPageIndex();
        CPager currPager = new CPager(nPageSize);
        currPager.setCurrentPageIndex(nPageIndex);
        currPager.setItemCount(_documents.size());
        int nDataCount = currPager.getLastItemIndex() - currPager.getFirstItemIndex() + 1;
        if (nDataCount > 300) {
            return;
        }
        for (int i = currPager.getLastItemIndex(); i >= currPager.getFirstItemIndex(); --i) {
            Document document = (Document)_documents.getAt(i - 1);
            if (document == null || this.hasRight(_loginUser, _channelOrSite, document, _nRightIndex)) continue;
            _documents.removeAt(i, false);
        }
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, Document _document, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!this.hasRight(_loginUser, _channelOrSite, _document, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label84", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label85", "]\u6ca1\u6709\u6743\u9650") + _sOperDesc + ":" + _document + "\uff01");
        }
    }

    private boolean hasRight(User _loginUser, BaseChannel _channelOrSite, Document _document, int _nRightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, _channelOrSite, _document, _nRightIndex);
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_channelOrSite, _nRightIndex)) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label84", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728({1})\u4e0a\u6267\u884c[{2}]\u64cd\u4f5c\uff01"), new String[]{_loginUser.getName(), _channelOrSite.toString(), _sOperDesc}));
        }
    }

    private Reports transmit(User _loginUser, Channel _fromChannel, Documents _documents, Channels _toChannels, int _nTransmitType) throws WCMException {
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        String sOperDesc = null;
        sOperDesc = _fromChannel != null ? I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label89", "\u5728[") + _fromChannel + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label90", "]\u4e0a") + sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label91", "\u6587\u6863") : sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label91", "\u6587\u6863");
        Reports reports = new Reports(sOperDesc);
        Channel fromChannel = _fromChannel;
        int nFromChannelId = 0;
        if (fromChannel != null) {
            nFromChannelId = fromChannel.getId();
        }
        if (!_loginUser.isAdministrator()) {
            for (int j = _toChannels.size() - 1; j >= 0; --j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label92", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                    _toChannels.removeAt(j, false);
                    continue;
                }
                if (AuthServer.hasRight(_loginUser, (CMSObj)toChannel, 31)) continue;
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label93", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[") + toChannel + "].", null);
                _toChannels.removeAt(j, false);
            }
        }
        for (int i = _documents.size() - 1; i >= 0; --i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) {
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label94", "\u5931\u8d25:\u6587\u6863[ID=") + _documents.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel docChannel = null;
            docChannel = nFromChannelId == document.getChannelId() ? fromChannel : document.getChannel();
            if (!this.hasRight(_loginUser, docChannel, document, 34)) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label95", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + document.getId() + ",Title=" + document.getTitle() + "]!", null);
                continue;
            }
            int nChannelCount = _toChannels.size();
            for (int j = 0; j < nChannelCount; ++j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label92", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(docChannel, document, toChannel, _nTransmitType, reports);
            }
        }
        return reports;
    }

    private String makeTransmitDesc(int _nTransmitType) {
        String sTransmitDesc = null;
        switch (_nTransmitType) {
            case 1: {
                sTransmitDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label96", "\u590d\u5236");
                break;
            }
            case 2: {
                sTransmitDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label97", "\u5f15\u7528");
                break;
            }
            case 3: {
                sTransmitDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label98", "\u955c\u50cf");
            }
        }
        return sTransmitDesc;
    }

    private void transmit(Channel _fromChannel, Document _fromDocument, Channel _toChannel, int _nTransmitType, Reports reports) {
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        if (_toChannel.isVirtual()) {
            sTransmitDesc = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label97", "\u5f15\u7528");
        }
        try {
            IDocumentTransmitor transmitor = this.m_oDocumentTransmitorFactory.getTransmitor(_fromDocument);
            Report report = null;
            switch (_nTransmitType) {
                case 1: {
                    report = transmitor.copy(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                    break;
                }
                case 2: {
                    report = transmitor.quote(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                    break;
                }
                case 3: {
                    report = transmitor.mirror(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                }
            }
        }
        catch (Throwable e) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label100", "{0}\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25\uff01"), new String[]{sTransmitDesc, _fromDocument.getTitle(), _toChannel.getDispDesc()}), e);
        }
    }

    public void trsSaveToWCM(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sServerIds = _methodContext.getValue("ServerIds");
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel currChannel = Channel.findById(nChannelId);
        if (currChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label104", "\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        Document document = new Document();
        int nRightIndex = 80;
        if (!this.hasRight(loginUser, currChannel, document, nRightIndex)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label21", "\u60a8\u6ca1\u6709\u6743\u9650\u4fdd\u5b58\u6587\u6863![ObjectId=") + _methodContext.getObjectId() + "]");
        }
        DatasFromTRSServer currServer = new DatasFromTRSServer();
        currServer.setWhere("IR_SID=" + sServerIds);
        currServer.setSelect("IR_SID,IR_URLTITLE,IR_URLTIME,IR_ABSTRACT,IR_KEYWORDS,IR_AUTHORS,IR_CONTENT,IR_URLCONTENT");
        ArrayList result = new ArrayList();
        result = (ArrayList)currServer.getDatasFromTRSServer(_methodContext.getPageIndex(), _methodContext.getPageSize());
        if (result.size() <= 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label50", "\u672a\u627e\u5230IR_SID\u4e3a") + sServerIds + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label51", "\u7684TRSServer\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\uff01"));
        }
        String sAbstract = "";
        String sContent = "";
        for (int k = 0; k < result.size(); ++k) {
            try {
                HashMap currMap = (HashMap)result.get(k);
                if (currMap == null) continue;
                Document temp = new Document();
                temp.setType(20);
                temp.setChannel(currChannel);
                sAbstract = CMyString.transDisplay((String)currMap.get("IR_ABSTRACT"));
                sContent = CMyString.transDisplay((String)currMap.get("IR_URLCONTENT"));
                temp.setTitle((String)currMap.get("IR_URLTITLE"));
                temp.setAuthor((String)currMap.get("IR_AUTHORS"));
                temp.setKeywords((String)currMap.get("IR_KEYWORDS"));
                temp.setAbstract(sAbstract);
                temp.setContent(sContent);
                temp.setHtmlContent(sContent);
                this.m_oDocumentMgr.save(temp);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        DEFAULT_SELECT_FIELDS.append("DocId");
        for (int i = 0; i < DEFAULT_FIELDS.length; ++i) {
            DEFAULT_SELECT_FIELDS.append(",");
            DEFAULT_SELECT_FIELDS.append(DEFAULT_FIELDS[i][0]);
        }
    }
}

