/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.IDefaultFormatMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.DefaultFormat;
import com.trs.components.wcm.content.persistent.DefaultFormats;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DefaultFormatServiceProvider
implements IGlueServiceProvider {
    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label6", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_channelOrSite, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + _channelOrSite + I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label9", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
        }
    }

    public Object saveDefaultFormat(MethodContext _context) throws WCMException {
        BaseChannel obj;
        User currUser = ContextHelper.getLoginUser();
        int nObjtype = _context.getValue("ObjType", 0);
        int nObjId = _context.getValue("ObjId", 0);
        if (nObjtype == 101) {
            obj = this.findChannelById(nObjId);
            this.validateRight(currUser, obj, 13, I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label21", "\u65b0\u5efa\u680f\u76ee\u9ed8\u8ba4\u6392\u7248"));
        } else {
            obj = WebSite.findById(nObjId);
            this.validateRight(currUser, obj, 1, I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label22", "\u65b0\u5efa\u7ad9\u70b9\u9ed8\u8ba4\u6392\u7248"));
        }
        int nObjectId = DefaultFormat.getObjectId(nObjtype, nObjId);
        DefaultFormat defaultFormat = null;
        if (nObjectId == 0) {
            defaultFormat = new DefaultFormat();
        } else {
            defaultFormat = DefaultFormat.findById(nObjectId);
            if (defaultFormat == null) {
                throw new WCMException(I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label19", "\u6307\u5b9a\u7684\u9ed8\u8ba4\u6392\u7248\u914d\u7f6e\u4e0d\u5b58\u5728![ObjId=") + _context.getObjectId() + "]");
            }
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        defaultFormat = (DefaultFormat)WCMAJAXServiceHelper.setWCMObjectProperties(currUser, _context, defaultFormat, pLogicFields);
        defaultFormat.setAttribute(_context.getValue("Attribute"));
        defaultFormat.save(currUser);
        IDefaultFormatMgr defaultFormatMgr = (IDefaultFormatMgr)DreamFactory.createObjectById("IDefaultFormatMgr");
        defaultFormatMgr.copyCssFilesToDir(defaultFormat);
        return String.valueOf(defaultFormat.getId());
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        int nDefaultFormatId = _methodContext.getObjectId();
        DefaultFormat defaultFormat = DefaultFormat.findById(nDefaultFormatId);
        User loginUser = this.getLoginUser();
        if (defaultFormat != null && defaultFormat.canEdit(loginUser)) {
            defaultFormat.setAttribute(_methodContext.getValue("Attribute"));
            defaultFormat.save(loginUser);
        }
        return nDefaultFormatId;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        return null;
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        int nObjId = _methodContext.getValue("ObjId", 0);
        DefaultFormat defaultFormat = null;
        defaultFormat = nObjId == 0 ? new DefaultFormat() : DefaultFormat.findById(nObjId);
        return defaultFormat;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    public Object getDefaultFormatAttributes(MethodContext _context) throws WCMException {
        int nChannelId = _context.getValue("ObjId", 0);
        if (nChannelId == 0) {
            return null;
        }
        int[] nObjects = DefaultFormat.getObjType2Id(nChannelId);
        if (nObjects == null) {
            return null;
        }
        int nObjtype = nObjects[0];
        int nObjId = nObjects[1];
        int nObjectId = DefaultFormat.getObjectId(nObjtype, nObjId);
        DefaultFormat defaultFormat = null;
        String sAttributes = "";
        if (nObjectId == 0) {
            return sAttributes;
        }
        defaultFormat = DefaultFormat.findById(nObjectId);
        sAttributes = defaultFormat.getPropertyAsString("Attribute");
        boolean isWord = defaultFormat.getPropertyAsBoolean("FORWORD", true);
        sAttributes = isWord ? sAttributes + "isForWord:1;" : sAttributes + "isForWord:0;";
        return sAttributes;
    }

    public int getObjectId(int nObjtype, int nObjId) {
        WCMFilter aFilter = new WCMFilter("", "ObjId=?", "");
        aFilter.addSearchValues(nObjId);
        WCMFilter mergeFilter = new WCMFilter("", "ObjType=?", "");
        mergeFilter.addSearchValues(nObjtype);
        aFilter.mergeWith(mergeFilter);
        int nObjectId = 0;
        try {
            if (aFilter == null) {
                throw new WCMException(20, I18NMessage.get(DefaultFormatServiceProvider.class, "DefaultFormatServiceProvider.label9", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            DefaultFormats currDefaultFormats = DefaultFormats.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
            if (currDefaultFormats.size() > 0) {
                DefaultFormat currDefaultFormat = (DefaultFormat)currDefaultFormats.getAt(0);
                nObjectId = currDefaultFormat.getPropertyAsInt("DEFAULTFORMATID", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nObjectId;
    }
}

