/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.List;

public class ChnlDocServiceProvider
implements ISelfDefinedServiceProvider,
IDeleteServiceProvider {
    private DocumentMgr m_oDocumentMgr = null;
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;

    public ChnlDocServiceProvider() {
        this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    public void changeStatus(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Status status = Status.findById(_methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label1", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(loginUser, _methodContext.getObjectIds(), status.getRightIndex(), I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label2", "\u6539\u53d8\u6587\u6863\u72b6\u6001\u4e3a[") + status.getDisp() + "]");
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        int nSize = chnlDocs.size();
        for (int i = 0; i < nSize; ++i) {
            ChnlDoc chnldoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnldoc == null) continue;
            this.m_oDocumentMgr.changeStatus(status.getId(), chnldoc);
        }
    }

    public Reports copy(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 1);
    }

    public Reports quote(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 2);
    }

    public Reports mirror(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 3);
    }

    public Reports move(MethodContext _methodContext) throws Throwable {
        Channel toChannel;
        User loginUser = this.getLoginUser();
        if (!this.hasRight(loginUser, toChannel = this.findChannelById(_methodContext.getValue("ToChannelId", 0)), 31)) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label3", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u76ee\u6807\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[ID=") + toChannel.getId() + ",Name=" + toChannel.getDispDesc() + "]!", null);
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.move(loginUser, chnlDocs, toChannel);
    }

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bDrop = _methContext.getValue("Drop", false);
        this.validateRight(loginUser, _methContext.getObjectIds(), 33, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label4", "\u5220\u9664"));
        ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, _methContext.getObjectIds());
        int nSize = chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null || (channel = chnldoc.getChannel()) == null || (document = chnldoc.getDocument()) == null) continue;
            this.m_oDocumentMgr.delete(document, channel, bDrop);
        }
    }

    public String export(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Documents documents = this.findDocumentsByChnlDocIds(loginUser, _methodContext.getObjectIds());
        String sExportFields = _methodContext.getValue("ExportFields");
        boolean bExportAppendix = _methodContext.getValue("ExportAppendix", false);
        documents.setFilter(new WCMFilter("", "", "", sExportFields));
        this.validateRight(loginUser, null, documents, 34, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label5", "\u5bfc\u51fa\u6587\u6863"));
        DocumentExporter exporter = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        String sExportFile = exporter.export(documents, sExportFields, bExportAppendix);
        _methodContext.setContentTypeIsHTML();
        return sExportFile;
    }

    public void publish(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        int nPublishType = _methodContext.getValue("PublishType", 8);
        int nSize = chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null || (channel = chnldoc.getChannel()) == null || (document = chnldoc.getDocument()) == null) continue;
            this.publishDocument(loginUser, channel, document, nPublishType);
        }
    }

    private boolean publishDocument(User loginUser, Channel channel, Document document, int _nPublishType) throws WCMException {
        if (!this.hasRight(loginUser, channel, document, 39)) {
            return false;
        }
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        content.setFolder(folder);
        this.m_oPublishServer.publishContent(content, _nPublishType);
        return true;
    }

    private Reports transmit(User _loginUser, ChnlDocs _chnldocs, Channels _toChannels, int _nTransmitType) throws WCMException {
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        Reports reports = new Reports(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label6", "\u6587\u6863"));
        if (!_loginUser.isAdministrator()) {
            for (int j = _toChannels.size() - 1; j >= 0; --j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label7", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                    _toChannels.removeAt(j, false);
                    continue;
                }
                if (AuthServer.hasRight(_loginUser, (CMSObj)toChannel, 31)) continue;
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label9", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[ID=") + _toChannels.getIdAt(j) + ",Name=" + toChannel.getDispDesc() + "]!", null);
                _toChannels.removeAt(j, false);
            }
        }
        int nSize = _chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            ChnlDoc chnldoc = (ChnlDoc)_chnldocs.getAt(i);
            if (chnldoc == null) {
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label10", "\u5931\u8d25:\u6587\u6863[ID=") + _chnldocs.getIdAt(i) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel fromChannel = chnldoc.getChannel();
            if (fromChannel == null) {
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label11", "\u5931\u8d25:\u6587\u6863\u7684\u680f\u76ee[Id=") + chnldoc.getChannelId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document fromDocument = chnldoc.getDocument();
            if (fromDocument == null) {
                reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label13", "\u5931\u8d25:\u6587\u6863[Id=") + chnldoc.getDocId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(_loginUser, fromChannel, fromDocument, 34)) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label14", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + fromDocument.getId() + ",Title=" + fromDocument.getTitle() + "]!", null);
                continue;
            }
            int nChannelCount = _toChannels.size();
            for (int j = 0; j < nChannelCount; ++j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label7", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(fromChannel, fromDocument, toChannel, _nTransmitType, reports);
            }
        }
        return reports;
    }

    private void transmit(Channel _fromChannel, Document _fromDocument, Channel _toChannel, int _nTransmitType, Reports reports) {
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        if (_toChannel.isVirtual()) {
            sTransmitDesc = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label15", "\u5f15\u7528");
        }
        try {
            switch (_nTransmitType) {
                case 1: {
                    this.m_oDocumentMgr.copyDocument(_fromDocument, _fromChannel, _toChannel);
                    break;
                }
                case 2: {
                    this.m_oDocumentMgr.quoteTo(_fromDocument, _toChannel);
                    break;
                }
                case 3: {
                    this.m_oDocumentMgr.mirrorTo(_fromDocument, _toChannel);
                }
            }
            reports.addSucessedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label16", "\u6210\u529f") + sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label17", "\u6587\u6863[") + _fromDocument.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + _toChannel.getDispDesc() + "]\uff01");
        }
        catch (Throwable e) {
            reports.addFailedReport(sTransmitDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label17", "\u6587\u6863[") + _fromDocument.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + _toChannel.getDispDesc() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label19", "]\u5931\u8d25\uff01"), e);
        }
    }

    private String makeTransmitDesc(int _nTransmitType) {
        String sTransmitDesc = null;
        switch (_nTransmitType) {
            case 1: {
                sTransmitDesc = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label20", "\u590d\u5236");
                break;
            }
            case 2: {
                sTransmitDesc = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label15", "\u5f15\u7528");
                break;
            }
            case 3: {
                sTransmitDesc = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label21", "\u955c\u50cf");
            }
        }
        return sTransmitDesc;
    }

    private Reports move(User _loginUser, ChnlDocs _chnldocs, Channel _toChannel) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label22", "\u79fb\u52a8\u6587\u6863"));
        int nSize = _chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            ChnlDoc chnldoc = (ChnlDoc)_chnldocs.getAt(i);
            if (chnldoc == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label23", "\u79fb\u52a8\u5931\u8d25:\u6587\u6863[ID=") + _chnldocs.getIdAt(i) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel fromChannel = chnldoc.getChannel();
            if (fromChannel == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label24", "\u79fb\u52a8\u5931\u8d25:\u5f85\u590d\u5236\u7684\u6587\u6863\u7684\u680f\u76ee[Id=") + chnldoc.getChannelId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document fromDocument = chnldoc.getDocument();
            if (fromDocument == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label25", "\u79fb\u52a8\u5931\u8d25:\u5f85\u590d\u5236\u7684\u6587\u6863[Id=") + chnldoc.getDocId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(_loginUser, fromChannel, fromDocument, 33)) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label26", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + fromDocument.getId() + ",Title=" + fromDocument.getTitle() + "]!", null);
                continue;
            }
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(fromDocument, fromChannel, _toChannel));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label27", "\u79fb\u52a8\u6587\u6863[") + fromDocument.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + fromChannel.getDispDesc() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label19", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    public ChnlDocs search(MethodContext _methContext) throws WCMException {
        String sEndWhereSQL;
        String sStartWhereSQL;
        User loginUser = this.getLoginUser();
        CMSBaseObjs objects = null;
        String sChannelIds = _methContext.getValue("ChannelIds");
        String sSiteIds = _methContext.getValue("SiteIds");
        String sFromTable = _methContext.getValue("FromTable");
        boolean bFromMultTable = sFromTable != null && sFromTable.indexOf(44) > 0;
        boolean bSearchChannel = false;
        if (sChannelIds != null && sChannelIds.length() > 0) {
            objects = Channels.findByIds(loginUser, sChannelIds);
            sStartWhereSQL = (bFromMultTable ? "WCMDocument.DocId=WCMChnlDoc.DocId and WCMDocument.DocChannel>0 and " : "") + "WCMChnlDoc.DocStatus>0 and WCMChnlDoc.ChnlId in(";
            sEndWhereSQL = ")";
            bSearchChannel = true;
        } else if (sSiteIds != null && sSiteIds.length() > 0) {
            objects = WebSites.findByIds(loginUser, sSiteIds);
            sStartWhereSQL = (bFromMultTable ? "WCMDocument.DocId=WCMChnlDoc.DocId and WCMDocument.DocChannel>0 and " : "") + "WCMChnlDoc.DocStatus>0 and exists(Select ChannelId from WCMChannel where Status>=0 and SiteId in(";
            sEndWhereSQL = ") and WCMChannel.ChannelId=WCMChnlDoc.ChnlId)";
        } else {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label28", "\u6ca1\u6709\u6307\u5b9a\u68c0\u7d22\u7684\u680f\u76ee[ChannelIds]\u6216\u8005\u68c0\u7d22\u7684\u7ad9\u70b9[SiteIds]\uff01"));
        }
        if (bSearchChannel && _methContext.getValue("ContainsChildren", false)) {
            int nSize = objects.size();
            for (int i = 0; i < nSize; ++i) {
                Channel channel = (Channel)objects.getAt(i);
                if (channel == null) continue;
                this.makeChildren((Channels)objects, channel);
            }
        }
        StringBuffer sbWhere = new StringBuffer(sStartWhereSQL.length() + objects.size() * 2 + sEndWhereSQL.length() + 4);
        sbWhere.append(sStartWhereSQL);
        WCMFilter filter = new WCMFilter();
        boolean bFirst = true;
        int nSize = objects.size();
        for (int i = 0; i < nSize; ++i) {
            BaseChannel channel = (BaseChannel)objects.getAt(i);
            if (channel == null || !this.isValidateRight(loginUser, channel, 30)) continue;
            if (!bFirst) {
                sbWhere.append(',');
            } else {
                bFirst = false;
            }
            sbWhere.append('?');
            filter.addSearchValues(channel.getId());
        }
        sbWhere.append(sEndWhereSQL);
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_methContext.getExtraWCMFilter());
        filter.mergeWith(this.makeTimeFilterByType(_methContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        filter.mergeWith(this.makeTimeFilterByType(_methContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        return ChnlDocs.openWCMObjs(loginUser, filter);
    }

    private boolean hasRight(User _loginUser, Channel _channel, Document _document, int _nRightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, (BaseChannel)_channel, _document, _nRightIndex);
    }

    private boolean hasRight(User _loginUser, Channel _channel, int _nRightIndex) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(_loginUser, (CMSObj)_channel, _nRightIndex);
    }

    private Channels findChannelsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "RecId in(" + _sChnlDocIds + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs(_loginUser, filter);
    }

    private Documents findDocumentsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "RecId in(" + _sChnlDocIds + ")", "", "DocId");
        return Documents.openWCMObjs(_loginUser, filter);
    }

    private void validateRight(User _loginUser, String _sChnlDocIds, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        Channels channels = this.findChannelsByChnlDocIds(_loginUser, _sChnlDocIds);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || AuthServer.hasRight(_loginUser, (CMSObj)channel, _nRightIndex)) continue;
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label29", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label30", "]\u6ca1\u6709\u6743\u9650\u5728(") + channel + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label31", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label32", "]\u64cd\u4f5c\uff01"));
        }
    }

    private void validateRight(User _loginUser, Channel _channelOrSite, Documents _documents, int _nRightIndex, String _sOperDesc) throws WCMException {
        int nSize = _documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) continue;
            this.validateRight(_loginUser, _channelOrSite, document, _nRightIndex, _sOperDesc);
        }
    }

    private void validateRight(User _loginUser, Channel _channelOrSite, Document _document, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!this.hasRight(_loginUser, _channelOrSite, _document, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label29", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label33", "]\u6ca1\u6709\u6743\u9650") + _sOperDesc + ":" + _document + "\uff01");
        }
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label34", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void makeChildren(Channels _oRecordChannels, Channel _parent) throws WCMException {
        List<Channel> lChildren = _parent.getChildren(null);
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Channel child = lChildren.get(i);
            if (child == null) continue;
            _oRecordChannels.addElement(child);
            this.makeChildren(_oRecordChannels, child);
        }
    }

    private WCMFilter makeTimeFilterByType(int _nFilterType, String _sTimeField) throws WCMException {
        WCMFilter filter = new WCMFilter("", _sTimeField + ">=?", "");
        try {
            switch (_nFilterType) {
                case 5: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label35", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), e);
        }
        return filter;
    }

    private boolean isValidateRight(User _loginUser, BaseChannel _channelOrSite, int _nRightIndex) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(_loginUser, (CMSObj)_channelOrSite, _nRightIndex);
    }
}

